<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * ChSalleRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChSalleRepository extends EntityRepository
{

    public function getChSalle($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.salle_id', 's')
            ->addSelect('s')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getCh1Salle($idSalleCh)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.salle_id', 's')
            ->addSelect('s')
            ->where('c.id = :idSalleCh')
            ->setParameter('idSalleCh', $idSalleCh)
        ;

        $result = $query->getQuery()->getSingleResult();
        return $result;
    }
    
    public function getHeureSalles($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chlocations', 'l')
            ->addSelect('l')
            ->join('c.salle_id', 's')
            ->addSelect('s')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $id)
            ->addOrderBy('s.nom', 'ASC')
            ->addOrderBy('l.jour', 'ASC')
            ->addOrderBy('l.heureDebut', 'ASC')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }
    
}
