<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChSalle
 *
 * @ORM\Table(name="ChSalle")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChSalleRepository")
 */
class ChSalle
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="chSalles")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat", inversedBy="chSalles")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="Salle", inversedBy="salles")
     * @ORM\JoinColumn(name="salle_id", referencedColumnName="id")
     */
    protected $salle_id;

    /**
     * @ORM\OneToMany(targetEntity="ChContrainteSalle", mappedBy="chsalle_id")
     *
     */
    private $chContraintes;

    /**
     * @ORM\OneToMany(targetEntity="ChLocation", mappedBy="chsalle_id")
     *
     */
    private $chlocations;

    /**
     * @Gedmo\Slug(handlers={
     *      @Gedmo\SlugHandler(class="Gedmo\Sluggable\Handler\RelativeSlugHandler", options={
     *          @Gedmo\SlugHandlerOption(name="relationField", value="salle_id"),
     *          @Gedmo\SlugHandlerOption(name="relationSlugField", value="slug"),
     *          @Gedmo\SlugHandlerOption(name="separator", value="-"),
     *          @Gedmo\SlugHandlerOption(name="urilize", value=true)
     *      })
     * },fields={"createdAt"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return mixed
     */
    public function getChlocations()
    {
        return $this->chlocations;
    }

    /**
     * @param mixed $chlocations
     */
    public function setChlocations($chlocations)
    {
        $this->chlocations = $chlocations;
    }

     /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

    /**
     * @return mixed
     */
    public function getSalleId()
    {
        return $this->salle_id;
    }

    /**
     * @param mixed $salle_id
     */
    public function setSalleId($salle_id)
    {
        $this->salle_id = $salle_id;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set tarifHeure
     *
     * @param integer $tarifHeure
     * @return ChSalle
     */
    public function setTarifHeure($tarifHeure)
    {
        $this->tarifHeure = $tarifHeure;

        return $this;
    }

    /**
     * Get tarifHeure
     *
     * @return integer 
     */
    public function getTarifHeure()
    {
        return $this->tarifHeure;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Add chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     * @return ChSalle
     */
    public function addChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations[] = $chlocations;

        return $this;
    }

    /**
     * Remove chlocations
     *
     * @param \sws\Bundle\BackBundle\Entity\ChLocation $chlocations
     */
    public function removeChlocation(\sws\Bundle\BackBundle\Entity\ChLocation $chlocations)
    {
        $this->chlocations->removeElement($chlocations);
    }

    /**
     * @return mixed
     */
    public function getChContraintes()
    {
        return $this->chContraintes;
    }

    /**
     * @param mixed $chContraintes
     */
    public function setChContraintes($chContraintes)
    {
        $this->chContraintes = $chContraintes;
    }




}
