<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChRencontreReject
 *
 * @ORM\Table(name="ChRencontreReject")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChRencontreRejectRepository")
 */
class ChRencontreReject
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbContrainte", type="integer")
     */
    private $nbContrainte;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChDivision")
     * @ORM\JoinColumn(name="chdivision_id", referencedColumnName="id")
     */
    protected $chdivision_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipeVisitee_id", referencedColumnName="id")
     */
    protected $chequipeVisitee_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationVisitee_id", referencedColumnName="id")
     */
    protected $chcorporationVisitee_id;        

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipeVisiteuse_id", referencedColumnName="id")
     */
    protected $chequipeVisiteuse_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationVisiteuse_id", referencedColumnName="id")
     */
    protected $chcorporationVisiteuse_id;     

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

    /**
     * @return mixed
     */
    public function getChdivisionId()
    {
        return $this->chdivision_id;
    }

    /**
     * @param mixed $chdivision_id
     */
    public function setChdivisionId($chdivision_id)
    {
        $this->chdivision_id = $chdivision_id;
    }

    /**
     * @return mixed
     */
    public function getChequipeVisiteeId()
    {
        return $this->chequipeVisitee_id;
    }

    /**
     * @param mixed $chequipeVisitee_id
     */
    public function setChequipeVisiteeId($chequipeVisitee_id)
    {
        $this->chequipeVisitee_id = $chequipeVisitee_id;
    }

    /**
     * @return mixed
     */
    public function getChequipeVisiteuseId()
    {
        return $this->chequipeVisiteuse_id;
    }

    /**
     * @param mixed $chequipeVisiteuse_id
     */
    public function setChequipeVisiteuseId($chequipeVisiteuse_id)
    {
        $this->chequipeVisiteuse_id = $chequipeVisiteuse_id;
    }




    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nbContrainte
     *
     * @param integer $nbContrainte
     * @return ChRencontreReject
     */
    public function setNbContrainte($nbContrainte)
    {
        $this->nbContrainte = $nbContrainte;

        return $this;
    }

    /**
     * Get nbContrainte
     *
     * @return integer 
     */
    public function getNbContrainte()
    {
        return $this->nbContrainte;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set chcorporationVisitee_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteeId
     * @return ChRencontreReject
     */
    public function setChcorporationVisiteeId(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteeId = null)
    {
        $this->chcorporationVisitee_id = $chcorporationVisiteeId;

        return $this;
    }

    /**
     * Get chcorporationVisitee_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationVisiteeId()
    {
        return $this->chcorporationVisitee_id;
    }

    /**
     * Set chcorporationVisiteuse_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteuseId
     * @return ChRencontreReject
     */
    public function setChcorporationVisiteuseId(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteuseId = null)
    {
        $this->chcorporationVisiteuse_id = $chcorporationVisiteuseId;

        return $this;
    }

    /**
     * Get chcorporationVisiteuse_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationVisiteuseId()
    {
        return $this->chcorporationVisiteuse_id;
    }
}
