<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\ResultSetMapping;

/**
 * ChPlanningRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChPlanningRepository extends EntityRepository
{
    public function getMaxDateRencontreEquipe($idEquipeCh, $idChampionnat)
    {
        $query = $this->createQueryBuilder('e')
            ->select('max(e.dateRencontre)')
            ->where('e.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('e.chequipeVisitee_id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idEquipeCh)
            ->orWhere('e.chequipeVisiteuse_id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idEquipeCh)
        ;

        $result = $query->getQuery()->getSingleScalarResult();
        
        return $result;
    }   

    /* Remplacée par la V2!! */
    public function getSlotRencontre($idChampionnat, $date_borne_inferieure, $contraintesExclusionSalle, $contraintesInclusionSalle, $contraintesExclusionJour, $contraintesInclusionJour)
    {
        $rsm = new ResultSetMapping();
        $rsm->addEntityResult('sws\Bundle\BackBundle\Entity\ChPlanning','p' );
        $rsm->addFieldResult('p', 'id', 'id');
        $rsm->addFieldResult('p', 'dateRencontre', 'dateRencontre');
      
        $sqlSelect           = 'select * ';
        $sqlFrom             = 'from ChPlanning p ';
        $sqlWhereChampionnat = 'where p.championnat_id = :idChampionnat ';
        $sqlDate             = 'and p.dateRencontre >= DATE_ADD(:date_borne_inferieure, INTERVAL 5 DAY) and ISNULL(p.chequipeVisitee_id) ';
        //$sqlDate             = 'and p.dateRencontre between DATE_ADD(:date_borne_inferieure, INTERVAL 5 DAY) and DATE_ADD(:date_borne_inferieure, INTERVAL 10 DAY) and ISNULL(p.chequipeVisitee_id) ';
        $sqlWhereExclusion   = 'and p.chsalle_id not in ('.$contraintesExclusionSalle.') and (DAYOFWEEK(p.dateRencontre) - 1) not in('.$contraintesExclusionJour.') ';
        
        if ($contraintesInclusionSalle <> ''){
            
            $sqlWhereInclusion1   = 'and p.chsalle_id in ('.$contraintesInclusionSalle.') ';
            
        }
        else{
            $sqlWhereInclusion1 = '';
        }
        
        if ($contraintesInclusionJour <> ''){
            
            $sqlWhereInclusion2   = 'and (DAYOFWEEK(p.dateRencontre) - 1) in('.$contraintesInclusionJour.') ';
            
        }
        else{
            $sqlWhereInclusion2 = '';
        }
        
         
        //$sqlWhereInclusion   = '';
        $sqlOrder            = 'order by p.dateRencontre ASC ';
        $sqlLimit            = 'limit 1 ';

        $sqlComplete = $sqlSelect.$sqlFrom.$sqlWhereChampionnat.$sqlDate.$sqlWhereExclusion.$sqlWhereInclusion1.$sqlWhereInclusion2.$sqlOrder.$sqlLimit;

        $query = $this->_em->createNativeQuery($sqlComplete, $rsm);

        $query
            ->setParameter('idChampionnat', $idChampionnat)
            ->setParameter('date_borne_inferieure', $date_borne_inferieure)
        ;

        $result = $query->getResult();     

        return $result;
    }
    
    public function getSlotRencontreV2($idChampionnat, $date_borne_inferieure, $contraintesExclusionSalle, $contraintesEquipe1InclusionSalle, $contraintesEquipe2InclusionSalle, $contraintesExclusionJour, $contraintesEquipe1InclusionJour, $contraintesEquipe2InclusionJour, $ContraintePeriodeEquipesExclusion, $checkVacances, $vacancesScolaires)
    {
        $rsm = new ResultSetMapping();
        $rsm->addEntityResult('sws\Bundle\BackBundle\Entity\ChPlanning','p' );
        $rsm->addFieldResult('p', 'id', 'id');
        $rsm->addFieldResult('p', 'dateRencontre', 'dateRencontre');
      
        $sqlSelect           = 'select * ';
        $sqlFrom             = 'from ChPlanning p ';
        $sqlWhereChampionnat = 'where p.championnat_id = :idChampionnat ';
        $sqlDate             = 'and p.dateRencontre >= DATE_ADD(:date_borne_inferieure, INTERVAL 8 DAY) and ISNULL(p.chequipeVisitee_id) ';
        //$sqlDate             = 'and p.dateRencontre between DATE_ADD(:date_borne_inferieure, INTERVAL 5 DAY) and DATE_ADD(:date_borne_inferieure, INTERVAL 10 DAY) and ISNULL(p.chequipeVisitee_id) ';
        $sqlWhereExclusion   = 'and p.chsalle_id not in ('.$contraintesExclusionSalle.') and (DAYOFWEEK(p.dateRencontre) - 1) not in('.$contraintesExclusionJour.') ';
        
        if ($contraintesEquipe1InclusionSalle <> '' && $contraintesEquipe2InclusionSalle <> ''){
            
            
            $sqlWhereInclusion1   = 'and p.chsalle_id in ('.$contraintesEquipe1InclusionSalle.') and p.chsalle_id in ('.$contraintesEquipe2InclusionSalle.') ';
            
        }
        elseif ($contraintesEquipe1InclusionSalle <> '' && $contraintesEquipe2InclusionSalle == ''){
            
            $sqlWhereInclusion1   = 'and p.chsalle_id in ('.$contraintesEquipe1InclusionSalle.') ';
        }
        elseif($contraintesEquipe1InclusionSalle == '' && $contraintesEquipe2InclusionSalle <> ''){
            
            $sqlWhereInclusion1   = 'and p.chsalle_id in ('.$contraintesEquipe2InclusionSalle.') ';
        }
        else{
            $sqlWhereInclusion1 = '';            
        }
        
        
        if ($contraintesEquipe1InclusionJour <> '' && $contraintesEquipe2InclusionJour <> ''){
            
            $sqlWhereInclusion2   = 'and (DAYOFWEEK(p.dateRencontre) - 1) in('.$contraintesEquipe1InclusionJour.') and (DAYOFWEEK(p.dateRencontre) - 1) in('.$contraintesEquipe2InclusionJour.') ';
            
        }
        elseif($contraintesEquipe1InclusionJour <> '' && $contraintesEquipe2InclusionJour == ''){
            
             $sqlWhereInclusion2   = 'and (DAYOFWEEK(p.dateRencontre) - 1) in('.$contraintesEquipe1InclusionJour.') ';
        }
        elseif($contraintesEquipe1InclusionJour == '' && $contraintesEquipe2InclusionJour <> ''){
            
             $sqlWhereInclusion2   = 'and (DAYOFWEEK(p.dateRencontre) - 1) in('.$contraintesEquipe2InclusionJour.') ';
        }        
        else{
            $sqlWhereInclusion2 = '';
        }
        
        $sqlWhereExclusionVacancesScolaire = '';
        
        if ($checkVacances == 1){
            foreach ($vacancesScolaires as $keys => $periode) {
                
                $sqlWhereExclusionVacancesScolaire   = $sqlWhereExclusionVacancesScolaire.'and p.dateRencontre not between "'.date("Y-m-d",$periode->getPeriodeDebut()->getTimestamp()).'" and "'.date("Y-m-d",$periode->getPeriodeFin()->getTimestamp()).'" ';
                
            }            
        }

        $sqlWhereExclusionPeriode = '';

        if (!$ContraintePeriodeEquipesExclusion) {

            $sqlWhereExclusionPeriode = '';

        }
        else{

            foreach ($ContraintePeriodeEquipesExclusion as $keys => $periode) {

                $sqlWhereExclusionPeriode   = $sqlWhereExclusionPeriode.'and p.dateRencontre not between "'.date("Y-m-d",$periode->getPeriodeDebut()->getTimestamp()).'" and "'.date("Y-m-d",$periode->getPeriodeFin()->getTimestamp()).'" ';

            }
        }


        
        //$sqlWhereInclusion   = '';
        $sqlOrder            = 'order by p.dateRencontre ASC ';
        $sqlLimit            = 'limit 1 ';

        $sqlComplete = $sqlSelect.$sqlFrom.$sqlWhereChampionnat.$sqlDate.$sqlWhereExclusion.$sqlWhereInclusion1.$sqlWhereInclusion2.$sqlWhereExclusionVacancesScolaire.$sqlWhereExclusionPeriode.$sqlOrder.$sqlLimit;

        $query = $this->_em->createNativeQuery($sqlComplete, $rsm);

        $query
            ->setParameter('idChampionnat', $idChampionnat)
            ->setParameter('date_borne_inferieure', $date_borne_inferieure)
        ;

        $result = $query->getResult();     

        return $result;
    }    

    public function deleteChPlanning($idChampionnat)
    {

        $query = $this->_em->createQuery("DELETE FROM sws\Bundle\BackBundle\Entity\ChPlanning p WHERE p.championnat_id = " .$idChampionnat);
        $result = $query->execute();

        return $result;

    }

    public function getRencontres($idChampionnat, $idDivisionCh, $idChsalle, $idChcorporation, $idChequipe, $Status)
    {
        $sqlSelect = 'SELECT p ';
        $sqlFrom = 'FROM sws\Bundle\BackBundle\Entity\ChPlanning p';
        $sqlWhereChampionnat = ' where p.championnat_id = '.$idChampionnat;
        $sqlWhereStatus = ' and p.status IN ('.$Status.')';
        $sqlWhereDivision = ' and p.chdivision_id = '.$idDivisionCh;
        $sqlWhereSalle = ' and p.chsalle_id = '.$idChsalle;
        $sqlWhereCorporation = ' and p.chcorporationVisitee_id = '.$idChcorporation.' or p.chcorporationVisiteuse_id = '.$idChcorporation;
        $sqlWhereEquipe = ' and p.chequipeVisitee_id = '.$idChequipe.' or p.chequipeVisiteuse_id = '.$idChequipe;

        $sqlComplete = $sqlSelect.$sqlFrom.$sqlWhereChampionnat;

        if ($Status <> '*'){ $sqlComplete = $sqlComplete.$sqlWhereStatus;};
        if ($idDivisionCh <> '*'){ $sqlComplete = $sqlComplete.$sqlWhereDivision;}
        if ($idChsalle <> '*'){ $sqlComplete = $sqlComplete.$sqlWhereSalle;}
        if ($idChcorporation <> '*'){ $sqlComplete = $sqlComplete.$sqlWhereCorporation;}
        if ($idChequipe <> '*'){ $sqlComplete = $sqlComplete.$sqlWhereEquipe;}

        $sqlWhereOrder = ' order by p.dateRencontre ASC';

        $sqlComplete = $sqlComplete.$sqlWhereOrder;

        $query = $this->_em->createQuery($sqlComplete);
        $results = $query->getResult();

        return $results;
    }

    public function getSlotsLibres($idChampionnat)
    {
        $query = $this->createQueryBuilder('p')
            ->join('p.chsalle_id', 'cs')
            ->addSelect('cs')
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('p.status = \'-\' ')
            ->orderBy('p.dateRencontre','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }

    public function getRencontreEnRetard($idChampionnat, $NbJourRetard)
    {
        //$date_temp = date_format(new \DateTime(), "Y-m-d") - 10;

        $NewDate=Date('Y-m-d', strtotime(" -".$NbJourRetard." days"));

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere("p.dateRencontre <= :NewDate")
            ->setParameter('NewDate', $NewDate)
            ->andWhere("p.status = 'N' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();
        
        return $result;
    }

    public function getRencontreAVenir($idChampionnat)
    {
        $Now = new \DateTime();

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere("p.dateRencontre > :NewDate")
            ->setParameter('NewDate', $Now)
            ->andWhere("p.status = 'N' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }

    public function getRencontreAEncoder($idChampionnat)
    {
        //$date_temp = date_format(new \DateTime(), "Y-m-d") - 10;

        $Now = new \DateTime();

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere("p.dateRencontre <= :NewDate")
            ->setParameter('NewDate', $Now)
            ->andWhere("p.status = 'N' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }

    public function getRencontresDivision($idDivision)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')        
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')      
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')              
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chdivision_id = :idDivision' )
            ->setParameter('idDivision', $idDivision)
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }    

    public function getRencontresDivisionArray($idDivision)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('c1.corporation_id', 'c2')
            ->addSelect('c2')
            ->join('r.chcorporationVisiteuse_id', 'c3')
            ->addSelect('c3')
            ->join('c3.corporation_id', 'c4')
            ->addSelect('c4')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.salle_id', 's2')
            ->addSelect('s2')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chdivision_id = :idDivision' )
            ->setParameter('idDivision', $idDivision)
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;
        $result = $query->getQuery()->getArrayResult();
       
        return $result;
    }     

    public function getRencontresEquipe($idEquipe)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')        
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')      
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')              
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chequipeVisitee_id = :idEquipe OR r.chequipeVisiteuse_id = :idEquipe' )
            ->setParameter('idEquipe', $idEquipe) 
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }    

    public function getRencontresEquipeArray($idEquipe)
    {
            $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')        
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')      
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('c1.corporation_id', 'c11')
            ->addSelect('c11')
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('c2.corporation_id', 'c21')
            ->addSelect('c21')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.salle_id', 's1')
            ->addSelect('s1')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chequipeVisitee_id = :idEquipe OR r.chequipeVisiteuse_id = :idEquipe' )
            ->setParameter('idEquipe', $idEquipe) 
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;
        $result = $query->getQuery()->getArrayResult();
       
        return $result;
    }

    public function getRencontresCorporation($idChCorporation, $status)
    {
        $query = $this->createQueryBuilder('r')
            //->join('r.chequipe_id', 'e')
            //->addSelect('e')
            ->Where('r.chcorporationVisitee_id = :idChCorporation OR r.chcorporationVisiteuse_id = :idChCorporation' )
            ->setParameter('idChCorporation', $idChCorporation)
            ->andWhere('r.status = :status')
            ->setParameter('status', $status)
            //->orderBy('e.numeroEquipe','ASC')
            ->addOrderBy('r.dateRencontre','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }
    
    public function getRencontreSemaineEncours($idChampionnat)
    {
        $Now = new \DateTime();
        
        $start_week = date("Y-m-d",strtotime('monday this week'));
        $end_week = date("Y-m-d",strtotime('sunday this week'));

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            
            ->andwhere('p.dateRencontre >= :start')
            ->setParameter('start',$start_week) 
            
            ->andWhere('p.dateRencontre <= :end')
            ->setParameter('end',$end_week)
            
            ->andWhere("p.status = 'N' or p.status = 'J' or p.status = 'F' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }
    
    public function getRencontreSemaineSuivante($idChampionnat)
    {
        $Now = new \DateTime();
        
        $start_week = date("Y-m-d",strtotime('monday this week'));
        $end_week = date("Y-m-d",strtotime('sunday this week'));
        
        $start_week_suivante = date('Y-m-d', strtotime($start_week . ' +7 day'));
        $stop_week_suivante = date('Y-m-d', strtotime($end_week . ' +7 day'));

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            
            ->andwhere('p.dateRencontre >= :start')
            ->setParameter('start',$start_week_suivante ) 
            
            ->andWhere('p.dateRencontre <= :end')
            ->setParameter('end',$stop_week_suivante )
            
            ->andWhere("p.status = 'N' or p.status = 'J' or p.status = 'F' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }    
    
    public function getRencontreSemainePrecedente($idChampionnat)
    {
        $Now = new \DateTime();
        
        $start_week = date("Y-m-d",strtotime('monday this week'));
        $end_week = date("Y-m-d",strtotime('sunday this week'));
        
        $start_week_precedente = date('Y-m-d', strtotime($start_week . ' -7 day'));
        $stop_week_precedente = date('Y-m-d', strtotime($end_week . ' -7 day'));

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            
            ->andwhere('p.dateRencontre >= :start')
            ->setParameter('start',$start_week_precedente ) 
            
            ->andWhere('p.dateRencontre <= :end')
            ->setParameter('end',$stop_week_precedente )
            ->andWhere("p.status = 'N' or p.status = 'J' or p.status = 'F' ")
            ->orderBy('p.dateRencontre','ASC');
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }     
    
    public function getDernieresRencEncodee($idChampionnat, $Nb)
    {
        $Now = new \DateTime();

        $query = $this->createQueryBuilder('p')
            ->join('p.chdivision_id', 'd')
            ->addSelect('d')
            ->join('p.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('p.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('p.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('p.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->where('p.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere("p.status = 'J' or p.status = 'F' ")
            ->orderBy('p.dateRencontre','DESC')
            ->setMaxResults($Nb)
        ;

        $result = $query->getQuery()->getResult();
        
        return $result;
    }

    public function getRencontresEquipeAvecStatus($idEquipe, $status)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chequipeVisitee_id = :idEquipe OR r.chequipeVisiteuse_id = :idEquipe' )
            ->setParameter('idEquipe', $idEquipe)
            ->andWhere('r.status = :status' )
            ->setParameter('status', $status)
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }
    
    public function getRencontresSalle($idSalle)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')        
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')      
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')              
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chsalle_id = :idSalle' )
            ->setParameter('idSalle', $idSalle)
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }    

    public function getRencontresSalleArray($idSalle)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('c1.corporation_id', 'c2')
            ->addSelect('c2')
            ->join('r.chcorporationVisiteuse_id', 'c3')
            ->addSelect('c3')
            ->join('c3.corporation_id', 'c4')
            ->addSelect('c4')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.salle_id', 's2')
            ->addSelect('s2')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chsalle_id = :idSalle' )
            ->setParameter('idSalle', $idSalle)
            ->orderBy('r.dateRencontre','ASC')
            ->addOrderBy('l.heureDebut','ASC')
        ;
        $result = $query->getQuery()->getArrayResult();
       
        return $result;
    }

    public function getRencontresDivisionByStatus($idDivision, $status)
    {
        $query = $this->createQueryBuilder('r')
            ->join('r.chdivision_id', 'd')
            ->addSelect('d')
            ->join('r.chequipeVisitee_id', 'e1')
            ->addSelect('e1')
            ->join('r.chequipeVisiteuse_id', 'e2')
            ->addSelect('e2')
            ->join('r.chcorporationVisitee_id', 'c1')
            ->addSelect('c1')
            ->join('r.chcorporationVisiteuse_id', 'c2')
            ->addSelect('c2')
            ->join('r.chsalle_id', 's')
            ->addSelect('s')
            ->join('s.chlocations', 'l')
            ->addSelect('l')
            ->andWhere('r.chdivision_id = :idDivision' )
            ->setParameter('idDivision', $idDivision)
            ->andWhere('r.status = :status' )
            ->setParameter('status', $status)
            ->orderBy('r.dateRencontre','ASC')
        ;

        $result = $query->getQuery()->getResult();

        return $result;
    }

}