<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;


/**
 * ChPlanning
 *
 * @ORM\Table(name="ChPlanning")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChPlanningRepository")
 */
class ChPlanning
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateRencontre", type="date")
     */
    private $dateRencontre;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1)
     * '-' Slot non attribué
     * 'O' Slot attribué et rencontre jouée
     * 'N' Slot attribué et rencontre non jouée
     * 'F' Slot attribué et rencontre non jouée et forfait d'une équipe
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="remarque", type="string", length=255, nullable=true)
     */
    private $remarque;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsEquipeVisitee", type="integer", nullable=true)
     */
    private $ptsEquipeVisitee;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsEquipeVisiteuse", type="integer", nullable=true)
     */
    private $ptsEquipeVisiteuse;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChDivision")
     * @ORM\JoinColumn(name="chdivision_id", referencedColumnName="id")
     */
    protected $chdivision_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChSalle")
     * @ORM\JoinColumn(name="chsalle_id", referencedColumnName="id")
     */
    protected $chsalle_id;    

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe", inversedBy="chPlanningVisitee")
     * @ORM\JoinColumn(name="chequipeVisitee_id", referencedColumnName="id")
     */
    protected $chequipeVisitee_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationVisitee_id", referencedColumnName="id")
     */
    protected $chcorporationVisitee_id;

    /**
     * @var string
     *
     * @ORM\Column(name="statusEqVisitee", type="string", length=1, nullable=true)
     * 'G' Gagné
     * 'P' Perdu
     * 'N' Score Nul
     * '-' Non joué -> pas de statut
     * 'F' Forfait -> Perdu par forfait
     */
    protected $statusEqVisitee;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe", inversedBy="chplanningVisiteuse")
     * @ORM\JoinColumn(name="chequipeVisiteuse_id", referencedColumnName="id")
     */
    protected $chequipeVisiteuse_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationVisiteuse_id", referencedColumnName="id")
     */
    protected $chcorporationVisiteuse_id;

    /**
     * @var string
     *
     * @ORM\Column(name="statusEqVisiteuse", type="string", length=1, nullable=true)
     * 'G' Gagné
     * 'P' Perdu
     * 'N' Score Nul
     * '-' Non joué -> pas de statut
     * 'F' Forfait -> perdu par forfait
     */
    protected $statusEqVisiteuse;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */

     protected $user;

    /**
     * @return string
     */
    public function getStatusEqVisitee()
    {
        return $this->statusEqVisitee;
    }

    /**
     * @param string $statusEqVisitee
     */
    public function setStatusEqVisitee($statusEqVisitee)
    {
        $this->statusEqVisitee = $statusEqVisitee;
    }

    /**
     * @return string
     */
    public function getStatusEqVisiteuse()
    {
        return $this->statusEqVisiteuse;
    }

    /**
     * @param string $statusEqVisiteuse
     */
    public function setStatusEqVisiteuse($statusEqVisiteuse)
    {
        $this->statusEqVisiteuse = $statusEqVisiteuse;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }


    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

    /**
     * @return mixed
     */
    public function getChdivisionId()
    {
        return $this->chdivision_id;
    }

    /**
     * @param mixed $chdivision_id
     */
    public function setChdivisionId($chdivision_id)
    {
        $this->chdivision_id = $chdivision_id;
    }

    /**
     * @return mixed
     */
    public function getChequipeVisiteeId()
    {
        return $this->chequipeVisitee_id;
    }

    /**
     * @param mixed $chequipeVisitee_id
     */
    public function setChequipeVisiteeId($chequipeVisitee_id)
    {
        $this->chequipeVisitee_id = $chequipeVisitee_id;
    }

    /**
     * @return mixed
     */
    public function getChequipeVisiteuseId()
    {
        return $this->chequipeVisiteuse_id;
    }

    /**
     * @param mixed $chequipeVisiteuse_id
     */
    public function setChequipeVisiteuseId($chequipeVisiteuse_id)
    {
        $this->chequipeVisiteuse_id = $chequipeVisiteuse_id;
    }




    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dateRencontre
     *
     * @param \DateTime $dateRencontre
     * @return ChPlanning
     */
    public function setDateRencontre($dateRencontre)
    {
        $this->dateRencontre = $dateRencontre;

        return $this;
    }

    /**
     * Get dateRencontre
     *
     * @return \DateTime 
     */
    public function getDateRencontre()
    {
        return $this->dateRencontre;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return ChPlanning
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string 
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set remarque
     *
     * @param string $remarque
     * @return ChPlanning
     */
    public function setRemarque($remarque)
    {
        $this->remarque = $remarque;

        return $this;
    }

    /**
     * Get remarque
     *
     * @return string 
     */
    public function getRemarque()
    {
        return $this->remarque;
    }

    /**
     * Set ptsEquipeVisitee
     *
     * @param integer $ptsEquipeVisitee
     * @return ChPlanning
     */
    public function setPtsEquipeVisitee($ptsEquipeVisitee)
    {
        $this->ptsEquipeVisitee = $ptsEquipeVisitee;

        return $this;
    }

    /**
     * Get ptsEquipeVisitee
     *
     * @return integer 
     */
    public function getPtsEquipeVisitee()
    {
        return $this->ptsEquipeVisitee;
    }

    /**
     * Set ptsEquipeVisiteuse
     *
     * @param integer $ptsEquipeVisiteuse
     * @return ChPlanning
     */
    public function setPtsEquipeVisiteuse($ptsEquipeVisiteuse)
    {
        $this->ptsEquipeVisiteuse = $ptsEquipeVisiteuse;

        return $this;
    }

    /**
     * Get ptsEquipeVisiteuse
     *
     * @return integer 
     */
    public function getPtsEquipeVisiteuse()
    {
        return $this->ptsEquipeVisiteuse;
    }


    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set chsalle_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chsalleId
     * @return ChPlanning
     */
    public function setChsalleId(\sws\Bundle\BackBundle\Entity\ChSalle $chsalleId = null)
    {
        $this->chsalle_id = $chsalleId;

        return $this;
    }

    /**
     * Get chsalle_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChSalle 
     */
    public function getChsalleId()
    {
        return $this->chsalle_id;
    }

    /**
     * Set chcorporationVisitee_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteeId
     * @return ChPlanning
     */
    public function setChcorporationVisiteeId(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteeId = null)
    {
        $this->chcorporationVisitee_id = $chcorporationVisiteeId;

        return $this;
    }

    /**
     * Get chcorporationVisitee_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationVisiteeId()
    {
        return $this->chcorporationVisitee_id;
    }

    /**
     * Set chcorporationVisiteuse_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteuseId
     * @return ChPlanning
     */
    public function setChcorporationVisiteuseId(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationVisiteuseId = null)
    {
        $this->chcorporationVisiteuse_id = $chcorporationVisiteuseId;

        return $this;
    }

    /**
     * Get chcorporationVisiteuse_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationVisiteuseId()
    {
        return $this->chcorporationVisiteuse_id;
    }
}
