<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * chParametres
 *
 * @ORM\Table(name="ChParametres")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChParametresRepository")
 */
class ChParametres
{
    public function __construct()
    {
        $this->createdAt         = new \Datetime();
        $this->updatedAt         = new \Datetime();
        $this->pointSetGagne     = 2;
        $this->pointSetLeader    = 1;
        $this->pointEgalite      = 1;
        $this->pointPerdu        = 0;
        $this->nbJourMin         = 10;
        $this->nbJourRetard      = 15;
        $this->nbSetMax          = 2;
        $this->contrainteExclude = '1';
        $this->contrainteInclude = '0';
        $this->contrainteJour    = '1';
        $this->contrainteSalle   = '1';
        $this->confirmed         = '-';

    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointSetGagne", type="integer")
     */
    private $pointSetGagne;

    /**
     * @var string
     *
     * @ORM\Column(name="confirmed", type="string", length=1)
     * '-' Planning non généré
     * 'O' Planning généré et confirmé
     * 'N' Planning généré et non confirmé (peu encore être supprimé & gestion des résultats non accessible)
     */
    private $confirmed;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointSetLeader", type="integer")
     */
    private $pointSetLeader;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointEgalite", type="integer")
     */
    private $pointEgalite;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointPerdu", type="integer")
     */
    private $pointPerdu;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbJourMin", type="integer")
     */
    private $nbJourMin;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbJourRetard", type="integer")
     */
    private $nbJourRetard;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbSetMax", type="integer")
     */
    private $nbSetMax;

    /**
     * @var boolean
     *
     * @ORM\Column(name="contrainteExclude", type="boolean")
     */
    private $contrainteExclude;

    /**
     * @var boolean
     *
     * @ORM\Column(name="contrainteInclude", type="boolean")
     */
    private $contrainteInclude;

    /**
     * @var boolean
     *
     * @ORM\Column(name="contrainteJour", type="boolean")
     */
    private $contrainteJour;

    /**
     * @var boolean
     *
     * @ORM\Column(name="contrainteSalle", type="boolean")
     */
    private $contrainteSalle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat", inversedBy="chparametres_id")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnatHerit_id", referencedColumnName="id")
     */
    protected $championnatHerit_id;    

    /**
     * @return string
     */
    public function getConfirmed()
    {
        return $this->confirmed;
    }

    /**
     * @param string $confirmed
     */
    public function setConfirmed($confirmed)
    {
        $this->confirmed = $confirmed;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set pointSetGagne
     *
     * @param integer $pointSetGagne
     * @return chParametres
     */
    public function setPointSetGagne($pointSetGagne)
    {
        $this->pointSetGagne = $pointSetGagne;

        return $this;
    }

    /**
     * Get pointSetGagne
     *
     * @return integer
     */
    public function getPointSetGagne()
    {
        return $this->pointSetGagne;
    }

    /**
     * Set pointSetLeader
     *
     * @param integer $pointSetLeader
     * @return chParametres
     */
    public function setPointSetLeader($pointSetLeader)
    {
        $this->pointSetLeader = $pointSetLeader;

        return $this;
    }

    /**
     * Get pointSetLeader
     *
     * @return integer
     */
    public function getPointSetLeader()
    {
        return $this->pointSetLeader;
    }

    /**
     * Set pointEgalite
     *
     * @param integer $pointEgalite
     * @return chParametres
     */
    public function setPointEgalite($pointEgalite)
    {
        $this->pointEgalite = $pointEgalite;

        return $this;
    }

    /**
     * Get pointEgalite
     *
     * @return integer
     */
    public function getPointEgalite()
    {
        return $this->pointEgalite;
    }

    /**
     * Set pointPerdu
     *
     * @param integer $pointPerdu
     * @return chParametres
     */
    public function setPointPerdu($pointPerdu)
    {
        $this->pointPerdu = $pointPerdu;

        return $this;
    }

    /**
     * Get pointPerdu
     *
     * @return integer
     */
    public function getPointPerdu()
    {
        return $this->pointPerdu;
    }

    /**
     * Set nbJourMin
     *
     * @param integer $nbJourMin
     * @return chParametres
     */
    public function setNbJourMin($nbJourMin)
    {
        $this->nbJourMin = $nbJourMin;

        return $this;
    }

    /**
     * Get nbJourMin
     *
     * @return integer
     */
    public function getNbJourMin()
    {
        return $this->nbJourMin;
    }

    /**
     * Set nbJourRetard
     *
     * @param integer $nbJourRetard
     * @return chParametres
     */
    public function setNbJourRetard($nbJourRetard)
    {
        $this->nbJourRetard = $nbJourRetard;

        return $this;
    }

    /**
     * Get nbJourRetard
     *
     * @return integer
     */
    public function getNbJourRetard()
    {
        return $this->nbJourRetard;
    }

    /**
     * @return int
     */
    public function getNbSetMax()
    {
        return $this->nbSetMax;
    }

    /**
     * @param int $nbSetMax
     */
    public function setNbSetMax($nbSetMax)
    {
        $this->nbSetMax = $nbSetMax;
    }

    /**
     * Set contrainteExclude
     *
     * @param boolean $contrainteExclude
     * @return chParametres
     */
    public function setContrainteExclude($contrainteExclude)
    {
        $this->contrainteExclude = $contrainteExclude;

        return $this;
    }

    /**
     * Get contrainteExclude
     *
     * @return boolean
     */
    public function getContrainteExclude()
    {
        return $this->contrainteExclude;
    }

    /**
     * Set contrainteInclude
     *
     * @param boolean $contrainteInclude
     * @return chParametres
     */
    public function setContrainteInclude($contrainteInclude)
    {
        $this->contrainteInclude = $contrainteInclude;

        return $this;
    }

    /**
     * Get contrainteInclude
     *
     * @return boolean
     */
    public function getContrainteInclude()
    {
        return $this->contrainteInclude;
    }

    /**
     * Set contrainteJour
     *
     * @param boolean $contrainteJour
     * @return chParametres
     */
    public function setContrainteJour($contrainteJour)
    {
        $this->contrainteJour = $contrainteJour;

        return $this;
    }

    /**
     * Get contrainteJour
     *
     * @return boolean
     */
    public function getContrainteJour()
    {
        return $this->contrainteJour;
    }

    /**
     * Set contrainteSalle
     *
     * @param boolean $contrainteSalle
     * @return chParametres
     */
    public function setContrainteSalle($contrainteSalle)
    {
        $this->contrainteSalle = $contrainteSalle;

        return $this;
    }

    /**
     * Get contrainteSalle
     *
     * @return boolean
     */
    public function getContrainteSalle()
    {
        return $this->contrainteSalle;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return chParametres
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     * @return chParametres
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return mixed
     */
    public function getChParametre()
    {
        return $this->chParametre;
    }

    /**
     * @param mixed $chParametre
     */
    public function setChParametre($chParametre)
    {
        $this->chParametre = $chParametre;
    }

    /**
     * Set championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatId
     * @return ChParametres
     */
    public function setChampionnatId(\sws\Bundle\BackBundle\Entity\Championnat $championnatId = null)
    {
        $this->championnat_id = $championnatId;

        return $this;
    }

    /**
     * Get championnat_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * Set championnatHerit_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatHerit_id
     * @return ChParametres
     */
    public function setChampionnatHeritId(\sws\Bundle\BackBundle\Entity\Championnat $championnatHerit_id = null)
    {
        $this->championnatHerit_id = $championnatHerit_id;

        return $this;
    }

    /**
     * Get championnatHerit_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatHeritId()
    {
        return $this->championnatHerit_id;
    }

}
