<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * ChLocationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChLocationRepository extends EntityRepository
{
    public function getAll()
    {
        $qb = $this->createQueryBuilder('c');

        $query = $qb;
        /*
            ->where('j.nom = :nom')
            ->setParameter('nom', 'Bettonville');
        */
        $result = $qb->getQuery()->execute();
        return $result;
    }

    public function getChLocations($idSalleCh, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chsalle_id = :idSalleCh' )
            ->setParameter('idSalleCh', $idSalleCh)
            ->orderBy('c.jour', 'ASC')
            ->addOrderBy('c.numeroRencontre', 'DESC')
            ->addOrderBy('c.heureDebut', 'ASC')
            ->addOrderBy('c.nom', 'ASC')
            ->getQuery()
        ;

        $query
            ->setFirstResult(($page-1) * $nbPerPage)
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }

    public function getChLocationsByCritere($idSalleCh, $critere, $page, $nbPerPage)
    {
        $query = $this->createQueryBuilder('c');

        $query
            ->where('c.chsalle_id = :idSalleCh' )
            ->setParameter('idSalleCh', $idSalleCh)
            ->andwhere('c.nom like :critere')
            ->setParameter('critere', '%'.$critere.'%')
            ->orderBy('c.jour', 'ASC')
            ->addOrderBy('c.numeroRencontre', 'DESC')
            ->addOrderBy('c.heureDebut', 'ASC')
            ->addOrderBy('c.nom', 'ASC')
            ->setFirstResult(($page-1) * $nbPerPage)
            ->setMaxResults($nbPerPage)
        ;

        return new Paginator($query, true);
    }

    public function getChLocationsChSalle($idSalleCh)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chsalle_id = :idSalleCh' )
            ->setParameter('idSalleCh', $idSalleCh)
        ;

        $result = $query->getQuery()->getResult();
        return $result;
    }

    public function getLocationsSalle($idSalleCh)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chsalle_id', 's')
            ->addSelect('s')        
            ->where('c.chsalle_id = :idSalleCh' )
            ->setParameter('idSalleCh', $idSalleCh)
            ->orderBy('c.numeroRencontre','ASC')
            ->addOrderBy('c.jour','ASC')
            ->addOrderBy('c.heureDebut','ASC')
            ->addOrderBy('c.nom','ASC')
        ;

        $result = $query->getQuery()->getResult();
       
        return $result;
    }    

    public function getLocationsSalleArray($idSalleCh)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chsalle_id', 's')
            ->addSelect('s')        
            ->where('c.chsalle_id = :idSalleCh' )
            ->setParameter('idSalleCh', $idSalleCh)
            ->orderBy('c.numeroRencontre','ASC')
            ->addOrderBy('c.jour','ASC')
            ->addOrderBy('c.heureDebut','ASC')
            ->addOrderBy('c.nom','ASC')
        ;

        $result = $query->getQuery()->getArrayResult();
       
        return $result;
    } 

}

