<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChLocation
 *
 * @ORM\Table(name="ChLocation")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChLocationRepository")
 */
class ChLocation
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @var integer
     *
     * @ORM\Column(name="jour", type="integer")
     */
    private $jour;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="heureDebut", type="time")
     */
    private $heureDebut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="heureFin", type="time")
     */
    private $heureFin;

    /**
     * @var integer
     *
     * @ORM\Column(name="tarifHeure", type="integer")
     */
    private $tarifHeure;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroRencontre", type="integer")
     */
    private $numeroRencontre;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="chlocations")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="ChSalle", inversedBy="chlocations")
     * @ORM\JoinColumn(name="chsalle_id", referencedColumnName="id")
     */
    protected $chsalle_id;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat", inversedBy="chlocations")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="TypeSurface")
     * @ORM\JoinColumn(name="typeSurface_id", referencedColumnName="id")
     */
    protected $typeSurface_id;    

    /**
     * @return mixed
     */
    public function getChsalleId()
    {
        return $this->chsalle_id;
    }

    /**
     * @param mixed $chsalle_id
     */
    public function setChsalleId($chsalle_id)
    {
        $this->chsalle_id = $chsalle_id;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }


    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

  
    /**
     * Set nom
     *
     * @param string $nom
     * @return ChLocation
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set jour
     *
     * @param string $jour
     * @return ChLocation
     */
    public function setJour($jour)
    {
        $this->jour = $jour;

        return $this;
    }

    /**
     * Get jour
     *
     * @return string 
     */
    public function getJour()
    {
        return $this->jour;
    }

    /**
     * Set heureDebut
     *
     * @param \DateTime $heureDebut
     * @return ChLocation
     */
    public function setHeureDebut($heureDebut)
    {
        $this->heureDebut = $heureDebut;

        return $this;
    }

    /**
     * Get heureDebut
     *
     * @return \DateTime 
     */
    public function getHeureDebut()
    {
        return $this->heureDebut;
    }

    /**
     * Set heureFin
     *
     * @param \DateTime $heureFin
     * @return ChLocation
     */
    public function setHeureFin($heureFin)
    {
        $this->heureFin = $heureFin;

        return $this;
    }

    /**
     * Get heureFin
     *
     * @return \DateTime 
     */
    public function getHeureFin()
    {
        return $this->heureFin;
    }

    /**
     * Set tarifHeure
     *
     * @param integer $tarifHeure
     * @return ChLocation
     */
    public function setTarifHeure($tarifHeure)
    {
        $this->tarifHeure = $tarifHeure;

        return $this;
    }

    /**
     * Get tarifHeure
     *
     * @return integer 
     */
    public function getTarifHeure()
    {
        return $this->tarifHeure;
    }

    /**
     * Set numeroRencontre
     *
     * @param integer $numeroRencontre
     * @return ChLocation
     */
    public function setNumeroRencontre($numeroRencontre)
    {
        $this->numeroRencontre = $numeroRencontre;

        return $this;
    }

    /**
     * Get numeroRencontre
     *
     * @return integer 
     */
    public function getNumeroRencontre()
    {
        return $this->numeroRencontre;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set typeSurface_id
     *
     * @param \sws\Bundle\BackBundle\Entity\TypeSurface $typeSurfaceId
     * @return ChLocation
     */
    public function setTypeSurfaceId(\sws\Bundle\BackBundle\Entity\TypeSurface $typeSurfaceId = null)
    {
        $this->typeSurface_id = $typeSurfaceId;

        return $this;
    }

    /**
     * Get typeSurface_id
     *
     * @return \sws\Bundle\BackBundle\Entity\TypeSurface 
     */
    public function getTypeSurfaceId()
    {
        return $this->typeSurface_id;
    }
}
