<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Tools\Pagination\Paginator;

/**
 * ChCorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChJoueurRepository extends EntityRepository
{

    public function getChJoueur($id, $Genre)
    {
        if ($Genre == 'X'){
            $genreSearch = "'M','F'";
        }
        else{
            $genreSearch = "'".$Genre."'";
        }

        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
            ->andWhere('c.desactive = 0')
            ->andWhere('c2.sexe IN ('.$genreSearch.')')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getChJoueurCorpo($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
            ->orderBy('c2.nom', 'ASC')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getListeForceCorpo($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->join('c.chclassementRil_id', 'c3')
            ->addSelect('c3')
            ->join('c.chclassementRilMixte_id', 'c4')
            ->addSelect('c4')
            ->join('c.chcorporation_id', 'c5')
            ->addSelect('c5')            
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
            ->orderBy('c4.numeroOrdre', 'ASC')
        ;

        $result = $query->getQuery()->getResult();
        return $result;
    }

    public function getListeForceCorpoDames($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->join('c.chclassementRil_id', 'c3')
            ->addSelect('c3')
            ->join('c.chclassementRilMixte_id', 'c4')
            ->addSelect('c4')
            ->join('c.chcorporation_id', 'c5')
            ->addSelect('c5')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
            ->orderBy('c3.numeroOrdre', 'ASC') /* sws-todo :corriger l'ordre  (list de force féminine*/
        ;

        $result = $query->getQuery()->getResult();
        return $result;
    }
    
    public function getListeForceCorpoArray($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->join('c2.user', 'c1')
            ->addSelect('c1')
            ->join('c.chclassementRil_id', 'c3')
            ->addSelect('c3')
            ->where('c.chcorporation_id = :id')
            ->join('c.chclassementRilMixte_id', 'c4')
            ->addSelect('c4')
            ->setParameter('id', $id)
            ->orderBy('c4.numeroOrdre', 'ASC')
        ;

        $result = $query->getQuery()->getArrayResult();
        return $result;
    }

    public function getListeForceCorpoDamesArray($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->join('c2.user', 'c1')
            ->addSelect('c1')
            ->join('c.chclassementRil_id', 'c3')
            ->addSelect('c3')
            ->where('c.chcorporation_id = :id')
            ->join('c.chclassementRilMixte_id', 'c4')
            ->addSelect('c4')
            ->setParameter('id', $id)
            ->orderBy('c3.numeroOrdre', 'ASC')
        ;

        $result = $query->getQuery()->getArrayResult();
        return $result;
    }

    public function getCh1Joueur($idJoueurCh)
    {

        $query = $this->createQueryBuilder('j')
            ->join('j.joueur_id', 'j')
            ->addSelect('j2')
            ->where('j.id = :idJoueurCh')
            ->setParameter('idJoueurCh', $idSalleCh)
        ;

        $result = $query->getQuery()->getSingleResult();
        return $result;
    }

    public function getChJoueurArray($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->leftJoin('c.chclassementRil_id', 'c3')
            ->addSelect('c3')
            ->leftJoin('c.chclassementRilMixte_id', 'c4')
            ->addSelect('c4')
            ->where('c.id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->getArrayResult();
        return $result;
    }

    public function getChJoueurs($id)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

    public function removeCapitainatEquipe($idEquipe, $idChCorporation, $idChJoueur)
    {

        $query = $this->_em->createQuery("UPDATE sws\Bundle\BackBundle\Entity\ChJoueur c SET c.chequipecapitaine_id = null WHERE c.chequipecapitaine_id = " .$idEquipe." and c.chcorporation_id = ".$idChCorporation." and c.id <>".$idChJoueur);
        $result = $query->execute();

        return $result;

    }

    public function removeDelegation($idChCorporation, $idChJoueur)
    {

        $query = $this->_em->createQuery("UPDATE sws\Bundle\BackBundle\Entity\ChJoueur c SET c.delegue = 0 WHERE c.chcorporation_id = ".$idChCorporation." and c.id <>".$idChJoueur);
        $result = $query->execute();

        return $result;

    }

    public function getContacts($ChCorporations)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chcorporation_id', 'c2')
            ->addSelect('c2')
            ->join('c2.corporation_id', 'c3')
            ->addSelect('c3')
            ->where('c.chcorporation_id IN (:Corporations)')
            ->setParameter('Corporations', $ChCorporations)
            ->andWhere('c.delegue = 1 or c.chequipecapitaine_id is not null')
            ->orderBy('c3.nom', 'ASC')
            ->addOrderBy('c.delegue','DESC') // Délégué en premier
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getDelegues($ChCorporation)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chcorporation_id = (:Corporations)')
            ->setParameter('Corporations', $ChCorporation)
            ->andWhere('c.delegue = 1')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getChJoueursChampionnat($id)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.joueur_id', 'c2')
            ->addSelect('c2')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $id)
            ->orderBy('c2.nom', 'ASC')
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

    public function getContactsEquipe($ChCorporation, $ChEquipe)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chcorporation_id', 'c2')
            ->addSelect('c2')
            ->join('c2.corporation_id', 'c3')
            ->addSelect('c3')
            ->where('c.chcorporation_id = (:Corporations)')
            ->setParameter('Corporations', $ChCorporation)
            ->andWhere('c.delegue = 1 or c.chequipecapitaine_id = :ChEquipe')
            ->setParameter('ChEquipe', $ChEquipe)
            ->orderBy('c3.nom', 'ASC')
            ->addOrderBy('c.delegue','DESC') // Délégué en premier
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }
    
}
