<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChJoueurPtsSimple
 *
 * @ORM\Table(name="ChJoueurPtsSimple")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChJoueurPtsSimpleRepository")
 */
class ChJoueurPtsSimple
{
    public function __construct()
    {
        $this->createdAt         = new \Datetime();
        $this->updatedAt         = new \Datetime();
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
 
    /**
     * @var integer
     *
     * @ORM\Column(name="pointsJoueur", type="integer")
     */
    private $pointsJoueur;

    /**
     * @ORM\ManyToOne(targetEntity="ChPlanning")
     * @ORM\JoinColumn(name="chplanning_id", referencedColumnName="id")
     */
    protected $chplanning_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChJoueur", inversedBy="ChJoueurPtsSimple")
     * @ORM\JoinColumn(name="chjoueur_id", referencedColumnName="id")
     */
    protected $chjoueurId;

    /**
     * @ORM\ManyToOne(targetEntity="Joueurs")
     * @ORM\JoinColumn(name="joueur_id", referencedColumnName="id")
     */
    protected $joueurId;    

    /**
     * @ORM\ManyToOne(targetEntity="ChDivision")
     * @ORM\JoinColumn(name="chdivision_id", referencedColumnName="id")
     */
    protected $chdivision_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipe_id", referencedColumnName="id")
     */
    protected $chequipe_id; 

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporation_id", referencedColumnName="id")
     */
    protected $chcorporation_id;    

    /**
     * @ORM\ManyToOne(targetEntity="Corporation")
     * @ORM\JoinColumn(name="corporation_id", referencedColumnName="id")
     */
    protected $corporation_id;    

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;      

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;    

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPointsJoueur()
    {
        return $this->pointsJoueur;
    }

    /**
     * @param int $pointsJoueur
     */
    public function setPointsJoueur($pointsJoueur)
    {
        $this->pointsJoueur = $pointsJoueur;
    }

    /**
     * @return mixed
     */
    public function getChplanningId()
    {
        return $this->chplanning_id;
    }

    /**
     * @param mixed $chplanning_id
     */
    public function setChplanningId($chplanning_id)
    {
        $this->chplanning_id = $chplanning_id;
    }

    /**
     * @return mixed
     */
    public function getChjoueurId()
    {
        return $this->chjoueurId;
    }

    /**
     * @param mixed $chjoueurId
     */
    public function setChjoueurId($chjoueurId)
    {
        $this->chjoueurId = $chjoueurId;
    }

    /**
     * @return mixed
     */
    public function getJoueurId()
    {
        return $this->joueurId;
    }

    /**
     * @param mixed $joueurId
     */
    public function setJoueurId($joueurId)
    {
        $this->joueurId = $joueurId;
    }

    /**
     * @return mixed
     */
    public function getChdivisionId()
    {
        return $this->chdivision_id;
    }

    /**
     * @param mixed $chdivision_id
     */
    public function setChdivisionId($chdivision_id)
    {
        $this->chdivision_id = $chdivision_id;
    }

    /**
     * @return mixed
     */
    public function getChequipeId()
    {
        return $this->chequipe_id;
    }

    /**
     * @param mixed $chequipe_id
     */
    public function setChequipeId($chequipe_id)
    {
        $this->chequipe_id = $chequipe_id;
    }

    /**
     * @return mixed
     */
    public function getChcorporationId()
    {
        return $this->chcorporation_id;
    }

    /**
     * @param mixed $chcorporation_id
     */
    public function setChcorporationId($chcorporation_id)
    {
        $this->chcorporation_id = $chcorporation_id;
    }

    /**
     * @return mixed
     */
    public function getCorporationId()
    {
        return $this->corporation_id;
    }

    /**
     * @param mixed $corporation_id
     */
    public function setCorporationId($corporation_id)
    {
        $this->corporation_id = $corporation_id;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;
    }
}
