<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChJoueur
 *
 * @ORM\Table(name="ChJoueur")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChJoueurRepository")
 */
class ChJoueur
{

    public function __construct()
    {
        $this->desactive = 0;
    }
    
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="totalPtGagne", type="integer", nullable=true)
     */
    private $totalPtGagne;

    /**
     * @var integer
     *
     * @ORM\Column(name="totalPtPerdu", type="integer", nullable=true)
     */
    private $totalPtPerdu;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation", inversedBy="chequipesJoueurs")
     * @ORM\JoinColumn(name="chcorporation_id", referencedColumnName="id")
     */
    protected $chcorporation_id;

    /**
     * @var boolean
     *
     * @ORM\Column(name="delegue", type="boolean", nullable=true)
     */

    protected $delegue;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipecapitaine_id", referencedColumnName="id")
     */
    protected $chequipecapitaine_id;

    /**
     * @var boolean
     *
     * @ORM\Column(name="desactive", type="boolean", nullable=true)
     */
    protected $desactive;    

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="Joueurs")
     * @ORM\JoinColumn(name="joueur_id", referencedColumnName="id")
     */
    protected $joueur_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRil_id", referencedColumnName="id")
     */
    protected $chclassementRil_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRedu_id", referencedColumnName="id")
     */
    protected $chclassementRedu_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRilPrecendent_id", referencedColumnName="id")
     */
    protected $chclassementRilPrecedent_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRilCalcul_id", referencedColumnName="id")
     */
    protected $chclassementRilCalcul_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRilMixte_id", referencedColumnName="id")
     */
    protected $chclassementRilMixte_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChClassement")
     * @ORM\JoinColumn(name="chclassementRilMixteCalcul_id", referencedColumnName="id")
     */
    protected $chclassementRilMixteCalcul_id;

    /**
     * @var string
     *
     * @ORM\Column(name="remarque", type="string", length=255, nullable=true)
     */
    private $remarque;  

    /**
     * @ORM\OneToMany(targetEntity="ChJoueurPtsSimple", mappedBy="chjoueurId")
     *
     */
    private $ChJoueurPtsSimple;    

    /**
     * @ORM\OneToMany(targetEntity="ChJoueurPtsDouble", mappedBy="chjoueurId")
     *
     */
    private $ChJoueurPtsDouble;      

    /**
     * @Gedmo\Slug(handlers={
     *      @Gedmo\SlugHandler(class="Gedmo\Sluggable\Handler\RelativeSlugHandler", options={
     *          @Gedmo\SlugHandlerOption(name="relationField", value="joueur_id"),
     *          @Gedmo\SlugHandlerOption(name="relationSlugField", value="slug"),
     *          @Gedmo\SlugHandlerOption(name="separator", value="-"),
     *          @Gedmo\SlugHandlerOption(name="urilize", value=true)
     *      })
     * },fields={"createdAt"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug; 

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    } 

    /**
     * Add ChJoueurPtsSimple
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple $ChJoueurPtsSimple
     * @return User
     */
    public function addChJoueurPtsSimple(\sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple $ChJoueurPtsSimple)
    {
        $this->ChJoueurPtsSimple[] = $ChJoueurPtsSimple;

        return $this;
    }

    /**
     * Remove ChJoueurPtsSimple
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple $ChJoueurPtsSimple
     */
    public function removeChJoueurPtsSimple(\sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple $ChJoueurPtsSimple)
    {
        $this->ChJoueurPtsSimple->removeElement($ChJoueurPtsSimple);
    }

    /**
     * Get ChJoueurPtsSimple
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChJoueurPtsSimple()
    {
        return $this->ChJoueurPtsSimple;
    }


    /**
     * Add ChJoueurPtsDouble
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble $ChJoueurPtsDouble
     * @return User
     */
    public function addChJoueurPtsDouble(\sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble $ChJoueurPtsDouble)
    {
        $this->ChJoueurPtsDouble[] = $ChJoueurPtsDouble;

        return $this;
    }

    /**
     * Remove ChJoueurPtsDouble
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble $ChJoueurPtsDouble
     */
    public function removeChJoueurPtsDouble(\sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble $ChJoueurPtsDouble)
    {
        $this->ChJoueurPtsDouble->removeElement($ChJoueurPtsDouble);
    }

    /**
     * Get ChJoueurPtsDouble
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChJoueurPtsDouble()
    {
        return $this->ChJoueurPtsDouble;
    }


    /**
     * Set remarque
     *
     * @param string $remarque
     * @return ChPlanning
     */
    public function setRemarque($remarque)
    {
        $this->remarque = $remarque;

        return $this;
    }

    /**
     * Get remarque
     *
     * @return string 
     */
    public function getRemarque()
    {
        return $this->remarque;
    }


    /**
     * @return mixed
     */
    public function getDesactive()
    {
        return $this->desactive;
    }

    /**
     * @param mixed $desactive
     */
    public function setDesactive($desactive)
    {
        $this->desactive = $desactive;
    }

    /**
     * @return mixed
     */
    public function getDelegue()
    {
        return $this->delegue;
    }

    /**
     * @param mixed $delegue
     */
    public function setDelegue($delegue)
    {
        $this->delegue = $delegue;
    }

    /**
     * @return mixed
     */
    public function getChequipecapitaineId()
    {
        return $this->chequipecapitaine_id;
    }

    /**
     * @param mixed $chequipecapitaine_id
     */
    public function setChequipecapitaineId($chequipecapitaine_id)
    {
        $this->chequipecapitaine_id = $chequipecapitaine_id;
    }


    /**
     * @return mixed
     */
    public function getChclassementRilMixteCalculId()
    {
        return $this->chclassementRilMixteCalcul_id;
    }

    /**
     * @param mixed $chclassementRilMixteCalcul_id
     */
    public function setChclassementRilMixteCalculId($chclassementRilMixteCalcul_id)
    {
        $this->chclassementRilMixteCalcul_id = $chclassementRilMixteCalcul_id;
    }

    /**
     * @return mixed
     */
    public function getChclassementRilMixteId()
    {
        return $this->chclassementRilMixte_id;
    }

    /**
     * @param mixed $chclassementRilMixte_id
     */
    public function setChclassementRilMixteId($chclassementRilMixte_id)
    {
        $this->chclassementRilMixte_id = $chclassementRilMixte_id;
    }

    /**
     * @return mixed
     */
    public function getChclassementRilCalculId()
    {
        return $this->chclassementRilCalcul_id;
    }

    /**
     * @param mixed $chclassementRilCalcul_id
     */
    public function setChclassementRilCalculId($chclassementRilCalcul_id)
    {
        $this->chclassementRilCalcul_id = $chclassementRilCalcul_id;
    }


    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @return int
     */
    public function getTotalPtGagne()
    {
        return $this->totalPtGagne;
    }

    /**
     * @param int $totalPtGagne
     */
    public function setTotalPtGagne($totalPtGagne)
    {
        $this->totalPtGagne = $totalPtGagne;
    }

    /**
     * @return int
     */
    public function getTotalPtPerdu()
    {
        return $this->totalPtPerdu;
    }

    /**
     * @param int $totalPtPerdu
     */
    public function setTotalPtPerdu($totalPtPerdu)
    {
        $this->totalPtPerdu = $totalPtPerdu;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getChcorporationId()
    {
        return $this->chcorporation_id;
    }

    /**
     * @param mixed $chcorporation_id
     */
    public function setChcorporationId($chcorporation_id)
    {
        $this->chcorporation_id = $chcorporation_id;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

    /**
     * @return mixed
     */
    public function getJoueurId()
    {
        return $this->joueur_id;
    }

    /**
     * @param mixed $joueur_id
     */
    public function setJoueurId($joueur_id)
    {
        $this->joueur_id = $joueur_id;
    }

    /**
     * @return mixed
     */
    public function getChclassementRilId()
    {
        return $this->chclassementRil_id;
    }

    /**
     * @param mixed $chclassementRil_id
     */
    public function setChclassementRilId($chclassementRil_id)
    {
        $this->chclassementRil_id = $chclassementRil_id;
    }

    /**
     * @return mixed
     */
    public function getChclassementReduId()
    {
        return $this->chclassementRedu_id;
    }

    /**
     * @param mixed $chclassementRedu_id
     */
    public function setChclassementReduId($chclassementRedu_id)
    {
        $this->chclassementRedu_id = $chclassementRedu_id;
    }

    /**
     * @return mixed
     */
    public function getChclassementRilPrecedentId()
    {
        return $this->chclassementRilPrecedent_id;
    }

    /**
     * @param mixed $chclassementRilPrecedent_id
     */
    public function setChclassementRilPrecedentId($chclassementRilPrecedent_id)
    {
        $this->chclassementRilPrecedent_id = $chclassementRilPrecedent_id;
    }



}
