<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * ChCorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChIndisponibiliteRepository extends EntityRepository
{

    public function getChIndisponibilite($id)
    {
        $query = $this->createQueryBuilder('e')
            ->where('e.championnat_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    /**
     * Cette fonction retourne les équipes du championnat qui ont une fourchette de points comprise dans la range de
     * point de la division
     *
     * @param $PtsMinimum : Points minimum de la division
     * @param $PtsMaximum : Points maximum de la division
     *
     */
    public function getNbIndisponibilites($id)
    {
        $query = $this->createQueryBuilder('c');
        $query 
            ->select('count(c.id)')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->getSingleScalarResult();
        return (int) $result;
    }

    public function getChindisponibiliteVacScolaire($fonction, $id)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $id)
            ->andWhere('c.type = \'vac_scolaire\'')
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

}
