<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChIndisponibilite
 *
 * @ORM\Table(name="ChIndisponibilite")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChIndisponibiliteRepository")
 */
class ChIndisponibilite
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="fonction", type="string", length=1)
     */
    private $fonction;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=255)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255)
     */
    private $libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="typeCode", type="string", length=1)
     */
    private $typeCode;


    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;


    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="periodeDebut", type="datetime", nullable=true)
     */
    private $periodeDebut;

    /**
     * @return \DateTime
     */
    public function getPeriodeDebut()
    {
        return $this->periodeDebut;
    }

    /**
     * @param \DateTime $periodeDebut
     */
    public function setPeriodeDebut($periodeDebut)
    {
        $this->periodeDebut = $periodeDebut;
    }

    /**
     * @return \DateTime
     */
    public function getPeriodeFin()
    {
        return $this->periodeFin;
    }

    /**
     * @param \DateTime $periodeFin
     */
    public function setPeriodeFin($periodeFin)
    {
        $this->periodeFin = $periodeFin;
    }

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="periodeFin", type="datetime", nullable=true)
     */
    private $periodeFin;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fonction
     *
     * @param string $fonction
     * @return ChContrainte
     */
    public function setFonction($fonction)
    {
        $this->fonction = $fonction;

        return $this;
    }

    /**
     * Get fonction
     *
     * @return string 
     */
    public function getFonction()
    {
        return $this->fonction;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return ChContrainte
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set user
     *
     * @param \sws\Bundle\BackBundle\Entity\User $user
     * @return ChContrainte
     */
    public function setUser(\sws\Bundle\BackBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \sws\Bundle\BackBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatId
     * @return ChContrainte
     */
    public function setChampionnatId(\sws\Bundle\BackBundle\Entity\Championnat $championnatId = null)
    {
        $this->championnat_id = $championnatId;

        return $this;
    }

    /**
     * Get championnat_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @return string
     */
    public function getTypeCode()
    {
        return $this->typeCode;
    }

    /**
     * @param string $typeCode
     */
    public function setTypeCode($typeCode)
    {
        $this->typeCode = $typeCode;
    }

    /**
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * @param string $libelle
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;
    }

}
