<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * ChCorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChEquipeRepository extends EntityRepository
{

    public function getChEquipe($id)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

    public function getCh1Equipe($idEquipeCh)
    {
        $query = $this->createQueryBuilder('j')
            ->where('j.id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idSalleCh)
        ;

        $result = $query->getQuery()->getSingleResult();
        return $result;
    }

    public function getChEquipeAsso($id)
    {
        $query = $this->createQueryBuilder('e')
            ->join('e.chcorporation_id', 'c')
            ->addSelect('c')
            ->join('c.corporation_id', 'c2')
            ->addSelect('c2')
            ->where('e.chdivision_id = :id')
            ->setParameter('id', $id)
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    /**
     * Cette fonction retourne les équipes du championnat qui ont une fourchette de points comprise dans la range de
     * point de la division
     *
     * @param $PtsMinimum : Points minimum de la division
     * @param $PtsMaximum : Points maximum de la division
     *
     */
    public function getChEquipesNonAsso( $idChampionnat, $PtsMinimum, $PtsMaximum, $Genre)
    {
        if ($Genre == 'X'){
            $genreSearch = "'M','F','X'";
        }
        else{
            $genreSearch = "'".$Genre."'";
        }

        $query = $this->createQueryBuilder('e')
            ->join('e.chcorporation_id', 'c')
            ->addSelect('c')
            ->join('c.corporation_id', 'c2')
            ->addSelect('c2')
            ->where('e.chdivision_id is null')
            ->andWhere('e.genre IN ('.$genreSearch.')')
            ->andWhere('e.ptsMinimum >= :PtsMinimum')
            ->setParameter('PtsMinimum', $PtsMinimum)
            ->andWhere('e. ptsMaximum <= :PtsMaximum')
            ->setParameter('PtsMaximum', $PtsMaximum)
            ->andWhere('e. championnat_id= :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
        ;

        $result = $query->getQuery()->execute();

        return $result;


    }

    /**
     * Cette fonction retourne les équipes du championnat qui ont une fourchette de points comprise dans la range de
     * point de la division
     *
     * @param $PtsMinimum : Points minimum de la division
     * @param $PtsMaximum : Points maximum de la division
     *
     */
    public function getChEquipesForOneDivision($idDivisionCh)
    {
        $query = $this->createQueryBuilder('e')
            ->where('e.chdivision_id = :idDivisionCh')
            ->setParameter('idDivisionCh', $idDivisionCh)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }    

    public function getClassement($idDivisionCh)
    {

        $query = $this->createQueryBuilder('e')
            ->join('e.chPlanningVisitee', 'p1')
            ->addSelect('p1')
            ->join('e.chplanningVisiteuse', 'p2')
            ->addSelect('p2')
            ->where('e.chdivision_id = :idDivisionCh')
            ->setParameter('idDivisionCh', $idDivisionCh)
            ->orderBy('e.calculPtsEquipe','DESC')
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

    public function getChEquipes($id)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.chcorporation_id = :id')
            ->setParameter('id', $id)
            ->orderBy('c.suffixEquipe',' ASC')
            ->AddOrderBy('c.numeroEquipe',' ASC')

        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

    public function getChEquipesChampionnat($idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->join('c.chcorporation_id', 'c1')
            ->addSelect('c1')
            ->join('c1.corporation_id', 'c2')
            ->addSelect('c2')
            ->where('c.championnat_id = :id')
            ->setParameter('id', $idChampionnat)
            ->orderBy('c2.nom',' ASC')
            ->AddOrderBy('c.numeroEquipe',' ASC')
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }
}
