<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChEquipe
 *
 * @ORM\Table(name="ChEquipe")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChEquipeRepository")
 */
class ChEquipe
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="genre", type="string", length=1)
     */
    private $genre;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsMinimum", type="integer")
     */
    private $ptsMinimum;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsMaximum", type="integer")
     */
    private $ptsMaximum;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroEquipe", type="integer")
     */
    private $numeroEquipe;

    /**
     * @var string
     *
     * @ORM\Column(name="suffixEquipe", type="string", length=255, nullable=true)
     */
    private $suffixEquipe;

    /**
     * @var integer
     *
     * @ORM\Column(name="calculPtsEquipe", type="integer", nullable=true)
     */
    private $calculPtsEquipe;    

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation", inversedBy="chequipes")
     * @ORM\JoinColumn(name="chcorporation_id", referencedColumnName="id")
     */
    protected $chcorporation_id;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

        /**
     * @ORM\ManyToOne(targetEntity="ChDivision", inversedBy="chdivisions")
     * @ORM\JoinColumn(name="chdivision_id", referencedColumnName="id", nullable=true)
     */
    protected $chdivision_id;

    /**
     * @ORM\OneToMany(targetEntity="ChContrainte", mappedBy="chequipe_id")
     *
     */
    private $chequipes_id;

    /**
     * @ORM\OneToMany(targetEntity="ChPlanning", mappedBy="chequipeVisitee_id")
     *
     */
    private $chPlanningVisitee;

    /**
     * @ORM\OneToMany(targetEntity="ChPlanning", mappedBy="chequipeVisiteuse_id")
     *
     */
    private $chplanningVisiteuse;

    /**
     * @Gedmo\Slug(fields={"nom","numeroEquipe","suffixEquipe","createdAt"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;    

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }        

    /**
     * @return string
     */
    public function getNomComplet()
    {
        return $this->nom.' '.$this->numeroEquipe.' '.$this->suffixEquipe;
    }

    /**
     * @return string
     */
    public function getGenre()
    {
        return $this->genre;
    }

    /**
     * @param string $genre
     */
    public function setGenre($genre)
    {
        $this->genre = $genre;
    }

    /**
     * @return mixed
     */
    public function getChPlanningVisitee()
    {
        return $this->chPlanningVisitee;
    }

    /**
     * @param mixed $chPlanningVisitee
     */
    public function setChPlanningVisitee($chPlanningVisitee)
    {
        $this->chPlanningVisitee = $chPlanningVisitee;
    }

    /**
     * @return mixed
     */
    public function getChplanningVisiteuse()
    {
        return $this->chplanningVisiteuse;
    }

    /**
     * @param mixed $chplanningVisiteuse
     */
    public function setChplanningVisiteuse($chplanningVisiteuse)
    {
        $this->chplanningVisiteuse = $chplanningVisiteuse;
    }




    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getChcorporationId()
    {
        return $this->chcorporation_id;
    }

    /**
     * @param mixed $chcorporation_id
     */
    public function setChcorporationId($chcorporation_id)
    {
        $this->chcorporation_id = $chcorporation_id;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return ChEquipe
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }


    /**
     * Set calculPtsEquipe
     *
     * @param integer $calculPtsEquipe
     * @return ChEquipe
     */
    public function setCalculPtsEquipe($calculPtsEquipe)
    {
        $this->calculPtsEquipe = $calculPtsEquipe;

        return $this;
    }

    /**
     * Get calculPtsEquipe
     *
     * @return integer 
     */
    public function getCalculPtsEquipe()
    {
        return $this->calculPtsEquipe;
    }


    /**
     * Set ptsMinimum
     *
     * @param integer $ptsMinimum
     * @return ChEquipe
     */
    public function setPtsMinimum($ptsMinimum)
    {
        $this->ptsMinimum = $ptsMinimum;

        return $this;
    }

    /**
     * Get ptsMinimum
     *
     * @return integer 
     */
    public function getPtsMinimum()
    {
        return $this->ptsMinimum;
    }

    /**
     * Set ptsMaximum
     *
     * @param integer $ptsMaximum
     * @return ChEquipe
     */
    public function setPtsMaximum($ptsMaximum)
    {
        $this->ptsMaximum = $ptsMaximum;

        return $this;
    }

    /**
     * Get ptsMaximum
     *
     * @return integer 
     */
    public function getPtsMaximum()
    {
        return $this->ptsMaximum;
    }

    /**
     * Set numeroEquipe
     *
     * @param integer $numeroEquipe
     * @return ChEquipe
     */
    public function setNumeroEquipe($numeroEquipe)
    {
        $this->numeroEquipe = $numeroEquipe;

        return $this;
    }

    /**
     * Get numeroEquipe
     *
     * @return integer 
     */
    public function getNumeroEquipe()
    {
        return $this->numeroEquipe;
    }

    /**
     * Set suffixEquipe
     *
     * @param string $suffixEquipe
     * @return ChEquipe
     */
    public function setSuffixEquipe($suffixEquipe)
    {
        $this->suffixEquipe = $suffixEquipe;

        return $this;
    }

    /**
     * Get suffixEquipe
     *
     * @return string 
     */
    public function getSuffixEquipe()
    {
        return $this->suffixEquipe;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set chdivision_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChDivision $chdivisionId
     * @return ChEquipe
     */
    public function setChdivisionId(\sws\Bundle\BackBundle\Entity\ChDivision $chdivisionId = null)
    {
        $this->chdivision_id = $chdivisionId;

        return $this;
    }

    /**
     * Get chdivision_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChDivision 
     */
    public function getChdivisionId()
    {
        return $this->chdivision_id;
    }

    /**
     * Add chequipes_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChContrainte $chequipesId
     * @return ChEquipe
     */
    public function addChequipesId(\sws\Bundle\BackBundle\Entity\ChContrainte $chequipesId)
    {
        $this->chequipes_id[] = $chequipesId;

        return $this;
    }

    /**
     * Remove chequipes_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChContrainte $chequipesId
     */
    public function removeChequipesId(\sws\Bundle\BackBundle\Entity\ChContrainte $chequipesId)
    {
        $this->chequipes_id->removeElement($chequipesId);
    }

    /**
     * Get chequipes_id
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getChequipesId()
    {
        return $this->chequipes_id;
    }

    /**
     * Add chPlanningVisitee
     *
     * @param \sws\Bundle\BackBundle\Entity\ChPlanning $chPlanningVisitee
     * @return ChEquipe
     */
    public function addChPlanningVisitee(\sws\Bundle\BackBundle\Entity\ChPlanning $chPlanningVisitee)
    {
        $this->chPlanningVisitee[] = $chPlanningVisitee;

        return $this;
    }

    /**
     * Remove chPlanningVisitee
     *
     * @param \sws\Bundle\BackBundle\Entity\ChPlanning $chPlanningVisitee
     */
    public function removeChPlanningVisitee(\sws\Bundle\BackBundle\Entity\ChPlanning $chPlanningVisitee)
    {
        $this->chPlanningVisitee->removeElement($chPlanningVisitee);
    }

    /**
     * Add chplanningVisiteuse
     *
     * @param \sws\Bundle\BackBundle\Entity\ChPlanning $chplanningVisiteuse
     * @return ChEquipe
     */
    public function addChplanningVisiteuse(\sws\Bundle\BackBundle\Entity\ChPlanning $chplanningVisiteuse)
    {
        $this->chplanningVisiteuse[] = $chplanningVisiteuse;

        return $this;
    }

    /**
     * Remove chplanningVisiteuse
     *
     * @param \sws\Bundle\BackBundle\Entity\ChPlanning $chplanningVisiteuse
     */
    public function removeChplanningVisiteuse(\sws\Bundle\BackBundle\Entity\ChPlanning $chplanningVisiteuse)
    {
        $this->chplanningVisiteuse->removeElement($chplanningVisiteuse);
    }
}
