<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChDoubles
 *
 * @ORM\Table(name="ChDoubles")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChDoublesRepository")
 */
class ChDoubles
{

        public function __construct()
    {
        $this->createdAt         = new \Datetime();
        $this->updatedAt         = new \Datetime();
    }
    
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroDouble", type="integer")
     */
    private $numeroDouble;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet1_Eq1", type="integer")
     */
    private $jeuxSet1Eq1;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet1_Eq2", type="integer")
     */
    private $jeuxSet1Eq2;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet2_Eq1", type="integer")
     */
    private $jeuxSet2Eq1;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet2_Eq2", type="integer")
     */
    private $jeuxSet2Eq2;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet3_Eq1", type="integer")
     */
    private $jeuxSet3Eq1;

    /**
     * @var integer
     *
     * @ORM\Column(name="jeuxSet3_Eq2", type="integer")
     */
    private $jeuxSet3Eq2;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointsEquipe1", type="integer")
     */
    private $pointsEquipe1;

    /**
     * @var integer
     *
     * @ORM\Column(name="pointsEquipe2", type="integer")
     */
    private $pointsEquipe2;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="ChPlanning")
     * @ORM\JoinColumn(name="chplanning_id", referencedColumnName="id")
     */
    protected $chplanning_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChJoueur")
     * @ORM\JoinColumn(name="joueurs1_Eq1Id", referencedColumnName="id")
     */
    protected $joueurs1_Eq1Id;

    /**
     * @ORM\ManyToOne(targetEntity="ChJoueur")
     * @ORM\JoinColumn(name="joueurs2_Eq1Id", referencedColumnName="id")
     */
    protected $joueurs2_Eq1Id;    

    /**
     * @ORM\ManyToOne(targetEntity="ChJoueur")
     * @ORM\JoinColumn(name="joueurs1_Eq2Id", referencedColumnName="id")
     */
    protected $joueurs1_Eq2Id;

    /**
     * @ORM\ManyToOne(targetEntity="ChJoueur")
     * @ORM\JoinColumn(name="joueurs2_Eq2Id", referencedColumnName="id")
     */
    protected $joueurs2_Eq2Id;    

    /**
     * @ORM\ManyToOne(targetEntity="ChDivision")
     * @ORM\JoinColumn(name="chdivision_id", referencedColumnName="id")
     */
    protected $chdivision_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipeEq1_id", referencedColumnName="id")
     */
    protected $chequipeEq1_id; 
        
    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationEq1_id", referencedColumnName="id")
     */
    protected $chcorporationEq1_id;    

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe")
     * @ORM\JoinColumn(name="chequipeEq2_id", referencedColumnName="id")
     */
    protected $chequipeEq2_id;     

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporationEq2_id", referencedColumnName="id")
     */
    protected $chcorporationEq2_id;   

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;      
    

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;    

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numeroDouble
     *
     * @param integer $numeroDouble
     * @return ChDoubles
     */
    public function setNumeroDouble($numeroDouble)
    {
        $this->numeroDouble = $numeroDouble;

        return $this;
    }

    /**
     * Get numeroDouble
     *
     * @return integer 
     */
    public function getNumeroDouble()
    {
        return $this->numeroDouble;
    }

    /**
     * Set jeuxSet1Eq1
     *
     * @param integer $jeuxSet1Eq1
     * @return ChDoubles
     */
    public function setJeuxSet1Eq1($jeuxSet1Eq1)
    {
        $this->jeuxSet1Eq1 = $jeuxSet1Eq1;

        return $this;
    }

    /**
     * Get jeuxSet1Eq1
     *
     * @return integer 
     */
    public function getJeuxSet1Eq1()
    {
        return $this->jeuxSet1Eq1;
    }

    /**
     * Set jeuxSet1Eq2
     *
     * @param integer $jeuxSet1Eq2
     * @return ChDoubles
     */
    public function setJeuxSet1Eq2($jeuxSet1Eq2)
    {
        $this->jeuxSet1Eq2 = $jeuxSet1Eq2;

        return $this;
    }

    /**
     * Get jeuxSet1Eq2
     *
     * @return integer 
     */
    public function getJeuxSet1Eq2()
    {
        return $this->jeuxSet1Eq2;
    }

    /**
     * Set jeuxSet2Eq1
     *
     * @param integer $jeuxSet2Eq1
     * @return ChDoubles
     */
    public function setJeuxSet2Eq1($jeuxSet2Eq1)
    {
        $this->jeuxSet2Eq1 = $jeuxSet2Eq1;

        return $this;
    }

    /**
     * Get jeuxSet2Eq1
     *
     * @return integer 
     */
    public function getJeuxSet2Eq1()
    {
        return $this->jeuxSet2Eq1;
    }

    /**
     * Set jeuxSet2Eq2
     *
     * @param integer $jeuxSet2Eq2
     * @return ChDoubles
     */
    public function setJeuxSet2Eq2($jeuxSet2Eq2)
    {
        $this->jeuxSet2Eq2 = $jeuxSet2Eq2;

        return $this;
    }

    /**
     * Get jeuxSet2Eq2
     *
     * @return integer 
     */
    public function getJeuxSet2Eq2()
    {
        return $this->jeuxSet2Eq2;
    }

    /**
     * Set jeuxSet3Eq1
     *
     * @param integer $jeuxSet3Eq1
     * @return ChDoubles
     */
    public function setJeuxSet3Eq1($jeuxSet3Eq1)
    {
        $this->jeuxSet3Eq1 = $jeuxSet3Eq1;

        return $this;
    }

    /**
     * Get jeuxSet3Eq1
     *
     * @return integer 
     */
    public function getJeuxSet3Eq1()
    {
        return $this->jeuxSet3Eq1;
    }

    /**
     * Set jeuxSet3Eq2
     *
     * @param integer $jeuxSet3Eq2
     * @return ChDoubles
     */
    public function setJeuxSet3Eq2($jeuxSet3Eq2)
    {
        $this->jeuxSet3Eq2 = $jeuxSet3Eq2;

        return $this;
    }

    /**
     * Get jeuxSet3Eq2
     *
     * @return integer 
     */
    public function getJeuxSet3Eq2()
    {
        return $this->jeuxSet3Eq2;
    }

    /**
     * Set pointsEquipe1
     *
     * @param integer $pointsEquipe1
     * @return ChDoubles
     */
    public function setPointsEquipe1($pointsEquipe1)
    {
        $this->pointsEquipe1 = $pointsEquipe1;

        return $this;
    }

    /**
     * Get pointsEquipe1
     *
     * @return integer 
     */
    public function getPointsEquipe1()
    {
        return $this->pointsEquipe1;
    }

    /**
     * Set pointsEquipe2
     *
     * @param integer $pointsEquipe2
     * @return ChDoubles
     */
    public function setPointsEquipe2($pointsEquipe2)
    {
        $this->pointsEquipe2 = $pointsEquipe2;

        return $this;
    }

    /**
     * Get pointsEquipe2
     *
     * @return integer 
     */
    public function getPointsEquipe2()
    {
        return $this->pointsEquipe2;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     * @return ChDoubles
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     * @return ChDoubles
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set chplanning_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChPlanning $chplanningId
     * @return ChDoubles
     */
    public function setChplanningId(\sws\Bundle\BackBundle\Entity\ChPlanning $chplanningId = null)
    {
        $this->chplanning_id = $chplanningId;

        return $this;
    }

    /**
     * Get chplanning_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChPlanning 
     */
    public function getChplanningId()
    {
        return $this->chplanning_id;
    }

    /**
     * Set joueurs1_Eq1Id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $joueurs1Eq1Id
     * @return ChDoubles
     */
    public function setJoueurs1Eq1Id(\sws\Bundle\BackBundle\Entity\ChJoueur $joueurs1Eq1Id = null)
    {
        $this->joueurs1_Eq1Id = $joueurs1Eq1Id;

        return $this;
    }

    /**
     * Get joueurs1_Eq1Id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChJoueur 
     */
    public function getJoueurs1Eq1Id()
    {
        return $this->joueurs1_Eq1Id;
    }

    /**
     * Set joueurs2_Eq1Id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $joueurs2Eq1Id
     * @return ChDoubles
     */
    public function setJoueurs2Eq1Id(\sws\Bundle\BackBundle\Entity\ChJoueur $joueurs2Eq1Id = null)
    {
        $this->joueurs2_Eq1Id = $joueurs2Eq1Id;

        return $this;
    }

    /**
     * Get joueurs2_Eq1Id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChJoueur 
     */
    public function getJoueurs2Eq1Id()
    {
        return $this->joueurs2_Eq1Id;
    }

    /**
     * Set joueurs1_Eq2Id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $joueurs1Eq2Id
     * @return ChDoubles
     */
    public function setJoueurs1Eq2Id(\sws\Bundle\BackBundle\Entity\ChJoueur $joueurs1Eq2Id = null)
    {
        $this->joueurs1_Eq2Id = $joueurs1Eq2Id;

        return $this;
    }

    /**
     * Get joueurs1_Eq2Id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChJoueur 
     */
    public function getJoueurs1Eq2Id()
    {
        return $this->joueurs1_Eq2Id;
    }

    /**
     * Set joueurs2_Eq2Id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $joueurs2Eq2Id
     * @return ChDoubles
     */
    public function setJoueurs2Eq2Id(\sws\Bundle\BackBundle\Entity\ChJoueur $joueurs2Eq2Id = null)
    {
        $this->joueurs2_Eq2Id = $joueurs2Eq2Id;

        return $this;
    }

    /**
     * Get joueurs2_Eq2Id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChJoueur 
     */
    public function getJoueurs2Eq2Id()
    {
        return $this->joueurs2_Eq2Id;
    }

    /**
     * Set chdivision_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChDivision $chdivisionId
     * @return ChDoubles
     */
    public function setChdivisionId(\sws\Bundle\BackBundle\Entity\ChDivision $chdivisionId = null)
    {
        $this->chdivision_id = $chdivisionId;

        return $this;
    }

    /**
     * Get chdivision_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChDivision 
     */
    public function getChdivisionId()
    {
        return $this->chdivision_id;
    }

    /**
     * Set chcorporationEq1_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationEq1Id
     * @return ChDoubles
     */
    public function setChcorporationEq1Id(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationEq1Id = null)
    {
        $this->chcorporationEq1_id = $chcorporationEq1Id;

        return $this;
    }

    /**
     * Get chcorporationEq1_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationEq1Id()
    {
        return $this->chcorporationEq1_id;
    }

    /**
     * Set chcorporationEq2_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationEq2Id
     * @return ChDoubles
     */
    public function setChcorporationEq2Id(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationEq2Id = null)
    {
        $this->chcorporationEq2_id = $chcorporationEq2Id;

        return $this;
    }

    /**
     * Get chcorporationEq2_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationEq2Id()
    {
        return $this->chcorporationEq2_id;
    }

    /**
     * Set user
     *
     * @param \sws\Bundle\BackBundle\Entity\User $user
     * @return ChDoubles
     */
    public function setUser(\sws\Bundle\BackBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \sws\Bundle\BackBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatId
     * @return ChDoubles
     */
    public function setChampionnatId(\sws\Bundle\BackBundle\Entity\Championnat $championnatId = null)
    {
        $this->championnat_id = $championnatId;

        return $this;
    }

    /**
     * Get championnat_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * Set chequipeEq1_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chequipeEq1Id
     * @return ChDoubles
     */
    public function setChequipeEq1Id(\sws\Bundle\BackBundle\Entity\ChEquipe $chequipeEq1Id = null)
    {
        $this->chequipeEq1_id = $chequipeEq1Id;

        return $this;
    }

    /**
     * Get chequipeEq1_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChEquipe 
     */
    public function getChequipeEq1Id()
    {
        return $this->chequipeEq1_id;
    }

    /**
     * Set chequipeEq2_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chequipeEq2Id
     * @return ChDoubles
     */
    public function setChequipeEq2Id(\sws\Bundle\BackBundle\Entity\ChEquipe $chequipeEq2Id = null)
    {
        $this->chequipeEq2_id = $chequipeEq2Id;

        return $this;
    }

    /**
     * Get chequipeEq2_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChEquipe 
     */
    public function getChequipeEq2Id()
    {
        return $this->chequipeEq2_id;
    }
}
