<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChDivision
 *
 * @ORM\Table(name="ChDivision")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChDivisionRepository")
 */
class ChDivision
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255)
     */
    private $nom;

    /**
     * @var integer
     *
     * @ORM\Column(name="numero", type="integer")
     */
    private $numero;

    /**
     * @var string
     *
     * @ORM\Column(name="suffixe", type="string", length=255, nullable=true)
     */
    private $suffixe;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsMinimum", type="integer")
     */
    private $ptsMinimum;

    /**
     * @var integer
     *
     * @ORM\Column(name="ptsMaximum", type="integer")
     */
    private $ptsMaximum;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=7, nullable=true)
     */
    private $color;

    /**
     * @var string
     *
     * @ORM\Column(name="textColor", type="string", length=7, nullable=true)
     */
    private $textColor;

    /**
     * @var string
     *
     * @ORM\Column(name="genre", type="string", length=1, nullable=true)
     */
    private $genre;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\OneToMany(targetEntity="ChEquipe", mappedBy="chdivision_id")
     *
     */
    private $chdivisions;

    /**
     * @var integer
     *
     * @ORM\Column(name="nbTours", type="integer")
     */
    private $nbTours;

    /**
     * @Gedmo\Slug(fields={"nom","numero","suffixe","createdAt"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;


    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }    

    /**
     * @return int
     */
    public function getNbTours()
    {
        return $this->nbTours;
    }

    /**
     * @param int $nbTours
     */
    public function setNbTours($nbTours)
    {
        $this->nbTours = $nbTours;
    }

    /**
     * @return string
     */
    public function getGenre()
    {
        return $this->genre;
    }

    /**
     * @param string $genre
     */
    public function setGenre($genre)
    {
        $this->genre = $genre;
    }

    /**
     * @return mixed
     */
    public function getChdivisions()
    {
        return $this->chdivisions;
    }

    /**
     * @param mixed $chdivisions
     */
    public function setChdivisions($chdivisions)
    {
        $this->chdivisions = $chdivisions;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     * @return ChDivision
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string 
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set numero
     *
     * @param integer $numero
     * @return ChDivision
     */
    public function setNumero($numero)
    {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero
     *
     * @return integer 
     */
    public function getNumero()
    {
        return $this->numero;
    }

    /**
     * Set suffixe
     *
     * @param string $suffixe
     * @return ChDivision
     */
    public function setSuffixe($suffixe)
    {
        $this->suffixe = $suffixe;

        return $this;
    }

    /**
     * Get suffixe
     *
     * @return string 
     */
    public function getSuffixe()
    {
        return $this->suffixe;
    }

    /**
     * Set ptsMinimum
     *
     * @param integer $ptsMinimum
     * @return ChDivision
     */
    public function setPtsMinimum($ptsMinimum)
    {
        $this->ptsMinimum = $ptsMinimum;

        return $this;
    }

    /**
     * Get ptsMinimum
     *
     * @return integer 
     */
    public function getPtsMinimum()
    {
        return $this->ptsMinimum;
    }

    /**
     * Set ptsMaximum
     *
     * @param integer $ptsMaximum
     * @return ChDivision
     */
    public function setPtsMaximum($ptsMaximum)
    {
        $this->ptsMaximum = $ptsMaximum;

        return $this;
    }

    /**
     * Get ptsMaximum
     *
     * @return integer 
     */
    public function getPtsMaximum()
    {
        return $this->ptsMaximum;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set user
     *
     * @param \sws\Bundle\BackBundle\Entity\User $user
     * @return ChDivision
     */
    public function setUser(\sws\Bundle\BackBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \sws\Bundle\BackBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatId
     * @return ChDivision
     */
    public function setChampionnatId(\sws\Bundle\BackBundle\Entity\Championnat $championnatId = null)
    {
        $this->championnat_id = $championnatId;

        return $this;
    }

    /**
     * Get championnat_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * Set color
     *
     * @param string $color
     * @return ChDivision
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string 
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Add chdivisions
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chdivisions
     * @return ChDivision
     */
    public function addChdivision(\sws\Bundle\BackBundle\Entity\ChEquipe $chdivisions)
    {
        $this->chdivisions[] = $chdivisions;

        return $this;
    }

    /**
     * Remove chdivisions
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chdivisions
     */
    public function removeChdivision(\sws\Bundle\BackBundle\Entity\ChEquipe $chdivisions)
    {
        $this->chdivisions->removeElement($chdivisions);
    }

    /**
     * Set textColor
     *
     * @param string $textColor
     * @return ChDivision
     */
    public function setTextColor($textColor)
    {
        $this->textColor = $textColor;

        return $this;
    }

    /**
     * Get textColor
     *
     * @return string 
     */
    public function getTextColor()
    {
        return $this->textColor;
    }
}
