<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChCorporation
 *
 * @ORM\Table(name="ChCorporation")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChCorporationRepository")
 */
class ChCorporation
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="Corporation")
     * @ORM\JoinColumn(name="corporation_id", referencedColumnName="id")
     */
    protected $corporation_id;

    /**
     * @ORM\OneToMany(targetEntity="ChEquipe", mappedBy="chcorporation_id")
     *
     */
    private $chequipes;

    /**
     * @ORM\OneToMany(targetEntity="ChJoueur", mappedBy="chcorporation_id")
     *
     */
    private $chequipesJoueurs;

    /**
     * @Gedmo\Slug(handlers={
     *      @Gedmo\SlugHandler(class="Gedmo\Sluggable\Handler\RelativeSlugHandler", options={
     *          @Gedmo\SlugHandlerOption(name="relationField", value="corporation_id"),
     *          @Gedmo\SlugHandlerOption(name="relationSlugField", value="slug"),
     *          @Gedmo\SlugHandlerOption(name="separator", value="-"),
     *          @Gedmo\SlugHandlerOption(name="urilize", value=true)
     *      })
     * },fields={"createdAt"})
     * @ORM\Column(length=128, unique=true)
     */

    private $slug;    

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }    

    /**
     * @return mixed
     */
    public function getChequipesJoueurs()
    {
        return $this->chequipesJoueurs;
    }

    /**
     * @param mixed $chequipesJoueurs
     */
    public function setChequipesJoueurs($chequipesJoueurs)
    {
        $this->chequipesJoueurs = $chequipesJoueurs;
    }

    /**
     * @return mixed
     */
    public function getChequipes()
    {
        return $this->chequipes;
    }

    /**
     * @param mixed $chequipes
     */
    public function setChequipes($chequipes)
    {
        $this->chequipes = $chequipes;
    }



    /**
     * @return mixed
     */
    public function getCorporationId()
    {
        return $this->corporation_id;
    }

    /**
     * @param mixed $corporation_id
     */
    public function setCorporationId($corporation_id)
    {
        $this->corporation_id = $corporation_id;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param mixed $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }

     /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Add chequipes
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chequipes
     * @return ChCorporation
     */
    public function addChequipe(\sws\Bundle\BackBundle\Entity\ChEquipe $chequipes)
    {
        $this->chequipes[] = $chequipes;

        return $this;
    }

    /**
     * Remove chequipes
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chequipes
     */
    public function removeChequipe(\sws\Bundle\BackBundle\Entity\ChEquipe $chequipes)
    {
        $this->chequipes->removeElement($chequipes);
    }

    /**
     * Add chequipesJoueurs
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $chequipesJoueurs
     * @return ChCorporation
     */
    public function addChequipesJoueur(\sws\Bundle\BackBundle\Entity\ChJoueur $chequipesJoueurs)
    {
        $this->chequipesJoueurs[] = $chequipesJoueurs;

        return $this;
    }

    /**
     * Remove chequipesJoueurs
     *
     * @param \sws\Bundle\BackBundle\Entity\ChJoueur $chequipesJoueurs
     */
    public function removeChequipesJoueur(\sws\Bundle\BackBundle\Entity\ChJoueur $chequipesJoueurs)
    {
        $this->chequipesJoueurs->removeElement($chequipesJoueurs);
    }
}
