<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * ChCorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChContrainteSalleRepository extends EntityRepository
{

    public function getChContrainteSalle($id)
    {
        $query = $this->createQueryBuilder('e')
            ->where('e.chsalle_id = :id')
            ->setParameter('id', $id)
            ->orderBy('e.priorite', 'DESC')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    public function getChSalleNbContraintes($idSalleCh)
    {
        $query = $this->createQueryBuilder('c');
        $query 
            ->select('count(c.id)')
            ->where('c.chsalle_id = :idSalleCh')
            ->setParameter('idSalleCh', $idSalleCh)
        ;

        $result = $query->getQuery()->getSingleScalarResult();
        return (int) $result;
    }        

    public function getChSalleContraintesPeriode($fonction, $idSalleCh, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chsalle_id = :idSalleCh')
            ->setParameter('idSalleCh', $idSalleCh)
            ->andWhere('c.type = \'Periode\'')
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }

}
