<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * ChCorporationRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ChContrainteRepository extends EntityRepository
{

    public function getChContrainte($id)
    {
        $query = $this->createQueryBuilder('e')
            ->where('e.chequipe_id = :id')
            ->setParameter('id', $id)
            ->orderBy('e.priorite', 'DESC')
        ;

        $result = $query->getQuery()->execute();
        return $result;
    }

    /**
     * Cette fonction retourne les équipes du championnat qui ont une fourchette de points comprise dans la range de
     * point de la division
     *
     * @param $PtsMinimum : Points minimum de la division
     * @param $PtsMaximum : Points maximum de la division
     *
     */
    public function getChEquipesNbContraintes($idEquipeCh)
    {
        $query = $this->createQueryBuilder('c');
        $query 
            ->select('count(c.id)')
            ->where('c.chequipe_id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idEquipeCh)
        ;

        $result = $query->getQuery()->getSingleScalarResult();
        return (int) $result;
    }        

    public function getChEquipesContraintesJour($fonction, $idEquipeCh1, $idEquipeCh2, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh1')
            ->setParameter('idEquipeCh1', $idEquipeCh1)
            ->orWhere('c.chequipe_id = :idEquipeCh2')
            ->andWhere('c.type = \'Jour\'')
            ->setParameter('idEquipeCh2', $idEquipeCh2)
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }     
    
    public function getChEquipeContraintesJour($fonction, $idEquipeCh, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idEquipeCh)
            ->andWhere('c.type = \'Jour\'')
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }      

    public function getChEquipesContraintesSalle($fonction, $idEquipeCh1, $idEquipeCh2, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh1')
            ->setParameter('idEquipeCh1', $idEquipeCh1)
            ->orWhere('c.chequipe_id = :idEquipeCh2')
            ->andWhere('c.type = \'Salle\'')
            ->setParameter('idEquipeCh2', $idEquipeCh2)
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();
        
        return $result;
    }
    
    public function getChEquipeContraintesSalle($fonction, $idEquipeCh, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh')
            ->setParameter('idEquipeCh', $idEquipeCh)
            ->andWhere('c.type = \'Salle\'')
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();
        
        return $result;
    }    

    public function getChEquipesContraintesPeriode($fonction, $idEquipeCh1, $idEquipeCh2, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh1')
            ->setParameter('idEquipeCh1', $idEquipeCh1)
            ->orWhere('c.chequipe_id = :idEquipeCh2')
            ->andWhere('c.type = \'Periode\'')
            ->setParameter('idEquipeCh2', $idEquipeCh2)
            ->andWhere('c.fonction = :fonction')
            ->setParameter('fonction', $fonction)
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }
    
    public function getChEquipesContraintesVacancesScolaires($idEquipeCh1, $idEquipeCh2, $idChampionnat)
    {
        $query = $this->createQueryBuilder('c')
            ->where('c.championnat_id = :idChampionnat')
            ->setParameter('idChampionnat', $idChampionnat)
            ->andWhere('c.chequipe_id = :idEquipeCh1')
            ->setParameter('idEquipeCh1', $idEquipeCh1)
            ->orWhere('c.chequipe_id = :idEquipeCh2')
            ->andWhere('c.typeCode = \'3\'')
            ->setParameter('idEquipeCh2', $idEquipeCh2)
            ->andWhere('c.fonction = \'E\'')
        ;

        $result = $query->getQuery()->execute();

        return $result;
    }        

}
