<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * ChContrainte
 *
 * @ORM\Table(name="ChContrainte")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChContrainteRepository")
 */
class ChContrainte
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="fonction", type="string", length=1)
     */
    private $fonction;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=255)
     */
    private $type;
    
    /**
     * @var string
     *
     * @ORM\Column(name="typeCode", type="string", length=1)
     */
    private $typeCode;    

    /**
     * @var integer
     *
     * @ORM\Column(name="jour", type="integer", nullable=true)
     */
    private $jour;

    /**
     * @var integer
     *
     * @ORM\Column(name="priorite", type="integer")
     */
    private $priorite;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="create")
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     * @Gedmo\Timestampable(on="update")
     * @ORM\Column(name="updatedAt", type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    protected $user;

    /**
     * @ORM\ManyToOne(targetEntity="ChCorporation")
     * @ORM\JoinColumn(name="chcorporation_id", referencedColumnName="id")
     */
    protected $chcorporation_id;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChEquipe", inversedBy="chequipes_id")
     * @ORM\JoinColumn(name="chequipe_id", referencedColumnName="id")
     */
    protected $chequipe_id;

    /**
     * @ORM\ManyToOne(targetEntity="ChSalle")
     * @ORM\JoinColumn(name="chSalle_id", referencedColumnName="id", nullable=true)
     */
    protected $chSalle_id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="periodeDebut", type="datetime", nullable=true)
     */
    private $periodeDebut;

    /**
     * @return \DateTime
     */
    public function getPeriodeDebut()
    {
        return $this->periodeDebut;
    }

    /**
     * @param \DateTime $periodeDebut
     */
    public function setPeriodeDebut($periodeDebut)
    {
        $this->periodeDebut = $periodeDebut;
    }

    /**
     * @return \DateTime
     */
    public function getPeriodeFin()
    {
        return $this->periodeFin;
    }

    /**
     * @param \DateTime $periodeFin
     */
    public function setPeriodeFin($periodeFin)
    {
        $this->periodeFin = $periodeFin;
    }

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="periodeFin", type="datetime", nullable=true)
     */
    private $periodeFin;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fonction
     *
     * @param string $fonction
     * @return ChContrainte
     */
    public function setFonction($fonction)
    {
        $this->fonction = $fonction;

        return $this;
    }

    /**
     * Get fonction
     *
     * @return string 
     */
    public function getFonction()
    {
        return $this->fonction;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return ChContrainte
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set jour
     *
     * @param integer $jour
     * @return ChContrainte
     */
    public function setJour($jour)
    {
        $this->jour = $jour;

        return $this;
    }

    /**
     * Get jour
     *
     * @return integer 
     */
    public function getJour()
    {
        return $this->jour;
    }

    /**
     * Set priorite
     *
     * @param integer $priorite
     * @return ChContrainte
     */
    public function setPriorite($priorite)
    {
        $this->priorite = $priorite;

        return $this;
    }

    /**
     * Get priorite
     *
     * @return integer 
     */
    public function getPriorite()
    {
        return $this->priorite;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime 
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime 
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set user
     *
     * @param \sws\Bundle\BackBundle\Entity\User $user
     * @return ChContrainte
     */
    public function setUser(\sws\Bundle\BackBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \sws\Bundle\BackBundle\Entity\User 
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set chcorporation_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationId
     * @return ChContrainte
     */
    public function setChcorporationId(\sws\Bundle\BackBundle\Entity\ChCorporation $chcorporationId = null)
    {
        $this->chcorporation_id = $chcorporationId;

        return $this;
    }

    /**
     * Get chcorporation_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChCorporation 
     */
    public function getChcorporationId()
    {
        return $this->chcorporation_id;
    }

    /**
     * Set championnat_id
     *
     * @param \sws\Bundle\BackBundle\Entity\Championnat $championnatId
     * @return ChContrainte
     */
    public function setChampionnatId(\sws\Bundle\BackBundle\Entity\Championnat $championnatId = null)
    {
        $this->championnat_id = $championnatId;

        return $this;
    }

    /**
     * Get championnat_id
     *
     * @return \sws\Bundle\BackBundle\Entity\Championnat 
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * Set chequipe_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChEquipe $chequipeId
     * @return ChContrainte
     */
    public function setChequipeId(\sws\Bundle\BackBundle\Entity\ChEquipe $chequipeId = null)
    {
        $this->chequipe_id = $chequipeId;

        return $this;
    }

    /**
     * Get chequipe_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChEquipe 
     */
    public function getChequipeId()
    {
        return $this->chequipe_id;
    }

    /**
     * Set chSalle_id
     *
     * @param \sws\Bundle\BackBundle\Entity\ChSalle $chSalleId
     * @return ChContrainte
     */
    public function setChSalleId(\sws\Bundle\BackBundle\Entity\ChSalle $chSalleId = null)
    {
        $this->chSalle_id = $chSalleId;

        return $this;
    }

    /**
     * Get chSalle_id
     *
     * @return \sws\Bundle\BackBundle\Entity\ChSalle 
     */
    public function getChSalleId()
    {
        return $this->chSalle_id;
    }
    
    /**
     * @return string
     */
    public function getTypeCode()
    {
        return $this->typeCode;
    }

    /**
     * @param string $typeCode
     */
    public function setTypeCode($typeCode)
    {
        $this->typeCode = $typeCode;
    }
    
}
