<?php

namespace sws\Bundle\BackBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ChClassement
 *
 * @ORM\Table(name="ChClassement")
 * @ORM\Entity(repositoryClass="sws\Bundle\BackBundle\Entity\ChClassementRepository")
 *
 */
class ChClassement
{
    public function __construct()
    {
        $this->createdAt         = new \Datetime();
        $this->updatedAt         = new \Datetime();
    }

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="classement", type="string", length=255)
     */
    private $classement;

    /**
     * @var integer
     *
     * @ORM\Column(name="valeur", type="integer")
     */
    private $valeur;

    /**
     * @var integer
     *
     * @ORM\Column(name="numeroOrdre", type="integer")
     */
    private $numeroOrdre;

    /**
     * @ORM\ManyToOne(targetEntity="Championnat")
     * @ORM\JoinColumn(name="championnat_id", referencedColumnName="id")
     */
    protected $championnat_id;

    /**
     * @return mixed
     */
    public function getChampionnatId()
    {
        return $this->championnat_id;
    }

    /**
     * @param mixed $championnat_id
     */
    public function setChampionnatId($championnat_id)
    {
        $this->championnat_id = $championnat_id;
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set classement
     *
     * @param string $classement
     * @return ChClassement
     */
    public function setClassement($classement)
    {
        $this->classement = $classement;

        return $this;
    }

    /**
     * Get classement
     *
     * @return string 
     */
    public function getClassement()
    {
        return $this->classement;
    }

    /**
     * Set valeur
     *
     * @param integer $valeur
     * @return ChClassement
     */
    public function setValeur($valeur)
    {
        $this->valeur = $valeur;

        return $this;
    }

    /**
     * Get valeur
     *
     * @return integer 
     */
    public function getValeur()
    {
        return $this->valeur;
    }

    /**
     * Set numeroOrdre
     *
     * @param integer $numeroOrdre
     * @return ChClassement
     */
    public function setNumeroOrdre($numeroOrdre)
    {
        $this->numeroOrdre = $numeroOrdre;

        return $this;
    }

    /**
     * Get numeroOrdre
     *
     * @return integer 
     */
    public function getNumeroOrdre()
    {
        return $this->numeroOrdre;
    }
}
