<?php


namespace sws\Bundle\BackBundle\Controller;


use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use sws\Bundle\BackBundle\Form\Type\UserType;
use sws\Bundle\BackBundle\Form\Type\UserModifyType;
use sws\Bundle\BackBundle\Form\Handler\UserHandler;
use sws\Bundle\BackBundle\Entity\User;


/**
 * Controller managing the registration
 *
 */
class UserController extends Controller
{
    /**
     * Crée une entité User
     *
     * @param Request $request Contenu de la requête HTTP
     *
     */
    public function registrationAction(Request $request)
    {

        $user = new User();
        $formHandler = new UserHandler($this->createForm(new UserType(), $user), $request);

        if ($formHandler->verification()) {

            $user = $formHandler->getForm()->getData();
            $user->setBlogDisplayName($user->getusername());

            //$file = $form->get('file')->getData();

            $em = $this->getDoctrine()->getEntityManager();

            $user->upload();
            $em-> persist($user);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_dashboard'));
        }

        return $this->render('swsBackBundle:User:registration.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    /**
     * Affiche la liste des utilisateurs
     *
     * Si le paramètre $critereParam est = à 'no#critere", la fonction renvoie les utilisateurs sans appliquer de filtre.
     * Si le paramètre $critereParam est != de 'no#critere", la fonction renvoie les utilisateurs filtrés sur le nom et
     * le prénom selon le critère fourni.
     *
     * Le paramètre "critereParam" de la route sws_back_listuser est initialisé par défaut à 'no#critere' via la
     * configuration de la route.
     *
     * @param int $id Valeur de l'identification du user
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listjoueur
     * @return form vers la template swsBackBundle:Joueurs:modify.html.twig
     */
    public function listAction($page, $critereParam, Request $request)
    {
        if (!is_numeric($page)) {
            throw $this->createNotFoundException("La n° de page est incorrect: ".$page);
        }

        $form = $this->get('form.factory')->createBuilder('form')
            ->add('critere','text')
            ->getForm()
        ;

        $form->handleRequest($request);

        if ($form->isValid() or $critereParam <> 'no#critere') {

            if ($page < 1) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 15;
            $postForm = $request->request->get('form');

            if ($critereParam <> 'no#critere'){

                $critere = $critereParam;
            }
            else{

                $critere = $postForm['critere'];
            }


            $listUsers = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:User')
                ->getUsersByCritere($critere, $page, $nbPerPage)
            ;

            $nbPages = ceil(count($listUsers)/$nbPerPage);

            return $this->render('swsBackBundle:User:list.html.twig', array(
                'listUsers' => $listUsers,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => $critere
            ));
        }
        else {

            if ($page < 1) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 15;

            $listUsers = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:User')
                ->getUsers($page, $nbPerPage)
            ;

            $nbPages = ceil(count($listUsers)/$nbPerPage);

            return $this->render('swsBackBundle:User:list.html.twig', array(
                'listUsers' => $listUsers,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => 'no#critere'
            ));
        }
    }

    /**
     * Modifie l'état d'une entité User
     *
     * Si l'état du user est inactif (= 0) alors l'état est initialisé à actif (=1).
     * Si l'état du user est actif (= 1) alors l'état est initialisé à inactif (=0).
     *
     * @param int $id Valeur de l'identification du user
     *
     * @return route sws_back_listuser
     */
    public function modifyStatusAction($id)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:User');
        $user = $repository->find($id);

        if (!$user) {
            throw $this->createNotFoundException("Le user avec l'identifiant ".$id." n'existe pas.");
        }

        $status = $user->isEnabled();

        if ($status == 0)
        {
            $user->setEnabled(1);
        }
        else
        {
            $user->setEnabled(0);
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em-> persist($user);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listuser'));
    }

    /**
     * Modifie une entité User
     *
     * @param int $id Valeur de l'identification du user
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listuser
     * @return form vers la template swsBackBundle:User:modify.html.twig
     */
    public function modifyAction($id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:User');
        $user = $repository->find($id);

        $old_path = $user->getPath();

        if (!$user) {
            throw $this->createNotFoundException("Le user avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new UserHandler($this->createForm(new UserModifyType(), $user), $request);

        if ($formHandler->verification()) {

            $user = $formHandler->getForm()->getData();

            $form = $request->request->get('User_form');
            if (array_key_exists('deletePhoto', $form )) {


                // Suppression de la photo
                $user->setPath('/bundles/swsback/images/photoUser/noimage.png');

                if ($old_path <> '/bundles/swsback/images/photoUser/noimage.png'){

                    // il faut supprimer le fichier également ($old_path)
                    unlink(__DIR__.'/../../../../../web'.$old_path);
                }
            }else{

                if ($user->file <> null){
                    $user->upload();
                }
                else{
                    $user->setPath($old_path);
                }

            }

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($user);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listuser'));
        }

        return $this->render('swsBackBundle:User:modify.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'id' => $id
        ));
    }
}
