<?php

/**
 * Fichier: ReduController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité Redu
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Redu;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use sws\Bundle\BackBundle\Form\Type\ImportReduType;
use sws\Bundle\BackBundle\Form\Handler\ImportReduHandler;
use Symfony\Component\HttpFoundation\JsonResponse;

class ReduController extends Controller
{

    /**
     * Affiche la liste des joueurs du fihier redu
     *
     * Si le paramètre $critereParam est = à 'no#critere", la fonction renvoie les joueurs sans appliquer de filtre.
     * Si le paramètre $critereParam est != de 'no#critere", la fonction renvoie les joueurs filtrés sur le nom et
     * le prénom selon le critère fourni.
     *
     * Le paramètre "critereParam" de la route sws_back_listjoueur est initialisé par défaut à 'no#critere' via la
     * configuration de la route.
     *
     * @param int $id Valeur de l'identification du joueur
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listjoueurredu
     */
    public function listAction($page, $critereParam, Request $request)
    {
        if (!is_numeric($page)) {
            throw $this->createNotFoundException("La page n° ".$page." n'existe pas.");
        }

        $form = $this->get('form.factory')->createBuilder('form')
          ->add('critere','text')
          ->getForm()
        ;

        $form->handleRequest($request);

        if ($form->isValid() or $critereParam <> 'no#critere') {
          
           if ($page < 1) {
              throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 50;
            $postForm = $request->request->get('form');

            if ($critereParam <> 'no#critere'){

                $critere = $critereParam;    
            }
            else{
                
                $critere = $postForm['critere'];    
            }
            

            $listJoueursRedu = $this->getDoctrine()
              ->getManager()
              ->getRepository('swsBackBundle:Redu')
              ->getJoueursReduByCritere($critere, $page, $nbPerPage)
            ;

            $nbPages = ceil(count($listJoueursRedu)/$nbPerPage);

            /*
            if ($page > $nbPages) {
              throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }
            */

            return $this->render('swsBackBundle:Redu:list.html.twig', array(
                'listJoueurs' => $listJoueursRedu,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => $critere
            ));
        }
        else {

            if ($page < 1) {
              throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 50;

            $listJoueursRedu = $this->getDoctrine()
              ->getManager()
              ->getRepository('swsBackBundle:Redu')
              ->getJoueursRedu($page, $nbPerPage)
            ;

            $nbPages = ceil(count($listJoueursRedu)/$nbPerPage);

            /*
            if ($page > $nbPages) {
              throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }
            */

            return $this->render('swsBackBundle:Redu:list.html.twig', array(
                /*'joueurs' => $joueurs,*/
                'listJoueurs' => $listJoueursRedu,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => 'no#critere'
            ));
        }
    }


    /**
     * Upload du fichier redu
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listjoueur
     * @return form vers la template swsBackBundle:Joueurs:create.html.twig
     */
    public function uploadAction(Request $request)
    {
        $reduForm = new Redu();
        $form = $this->createFormBuilder($reduForm)
            ->add('file','file')
            ->add('submit','submit')
            ->getForm()
        ;

        $form->handleRequest($request);

        if ($request->ismethod('post') && $form->isValid()) {

            $file = $form->get('file')->getData();

            $file->move('/home/appriltennis/tmp','redu.csv');

            $db = $this->getDoctrine()->getEntityManager()->getConnection();
            $sql1 = "DELETE from redu";

            $now = new \DateTime();

            $sql2 = "LOAD DATA INFILE '".addslashes('/home/appriltennis/www/redu.csv')."' INTO TABLE redu FIELDS TERMINATED BY ';' IGNORE 1 LINES SET id = NULL";
            $stmt = $db->prepare($sql1);
            $stmt->execute();
            $stmt = $db->prepare($sql2);
            $stmt->execute();


            /*

            $sql3 = "SELECT * from table22";
            $stmt = $db->prepare($sql3);
            $stmt->execute();
            
            $i = 0;
            while($row = $stmt->fetch()){

                if ($row['COL 1'] <> 'AF_NUMERO') {

                    $redu = new Redu();

                    $NumAFT = $row['COL 1'];

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Redu');
                    $joueurRedu = $repository->findOneBy(array('AFNUMERO' => $NumAFT, 'championnat_id' => $idChampionnat));

                    if (!$joueurRedu) {

                        $i = $i+1;

                        $redu->setChampionnatId($Championnat);
                        $redu->setAFNUMERO($NumAFT);
                        $redu->setaFNOM($row['COL 2']);
                        $redu->setaFPRENOM($row['COL 3']);

                        if (strlen( $row['COL 4'] ) == 9 ){

                            $dateTemp = substr($row['COL 4'],5,4).'-'.substr($row['COL 4'],2,2).'-'.substr($row['COL 4'],0,1);
                        }
                        else{
                            $dateTemp = substr($row['COL 4'],6,4).'-'.substr($row['COL 4'],3,2).'-'.substr($row['COL 4'],0,2);
                        }
                      
                        $redu->setaFNAISSANCE(new \DateTime($dateTemp));

                        $redu->setaFCLUB1($row['COL 5']);
                        $redu->setaFSEXE(substr ( $row['COL 6'] , 0 , strpos($row['COL 6'], ',')));
                        $redu->setaFCLASSMT(substr ( $row['COL 7'] , 0 , strpos($row['COL 7'], ',')));
                        $redu->setaFNUMCLASS($row['COL 8']);
                        $redu->setaFCLASSMTDOU(substr ( $row['COL 9'] , 0 , strpos($row['COL 9'], ',')));
                        $redu->setaFINTERCLUB($row['COL 10']);
                        $redu->setaFTELEPH($row['COL 11']);
                        $redu->setaFGSM($row['COL 12']);                        
                        $redu->setaFTEMPON($row['COL 13']);   

                        $em = $this->getDoctrine()->getManager();
                        $em->persist($redu);
                        $em->flush();

                        if ( $i == 100 ){
                            $em->flush();       
                            $i = 0;
                        }
                    }
                }       
            }

            $em->flush();
    */

    /*
            if (($handle = fopen($file->getRealPath(), "r")) !== FALSE) {
                
                $i = 1;
                
                while(($row = fgetcsv($handle,1024,';')) !== FALSE) {

                    if ($row[0] <> 'AF_NUMERO') {

                        $i = $i++;

                        $redu = new Redu();

                        $NumAFT = $row[0];

                        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Redu');
                        $joueurRedu = $repository->findOneBy(array('AFNUMERO' => $NumAFT));

                        if (!$joueurRedu) {

                            $redu->setChampionnatId($Championnat);
                            $redu->setAFNUMERO($NumAFT);
                            $redu->setaFNOM($row[1]);
                            $redu->setaFPRENOM($row[2]);

                            if (strlen( $row[3] ) == 9 ){

                                $dateTemp = substr($row[3],5,4).'-'.substr($row[3],2,2).'-'.substr($row[3],0,1);
                            }
                            else{
                                $dateTemp = substr($row[3],6,4).'-'.substr($row[3],3,2).'-'.substr($row[3],0,2);
                            }
                          
                            $redu->setaFNAISSANCE(new \DateTime($dateTemp));

                            $redu->setaFCLUB1($row[4]);
                            $redu->setaFSEXE(substr ( $row[5] , 0 , strpos($row[5], ',')));
                            $redu->setaFCLASSMT(substr ( $row[6] , 0 , strpos($row[6], ',')));
                            $redu->setaFNUMCLASS($row[7]);
                            $redu->setaFCLASSMTDOU(substr ( $row[8] , 0 , strpos($row[8], ',')));
                            $redu->setaFINTERCLUB($row[9]);
                            $redu->setaFTELEPH($row[10]);
                            $redu->setaFGSM($row[11]);                        
                            $redu->setaFTEMPON($row[12]);   

                            $em = $this->getDoctrine()->getManager();
                            $em->persist($redu);
                            if ( $i == 50 ){
                                $em->flush();       
                                $i = 0;
                            }
                            
                        }
                    }
                }

                $em->flush();    
                
            }
            */

            $bag = $this->get('session')->getFlashBag();
            $bag->set('message', 'L\'importation du fichier redu a été réalisée avec succès.');

            return $this->redirect($this->generateUrl('sws_back_uploadredu'));           
        }

        return $this->render('swsBackBundle:Redu:upload.html.twig',array(
            'form' => $form->createView()
        ));
    }

    public function getJoueurReduAction(Request $request)
    {

        $numAFT = $request->request->get('numAft');

        if ($request->isXMLHttpRequest()) {

            $JoueurRedu = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:Redu')
                ->getJoueurReduArray($numAFT);

            if (!$JoueurRedu) {
                throw $this->createNotFoundException("Le joueur Redu avec Num AFT = ".$numAFT." n'existe pas.");
            }

            return new JsonResponse($JoueurRedu);
        }
        else{
            throw new \Exception('Accès non autorisé !');
        }
    }

}