<?php

/**
 * Fichier: PdfController.php
 *
 * Easy-Sports.net
 * Controleur des PDF
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Redu;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use sws\Bundle\BackBundle\Form\Type\ImportReduType;
use sws\Bundle\BackBundle\Form\Handler\ImportReduHandler;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class PdfController extends Controller
{

    /**
     * Affiche la liste des joueurs du fihier redu
     *
     * 
     * @return route sws_back_listjoueurredu
     */
    public function invoiceAction()
    {
 
        //return $this->render('swsBackBundle:Pdf:invoice.html.twig');

        
           
        $html = $this->renderView('swsBackBundle:Pdf:invoice.html.twig');

        
        return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml($html,
                        array('orientation'=>'Landscape',
                            'default-header'=>false)),
                200,
                array(
                    'Content-Type'          => 'application/pdf',
                    'Content-Disposition'   => 'attachment; filename="file.pdf"'
                )
            );

            
       
    }
}