<?php

/**
 * Fichier: DefaultController.php
 *
 * Easy-Sports.net
 * Controleur system
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;


class DefaultController extends Controller
{

    public function indexdAction(Request $request)
    {

        return $this->render('swsBackBundle:default:index.html.twig');

    }
     /**
     * Bloque la session de l'utilisateur
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return la template swsBackBundle:default:session.locked.html.twig
     */
    public function sessionsLockedAction(Request $request)
    {

        return $this->render('swsBackBundle:Default:session.locked.html.twig');

    }

    public function loadActivitiesAction()
    {
        // Récupérer les dernières activités
        $auditReader = $this->container->get('simplethings_entityaudit.reader');

        $revisions = $auditReader->findRevisionHistory(20, 0);

        $ind = 0;
        $repUser = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:User');

        foreach ($revisions as $keys => $revision) {

            $user = $repUser->findOneBy(array('username' => $revision->getUsername()));
            $entity = $auditReader->findEntitiesChangedAtRevision($revision->getRev());

                $changedEntities[$ind][] = $revision;
                $changedEntities[$ind][] = $auditReader->findEntitiesChangedAtRevision($revision->getRev());
                $changedEntities[$ind][] = $repUser->findBy(array('username' => $revision->getUsername()));

                $ind++;

        }

        return $this->render('swsBackBundle:Includes:quick-sidebar.html.twig',array(
                'changedEntities' => $changedEntities
            )
        );

    }



}

