<?php

/**
 * Fichier: DashboardController.php
 *
 * Easy-Sports.net
 * Controleur system
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

class DashboardController extends Controller
{

    /**
     * Affiche le dashboard
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return la template swsBackBundle:default:dashboard.html.twig
     */
    public function dashboardAction(Request $request)
    {

        // Tester ici le role de l'utilisateur afin de l'orienter vers la bonne applic

        $securityContext = $this->get('security.context');
        if ($securityContext->isGranted('ROLE_ADMIN')){

            // Go to gestion de championnat

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            // On recupère le championnat actif
            $Championnat = $repository->findOneBysetTdb(1);

            if (!$Championnat) {

                return $this->render('swsBackBundle:Dashboard:dashboard.html.twig');
            }

            return $this->forward('swsBackBundle:Championnat:manager', array(
                'id'=> $Championnat->getId()
            ));
        }
        elseif($securityContext->isGranted('ROLE_DELEGUE') or $securityContext->isGranted('ROLE_CAPITAINE')){

            // Go to compte délegué
            return $this->render('swsBackBundle:MyRil:dashboard.html.twig');
        }
        else
        {
            throw new AccessDeniedHttpException();
        }


        $rootPath=$this->get('router')->generate('fos_user_security_login', array(), true);
        $referer = $request->server->get('HTTP_REFERER');


    }
}

