<?php

/**
 * Fichier: ChampionnatController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité Championnat
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\Salle;
use sws\Bundle\BackBundle\Entity\ChParametres;
use sws\Bundle\BackBundle\Entity\ChIndisponibilite;
use sws\Bundle\BackBundle\Entity\ChClassement;
use sws\Bundle\BackBundle\Entity\ChRencontreReject;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChampionnatType;
use sws\Bundle\BackBundle\Form\Type\ChParametresType;
use sws\Bundle\BackBundle\Form\Handler\ChampionnatHandler;
use sws\Bundle\BackBundle\Form\Handler\ChParametresHandler;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;


class ChampionnatController extends Controller
{

    /**
     * Affiche une entité Championnat
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:Championnat:view.html.twig
     */
    public function managerAction($id, Request $request)
    {
       // $session = new Session();
       // $session->set('onglet', 'tdb'); // Onglet tableau de bord

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($id);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$id." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($id);

        // On recupere les salles associées au championnat
        $ChSalle = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getChSalle($id);

        // On recupere les salles a ajouter au championnat (pas encore associées)
        $listSallesCh = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Salle')
            ->getSallesCh($id);

        // On recupere les corporations associées au championnat
        $ChCorporation = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($id);

        // On recupere les corporations a ajouter au championnat (pas encore associées)
        $listCorporationsCh = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Corporation')
            ->getCorporationsCh($id);

       // On recupere les divisions associées au championnat
        $ChDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDivision')
            ->getChDivision($id);

       // $listRencontre = $ChDivision;

       // On recupere les rencontres en retard
        $rencontresEnRetard = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreEnRetard($id, $ChParametres->getNbJourRetard());

        // On recupere les rencontres à encoder
        $rencontresAEncoder = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreAEncoder($id);

        // On recupere les slots libres
        $slotsLibre = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getSlotsLibres($id);

        // On recupere les rencontres à venir
        $rencontresAVenir = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontreAVenir($id);

        // On recupere les indisponibilites associés au championnat
        $ChIndisponibilite = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChIndisponibilite')
            ->getChIndisponibilite($id);

        $repPlanning = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $rencontreComplete = $repPlanning->findBy(array('championnat_id' => $id));      


        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChRencontreReject');
        // On recupère les recontres rejetées
        $ChRencontreReject = $repository->findBy(array('championnat_id' => $id));


        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChParametres');
         // On recupère la Corporation
        $ChParametres = $repository->findOneBy(array('championnat_id' => $Championnat->getId()));

        if (!$ChParametres) {
            throw $this->createNotFoundException("Les paramètres pour le championnat ".$Championnat->getId()." n'ont pas été trouvés !");
        }
       
        $formHandler = new ChParametresHandler($this->createForm(new ChParametresType((array('idChampionnat' => $id))), $ChParametres,array('disabled' => true)), $request);



        /*
        if ($formHandler->verification()) {

            $form = $formHandler->getForm()->getData();

            //$form->setUser($this->getUser());

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($form);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat'));
        } 

        */       

        return $this->render('swsBackBundle:Championnat:manager.html.twig',array(
            'Championnat' => $Championnat,
            'ChParametres' => $ChParametres,
            'chsalle' => $ChSalle,
            'listSallesCh' => $listSallesCh,
            'listCorporationsCh' => $listCorporationsCh,
            'chcorporation' => $ChCorporation,
            'ChDivision' => $ChDivision,
           // 'listrencontre' => $listRencontre,
            'form' => $formHandler->getForm()->createView(),
            'ChRencontreReject' => $ChRencontreReject,
            'rencontresEnRetard' => $rencontresEnRetard,
            'rencontresAEncoder' => $rencontresAEncoder,
            'slotsLibre' => $slotsLibre,
            'rencontresAVenir' => $rencontresAVenir,
            'rencontreComplete' => $rencontreComplete,
            'ChIndisponibilite' => $ChIndisponibilite
            )
        );

    }

    /**
     * Supprime une entité Championnat
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour ce championnat :
     *  1) Vérifier si présence de Entity chSallle
     *  2) Vérifier si présence de Entity chCorporation
     *  3) ...
     *
     * @param int $id Valeur de l'identification du Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listChampionnat
     */
    public function deleteAction($id, Request $request)
    {
        $session = new Session();
        $session->set('onglet', 'tdb'); // Onglet tableau de bord

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($id);

        if (!$Championnat) {
            throw $this->createNotFoundException("La Championnat avec l'identifiant ".$id." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($Championnat);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchampionnat'));

    }

    /**
     * Crée une entité Championnat
     *
     * Lorsque l'on crée un championnat, on doit :
     *
     *  1) Créer le championnat (Entity Championnat)
     *  2) Créer les paramètres par défaut du championnat (Entity ChParametre)
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listChampionnat
     * @return form vers la template swsBackBundle:Championnat:create.html.twig
     */
    public function createAction(Request $request)
    {

        $formHandler = new ChampionnatHandler($this->createForm(new ChampionnatType(), new Championnat()), $request);

        if ($formHandler->verification()) {

            // On recupère les données du formulaire
            $Championnat = $formHandler->getForm()->getData();

            // On lie le user courant au championnat
            $Championnat->setUser($this->getUser());

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($Championnat);

            $ChParametres = new ChParametres();

            // On lie le championnat aux paramètres
            $ChParametres->setChampionnatId($Championnat);
            $ChParametres->setConfirmed('-');

            $em-> persist($ChParametres);

            // Génération des classement par défaut pour le championnat

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(1);
            $ChClassement->setValeur(115);
            $ChClassement->setClassement('A International');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(2);
            $ChClassement->setValeur(110);
            $ChClassement->setClassement('A');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(3);
            $ChClassement->setValeur(105);
            $ChClassement->setClassement('B-15,4');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(4);
            $ChClassement->setValeur(100);
            $ChClassement->setClassement('B-15,2');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(5);
            $ChClassement->setValeur(95);
            $ChClassement->setClassement('B-15,1');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(6);
            $ChClassement->setValeur(90);
            $ChClassement->setClassement('B-15');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(7);
            $ChClassement->setValeur(85);
            $ChClassement->setClassement('B-2/6');
            $em-> persist($ChClassement);


            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(8);
            $ChClassement->setValeur(80);
            $ChClassement->setClassement('B-4/6');
            $em-> persist($ChClassement);


            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(9);
            $ChClassement->setValeur(75);
            $ChClassement->setClassement('B0');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(10);
            $ChClassement->setValeur(70);
            $ChClassement->setClassement('B+2/6');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(11);
            $ChClassement->setValeur(65);
            $ChClassement->setClassement('B+4/6');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(12);
            $ChClassement->setValeur(60);
            $ChClassement->setClassement('C15');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(13);
            $ChClassement->setValeur(55);
            $ChClassement->setClassement('C15,1');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(14);
            $ChClassement->setValeur(50);
            $ChClassement->setClassement('C15,2');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(15);
            $ChClassement->setValeur(45);
            $ChClassement->setClassement('C15,3');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(16);
            $ChClassement->setValeur(40);
            $ChClassement->setClassement('C15,4');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(17);
            $ChClassement->setValeur(35);
            $ChClassement->setClassement('C15,5');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(18);
            $ChClassement->setValeur(30);
            $ChClassement->setClassement('C30');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(19);
            $ChClassement->setValeur(25);
            $ChClassement->setClassement('C30,1');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(20);
            $ChClassement->setValeur(20);
            $ChClassement->setClassement('C30,2');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(21);
            $ChClassement->setValeur(15);
            $ChClassement->setClassement('C30,3');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(22);
            $ChClassement->setValeur(10);
            $ChClassement->setClassement('C30,4');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(23);
            $ChClassement->setValeur(5);
            $ChClassement->setClassement('C30,5');
            $em-> persist($ChClassement);

            $ChClassement = new ChClassement();
            $ChClassement->setChampionnatId($Championnat);
            $ChClassement->setNumeroOrdre(24);
            $ChClassement->setValeur(3);
            $ChClassement->setClassement('C30.6');
            $em-> persist($ChClassement);


            // On commit les données en DB
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchampionnat'));
        }

        return $this->render('swsBackBundle:Championnat:create.html.twig',array(
                'form' => $formHandler->getForm()->createView()
            )
        );
    }

    /**
     * Affiche la liste des Championnat
     *
     * Si le paramètre $critereParam est = à 'no#critere", la fonction renvoie les joueurs sans appliquer de filtre.
     * Si le paramètre $critereParam est != de 'no#critere", la fonction renvoie les Championnats filtrées sur le nom et
     * le nom succinct selon le critère fourni.
     *
     * Le paramètre "critereParam" de la route sws_back_listjoueur est initialisé par défaut à 'no#critere' via la
     * configuration de la route.
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchampionnat
     * @return form vers la template swsBackBundle:Championnat:modify.html.twig
     */
    public function listAction($page, $critereParam, Request $request)
    {
        if (!is_numeric($page)) {
            throw $this->createNotFoundException("La Championnat avec l'identifiant ".$page." n'existe pas.");
        }

        $form = $this->get('form.factory')->createBuilder('form')
            ->add('critere','text')
            ->getForm()
        ;

        $form->handleRequest($request);

        if ($form->isValid() or $critereParam <> 'no#critere') {

            $nbPerPage = 15;
            $postForm = $request->request->get('form');

            if ($critereParam <> 'no#critere'){

                $critere = $critereParam;
            }
            else{

                $critere = $postForm['critere'];
            }


            $listChampionnats = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:Championnat')
                ->getChampionnatsByCritere($critere, $page, $nbPerPage)
            ;

            $nbPages = ceil(count($listChampionnats)/$nbPerPage);

            return $this->render('swsBackBundle:Championnat:list.html.twig', array(
                'listChampionnats' => $listChampionnats,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => $critere
            ));
        }
        else {

            $nbPerPage = 15;

            $listChampionnats = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:Championnat')
                ->getChampionnats($page, $nbPerPage)
            ;

            $nbPages = ceil(count($listChampionnats)/$nbPerPage);

            return $this->render('swsBackBundle:Championnat:list.html.twig', array(
                'listChampionnats' => $listChampionnats,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => 'no#critere'
            ));
        }
    }

    /**
     * Lie le championnat au tableau de bord
     *
     * Initialise setTdb du championnat à (1) et initialise le setTdb à (0) des autres championnats.
     *
     * @param int $id Valeur de l'identification du championnat
     *
     * @return route sws_back_listjoueur
     */
    public function tdbAction($id)
    {
        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($id);

        if (!$championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$id." n'existe pas.");
        }

        $championnat->setSettdb(1);
        $championnat->setUser($this->getUser());

        $em = $this->getDoctrine()->getEntityManager();
        $em-> persist($championnat);
        $em->flush();

        $result = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Championnat')
            ->removeTdbChampionnats($id)
        ;

        $em->getConnection()->commit();

        $session = new Session();
        $session->set('onglet', 'bord');

        $bag = $this->get('session')->getFlashBag();
        $bag->set('message', 'Le championnat a bien été relié au tableau de bord.');

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $id)));
    }

    public function getProgressAction(Request $request)
    {
        
        $percent = $this->get('session')->get('progress');
        $progressText = $this->get('session')->get('progressText');
        
        $progressArray[0] = $progressText;
        $progressArray[1] = $percent;
              
        if ($percent == 100){
		$session = new Session();
		$session->remove('progress');    
		$session->remove('progressText');
		session_write_close ();    
        }
           
        //return new Response($percent);
        return new JsonResponse($progressArray);        

            

/*
        if ($request->isXMLHttpRequest())
        {
        
        $percent = $this->get('session')->get('progress');
        
        if ($percent == 100){
		$session = new Session();
		$session->remove('progress');        
        }

            return new Response($percent);
        }
        else{
            throw new \Exception('Accès non autorisé !');
        }
            */
    }


    public function recapitulatifPdfAction($idChampionnat)
    {

        $now = new \Datetime();
        $now_format = $now->format('d-m-y H:i');
        $now_format2 = $now->format('d_m_y ');

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat " . $planningCh->getChampionnatId . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $chSalles = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $chLocations = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $chCorporations = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $chDivisions = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $chIndisponibilites = $repository->findBy(array('championnat_id' => $idChampionnat));

        $fileName = 'RIL_recapitulatif.pdf';
        $sanitizer = $this->get('sanitizeFileName');
        $sanitizer->processSanitizeFileNamle($fileName);
        $fileName = $sanitizer->getFileName();

        $html = $this->renderView('swsBackBundle:Championnat:pdf.recapitulatif.html.twig', array(
            'Championnat'  => $Championnat,
            'chSalles' => $chSalles,
            'chLocations' => $chLocations,
            'chCorporations' => $chCorporations,
            'chDivisions' => $chDivisions,
            'chIndisponibilites' => $chIndisponibilites
        ));

        return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml(
                $html,
                array('orientation'=>'Portrait',
                    'margin-left' => 0,
                    'margin-right' => 0,
                    'margin-top' => 5,
                    //'header-font-size' => 10,
                    'header-spacing' => '0',
                    //'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),

                    'footer-font-size' => 8,
                    //'footer-line' => false,
                    'footer-left' => $now_format,
                    //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                    //'footer-right' => 'Page n°[page] / [toPage]',
                    'footer-spacing' => '6',
                    'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                    //'footer-html' => $url_footer
                    //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                )),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename='.$fileName
            )
        );
    }

    public function fardeChampionnatPdfAction($idChampionnat)
    {

        $now = new \Datetime();
        $now_format = $now->format('d-m-y H:i');
        $now_format2 = $now->format('d_m_y ');

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat " . $planningCh->getChampionnatId . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $chSalles = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $chLocations = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $chCorporations = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $chDivisions = $repository->findBy(array('championnat_id' => $idChampionnat));

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $chIndisponibilites = $repository->findBy(array('championnat_id' => $idChampionnat));

        $ind_corpo = 0;
        $ind_equipe2 = 0;
        foreach ($chCorporations as $ChCorporationId) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($ChCorporationId);
            $ChCorporations[] = $ChCorporation;

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$ChCorporationId." n'existe pas.");
            }

            $equipesCorpo[$ind_corpo] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChEquipe')
                ->getChEquipe($ChCorporationId);

            if (empty($equipesCorpo[0])) {

                $bag = $this->get('session')->getFlashBag();
                $bag->set('warning', 'Aucune équipe trouvée pour cette corporation  ('.$ChCorporation->getCorporationId()->getNom().') !');
                return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
            }

            $ind_equipe = 0;

            foreach ($equipesCorpo[$ind_corpo] as $equipe) {

                $rencontres[$ind_corpo][$ind_equipe] = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getrencontresEquipe($equipe->getId());
                    
                $contactsCorpo[$ind_equipe2][] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getContacts($ChCorporationId);
                $contactsCorpo[$ind_equipe2][] = $equipe->getChDivisionId();
            
                $ind_equipe = $ind_equipe + 1;
                $ind_equipe2++;
            }

            if ($ChCorporationId->getCorporationId()->getGenre() == 'F'){

                // On recupere la liste de force de la corpoCH Dame
                $listesForce[] = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChJoueur')
                    ->getListeForceCorpoDames($ChCorporationId);
            }
            else{

                // On recupere la liste de force de la corpoCH Mixte et Homme
                $listesForce[] = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChJoueur')
                    ->getListeForceCorpo($ChCorporationId);
            }
                
            $ind_corpo = $ind_corpo + 1;
        }
        
        foreach ($chSalles as $ChSalleId) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
            $ChSalle = $repository->find($ChSalleId);
            $ChSalles[] = $ChSalle;

            $locations[] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChLocation')
                ->getLocationsSalle($ChSalleId);
        }

        foreach ($chDivisions as $division) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
            $rencontresDiv = $repository->findby(
                array('chdivision_id' => $division),
                array('dateRencontre' => 'ASC')
                );
            $rencontresDivisions[] = $rencontresDiv;
        }


        $fileName = 'RIL_farde_championnat.pdf';
        $sanitizer = $this->get('sanitizeFileName');
        $sanitizer->processSanitizeFileNamle($fileName);
        $fileName = $sanitizer->getFileName();

        $html = $this->renderView('swsBackBundle:Championnat:pdf.farde.html.twig', array(
            'Championnat'  => $Championnat,
            'chSalles' => $chSalles,
            'chLocations' => $chLocations,
            'ChCorporations' => $ChCorporations,
            'chDivisions' => $chDivisions,
            'chIndisponibilites' => $chIndisponibilites,
            "rencontres" => $rencontres,
            "equipesCorpo" =>$equipesCorpo,
            "listesForce" =>$listesForce,
            "locations" => $locations,
            "rencontresDivisions" => $rencontresDivisions,
            'contactsCorpo' => $contactsCorpo
        ));

        return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml(
                $html,
                array('orientation'=>'Portrait',
                    'margin-left' => 4,
                    'margin-right' => 4,
                    'margin-top' => 5,
                    //'header-font-size' => 10,
                    'header-spacing' => '0',
                    //'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),

                    'footer-font-size' => 8,
                    //'footer-line' => false,
                    'footer-left' => $now_format,
                    //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                    //'footer-right' => 'Page n°[page] / [toPage]',
                    'footer-spacing' => '6',
                    'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                    //'footer-html' => $url_footer
                    //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                )),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename='.$fileName
            )
        );
    }


}

