<?php

/**
 * Fichier: ChSalleController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chSalle
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChSalle;
use sws\Bundle\BackBundle\Entity\ChLocation;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChSalleType;
use sws\Bundle\BackBundle\Form\Handler\ChSalleHandler;
use Symfony\Component\HttpFoundation\Response;


class ChSalleController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'salle');
    }
    /**
     * Crée une entité Chsalle
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchsalle
     * @return form vers la template swsBackBundle:chsalle:create.html.twig
     */
    public function managerSalleCreateAction($idChampionnat, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        $idSalle = $request->request->get('salle');
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Salle');
        $salle = $repository->find($idSalle);

        $chsalle = new ChSalle();
        $chsalle->setUser($this->getUser());
        $chsalle->setChampionnatId($championnat);
        $chsalle->setsalleId($salle);

        $em = $this->getDoctrine()->getEntityManager();
        $em->persist($chsalle);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
    }

    /**
     * Supprime une entité ChSalle
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette salle :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la salle du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idSalleCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $SalleCh = $repository->find($idSalleCh);

        if (!$SalleCh) {
            throw $this->createNotFoundException("La salle/championnat avec l'identifiant ".$idSalleCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($SalleCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
    }

    /*
     * Recopier les ChSalle d'un championnat par héritage
     *
     * @return route sws_back_manager_championnat
     */
    public function managerInheritSalleAction($id)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($id);
        
        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$id." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($id);

        if (!$ChParametres) {
            throw $this->createNotFoundException("Les paramètres pour le hampionnat avec l'identifiant ".$id." n'existe pas.");
        }   

        // On recupere les ChSalles du championnat parent
        $ChSalles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getChSalle($ChParametres->getChampionnatHeritId());

        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        foreach ($ChSalles as $ChSalle) {

            $chsalle_new = new ChSalle();
            $chsalle_new->setUser($this->getUser());
            $chsalle_new->setChampionnatId($championnat);
            $chsalle_new->setsalleId($ChSalle->getSalleId());

            $em->persist($chsalle_new);
            $em->flush();

            // On recupere les ChLocations de la ChSalle parent
            $ChLocation = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChLocation')
                ->getChLocationsChSalle($ChSalle->getId());

            foreach ($ChLocation as $location ){

                $location_new = new ChLocation();
                $location_new->setNom($location->getNom());
                $location_new->setJour($location->getJour());
                $location_new->setHeureDebut($location->getHeureDebut());
                $location_new->setHeureFin($location->getHeureFin());
                $location_new->setTarifHeure($location->getTarifHeure());
                $location_new->setNumeroRencontre($location->getNumeroRencontre());
                $location_new->setTypeSurfaceId($location->getTypeSurfaceId());
                $location_new->setUser($this->getUser());
                $location_new->setChampionnatId($championnat);
                $location_new->setChsalleId($chsalle_new);

                $em = $this->getDoctrine()->getEntityManager();
                $em->persist($location_new);
                $em->flush();
            }
        }

        $em->getConnection()->commit();

        if ($ChSalles) {
            $bag = $this->get('session')->getFlashBag();
            $bag->set('message', 'L\'importation des salles a été réalisée avec succès.');
        }
        else{
            $bag = $this->get('session')->getFlashBag();
            $bag->set('warning', 'Aucune salle trouvée pour le championnat parent.');
        }

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $id)));
    }    
    
    /**
     * Export des rencontres des divisions
     *
     */
    public function exportAction($idChampionnat, $type, Request $request)
    {

       if ($request->ismethod('post')) {

            if ( !$request->request->get('SalleId')){

                return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

            }
          
            $now = new \Datetime();
            $now_format = $now->format('d-m-y H:i');
            $now_format2 = $now->format('d_m_y ');
            
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            $html = '';
          
            foreach ($request->request->get('SalleId') as $ChSalleId) {

                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
                $ChSalle = $repository->find($ChSalleId);
                $ChSalles[] = $ChSalle;

                if ($request->request->get('listeRencSalleXls')){
                    // On recupere la liste de force de la corpoCH
                    $rencontres[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChPlanning')
                        ->getRencontresSalleArray($ChSalleId);
                }
                else{

                    $rencontres[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChPlanning')
                        ->getRencontresSalle($ChSalleId);
                }
            }

           // Si le bouton Xls est cliqué
           if ($request->request->get('listeRencSalleXls')){

               $x = 0;

               foreach ($rencontres as $salle){

                   $i = 0;
                   foreach ($salle as $rencontre){

                   //dump($rencontre);
                   //die;

                   $listeRencontres[$x][$i]['date'] = $rencontre['dateRencontre']->format('d-m-Y');
                   $listeRencontres[$x][$i]['nomCorpoVisitee'] = $rencontre['chcorporationVisitee_id']['corporation_id']['nom'];
                   $listeRencontres[$x][$i]['numeroEqVisitee'] = $rencontre['chequipeVisitee_id']['numeroEquipe'];
                   $listeRencontres[$x][$i]['nomCorpoVisiteuse'] = $rencontre['chcorporationVisiteuse_id']['corporation_id']['nom'];
                   $listeRencontres[$x][$i]['numeroEqVisiteuse'] = $rencontre['chequipeVisiteuse_id']['numeroEquipe'];
                   $listeRencontres[$x][$i]['salle'] = $rencontre['chsalle_id']['salle_id']['nom'];
                   $listeRencontres[$x][$i]['heureDebut'] = $rencontre['chsalle_id']['chlocations'][0]['heureDebut']->format('H:i');
                   $listeRencontres[$x][$i]['division'] = $rencontre['chdivision_id']['nom'] . ' ' . $rencontre['chdivision_id']['numero'] . ' ' . $rencontre['chdivision_id']['suffixe'] ;
                   
                   
                       $i = $i + 1;
                   }

                   $x = $x + 1;
               }
               
               // ask the service for a Excel5
               $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();


               $phpExcelObject->getProperties()->setCreator($this->getUser()->getNom().' '.$this->getUser()->getPrenom())
                   ->setTitle("Liste des rencontres");

               $y = 0;
               foreach ($listeRencontres as $listeRencontres2){

                   if ($y <> 0 ){
                       $phpExcelObject->createSheet($y);
                   }
                   $phpExcelObject->setActiveSheetIndex($y);
                   $phpExcelObject->getActiveSheet()
                       ->fromArray(
                           $listeRencontres2,  // The data to set
                           NULL,        // Array values with this value will not be set
                           'A1'         // Top left coordinate of the worksheet range where
                       //    we want to set these values (default is A1)
                       );
                   $phpExcelObject->getActiveSheet()->setTitle($listeRencontres2[$y]['salle']);
                   // Set active sheet index to the first sheet, so Excel opens this as the first sheet

                   $y = $y + 1;
               }

               $phpExcelObject->setActiveSheetIndex(0);

               // create the writer
               $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
               // create the response
               $response = $this->get('phpexcel')->createStreamedResponse($writer);
               // adding headers
               $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');

               $fileName = 'RIL_rencontres_salle_'.$Championnat->getNom().'_'.$now_format2.'.xls';
               $sanitizer = $this->get('sanitizeFileName');
               $sanitizer->processSanitizeFileNamle($fileName);
               $fileName = $sanitizer->getFileName();

               $response->headers->set('Content-Disposition', 'attachment;filename='.$fileName);
               $response->headers->set('Pragma', 'public');
               $response->headers->set('Cache-Control', 'maxage=1');

               return $response;

           }

           // Si le bouton Pdf est cliqué
           if ($request->request->get('listeRencSallePdf')){

                $fileName = 'RIL_rencontres_salles.pdf';
                $sanitizer = $this->get('sanitizeFileName');
                $sanitizer->processSanitizeFileNamle($fileName);
                $fileName = $sanitizer->getFileName();

               $html = $this->renderView('swsBackBundle:ChRencontre:pdf.rencontres.salle.html.twig', array(
                    'rencontres' => $rencontres,
                    'ChSalles' => $ChSalles
               ));

               $url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
                       ->get('templating.helper.assets')
                       ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);

                return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml(
                        $html,
                        array('orientation'=>'Portrait',
                            'margin-left' => 4,
                            'margin-right' => 4,
                            'margin-top' => 5,
                            //'header-font-size' => 10,
                            'header-spacing' => '0',
                            /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                            'footer-font-size' => 8,
                            //'footer-line' => false,
                            'footer-left' => $now_format,
                            //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                            'footer-right' => 'P. [page]/[toPage]',
                            'footer-spacing' => '6',
                            'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                            //'footer-html' => $url_footer
                            //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                        )),
                    200,
                    array(
                        'Content-Type'          => 'application/pdf',
                        'Content-Disposition'   => 'attachment; filename='.$fileName
                    )
                );                    
            }

            // arrivé ici !!!

            // Si le bouton listeForceHtml est cliqué
            if ($request->request->get('listeRencSalleHtml')){

                return $this->render('swsBackBundle:ChRencontre:rencontres.salles.complete.html.twig', array(
                    'rencontres' => $rencontres,
                    'ChSalles' => $ChSalles
                ));
            }
        }
    }        

}

