<?php

/**
 * Fichier: ChPlanningController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chPlanning
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple;
use sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble;
use sws\Bundle\BackBundle\Entity\ChPlanning;
use sws\Bundle\BackBundle\Entity\Corporation;
use sws\Bundle\BackBundle\Entity\ChRencontreReject;
use sws\Bundle\BackBundle\Entity\ChSimples;
use sws\Bundle\BackBundle\Entity\ChDoubles;
use sws\Bundle\BackBundle\Entity\ChIndisponibilite;
use sws\Bundle\BackBundle\Entity\ChContrainteSalle;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChPlanningType;
use sws\Bundle\BackBundle\Form\Type\ChPlanningJourType;
use sws\Bundle\BackBundle\Form\Type\ChPlanningSlotType;
use sws\Bundle\BackBundle\Form\Type\ChSimplesType;
use sws\Bundle\BackBundle\Form\Type\ChDoubleType;
use sws\Bundle\BackBundle\Form\Type\ChRencontreRejectSlotType;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningHandler;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningJourHandler;
use sws\Bundle\BackBundle\Form\Handler\ChSimplesHandler;
use sws\Bundle\BackBundle\Form\Handler\ChDoubleHandler;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningSlotHandler;
use sws\Bundle\BackBundle\Form\Handler\ChRencontreRejectSlotHandler;
use Symfony\Component\HttpFoundation\Response;

use Symfony\Bundle\FrameworkBundle\Console\Application;
use sws\Bundle\BackBundle\Command\GeneratPlanningCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\NullOutput;


use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;

class ChPlanningController extends Controller
{
    public function planningCreateCommandAction($idChampionnat)
    {
    
     $commandline = "php console app:generate-planning ".$idChampionnat;
     $process = new Process($commandline);
     $dossier = $this->get('kernel')->getRootDir() . DIRECTORY_SEPARATOR;
     $process->setWorkingDirectory($dossier);
     
     $process->start();   // https://github.com/symfony/symfony/issues/20513
     $process->wait(); 
          
     return new Response ("OK");
    
    }
        
    /**
     * Crée le planning du championnat
     *
     * 1. Vérification si planning déjà créé
     * 2. Charger l'entité du championnat
     * 3. Charger les entités des divisions
     * 4. Charger les entités des locations
     * 5. Définir les slots (horaire) du championnat, en fonction de la date de début/fin du championnat et des
     *    locations encodées
     * 6. Charger les entités des équipes par division avec leurs contraintes éventuelles
     * 
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchplanning
     * @return form vers la template swsBackBundle:chplanning:create.html.twig
     */
    public function planningCreateAction($idChampionnat, Request $request)
    {

        $session = new Session();
        $session->set('progress', 0);
        $session->set('progressText', 'Début du traitement');
        session_write_close ();

        // 1. Vérification si des rencontres existent pour le championnat

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $ChPlanning = $repository->findOneBy(array('championnat_id' => $idChampionnat));

        if ($ChPlanning) {
            // Si au moins une rencontre est trouvée --> erreur
            throw new \Exception('Il existe déjà un planning pour ce championnat !');
        }

        // 2. Chargement du championnat
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // 3. Chargement des divisions du championnat
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivisions = $repository->findby(array('championnat_id' => $idChampionnat));

        if (!$ChDivisions) {
            throw $this->createNotFoundException("Aucune division n'a été trouvée pour le championnat avec l'identifiant: " . $idChampionnat);
        }

        // 4. Chargement des locations du championnat
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $ChLocations = $repository->findby(array('championnat_id' => $idChampionnat));

        if (!$ChLocations) {
            throw $this->createNotFoundException("Aucune location n'a été trouvée pour le championnat avec l'identifiant: " . $idChampionnat);
        }

        // 4.1 Chargement des jours fériés à évincer du planning
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $jourFerie = $repository->findby(array('championnat_id' => $idChampionnat, 'typeCode' => '1' ));

        // 4.2 Chargement des vacances scolaires à évincer du planning si demandé par les équipes
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $vacancesScolaires = $repository->findby(array('championnat_id' => $idChampionnat, 'typeCode' => '2' ));

        // 4.3 Chargement des périodes de tournois des salles à évincer du planning
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainteSalle');
        $dateTournois = $repository->findby(array('championnat_id' => $idChampionnat ));

        $session = new Session();
        $session->set('progress', 5);
        $session->set('progressText', 'Chargement des slots du championnat');
        session_write_close ();
        
        // 5. Chargement des slots du championnat via le service slotsChampionnat

        $slotsChampionnat = $this->get('slotsChampionnat');
        $slotsChampionnat->processSlots($championnat, $ChLocations, $jourFerie, $dateTournois);
        $slots_championnat = $slotsChampionnat->getSlots();

        if (!$slots_championnat) {
            throw $this->createNotFoundException("Aucun slot horaire trouvé pour le championnat");
        }


        foreach ($ChDivisions as $keys => $var) {

            $nomDivision = $var->getNom() . ' ' . $var->getNumero() . ' ' . $var->getSuffixe();
            $chDivisionsId = $var->getId();

            // 6. Chargement des équipes par division

            $Chequipes[$nomDivision] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChEquipe')
                ->getChEquipesForOneDivision($var->getId());
        }

    $nbDivIter = 0;
    $nbEqVisitee = 0;
    $nbEqVisiteuse = 0;
    $nbDivision = count($Chequipes);
    $indice = 0;
	
        foreach ($Chequipes as $key1 => $equipe1) {     // Niveau Division
        
            foreach ($equipe1 as $key2 => $var1) {       // Niveau équipe visitée

                $nbEqVisitee++;

                foreach ($equipe1 as $key3 => $var2) {   // Niveau équipe visiteuse

                    $nbEqVisiteuse++;
                    $nbEquipe = count($equipe1);

                    if ($key2 < $key3) // Une équipe ne se rencontre pas elle-même
                    {

                        // Definir le nombre de contrainte pour l'équipe 1
                        /*
                        $nbContrainteEq1 = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChContrainte')
                            ->getChEquipesNbContraintes($var1->getId());
                        */

                        // Definir le nombre de contrainte pour l'équipe 2
                        /*
                        $nbContrainteEq2 = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChContrainte')
                            ->getChEquipesNbContraintes($var2->getId());
                        */

                        $nbContrainteEq1 = count($var1->getChequipesId());
                        $nbContrainteEq2 = count($var2->getChequipesId());

                        // Combien de tour définit pour la division ?
                        $nbTours = $var1->getChdivisionId()->getNbTours();

                        $tour = 1;
                        

                        do {

                            //$indice = $tour.$nbEqVisiteuse.$nbEqVisitee.$nbDivIter.($nbEqVisiteuse + $nbEquipe);

                            if ($tour % 2 == 0) { // Si n° du tour est pair
                                // Definir les rencontres "allées" des divisions
                                
                                $session = new Session();
			        $session->set('progressText', 'Création des rencontres Aller ('.$key1.')');
			        session_write_close ();

                                $rencontresAller[] = (object)array(

                                    "nomDivision" => $key1,
                                    "championnatId" => $var1->getChampionnatId()->getId(),
                                    "chDivisionsId" => $var1->getChdivisionId(),

                                    "chEquipe1Id" => $var1->getId(),                // 1
                                    "nomEquipe1" => $var1->getNom(),                // 1
                                    "numeroEquipe1" => $var1->getNumeroEquipe(),    // 1
                                    "suffixeEquipe1" => $var1->getSuffixEquipe(),   // 1
                                    "corposEquipe1" => $var1->getChcorporationId(), // 1

                                    "chEquipe2Id" => $var2->getId(),                // 2
                                    "nomEquipe2" => $var2->getNom(),                // 2
                                    "numeroEquipe2" => $var2->getNumeroEquipe(),    // 2
                                    "suffixeEquipe2" => $var2->getSuffixEquipe(),   // 2
                                    "corposEquipe2" => $var2->getChcorporationId(), // 2
                                    "nbContraintes" => $nbContrainteEq1 + $nbContrainteEq2

                                );

                            } else {
                                // Définir les rencontres "retour" des divisions
                                
                                $session = new Session();
			        $session->set('progressText', 'Création des rencontres Retour ('.$key1.')');
			        session_write_close ();                                

                                $rencontresRetour[] = (object)array(

                                    "nomDivision" => $key1,
                                    "championnatId" => $var1->getChampionnatId()->getId(),
                                    "chDivisionsId" => $var1->getChdivisionId(),

                                    "chEquipe1Id" => $var2->getId(),                  // 2
                                    "nomEquipe1" => $var2->getNom(),                  // 2
                                    "numeroEquipe1" => $var2->getNumeroEquipe(),      // 2
                                    "suffixeEquipe1" => $var2->getSuffixEquipe(),     // 2
                                    "corposEquipe1" => $var2->getChcorporationId(),   // 2

                                    "chEquipe2Id" => $var1->getId(),                  // 1
                                    "nomEquipe2" => $var1->getNom(),                  // 1
                                    "numeroEquipe2" => $var1->getNumeroEquipe(),      // 1
                                    "suffixeEquipe2" => $var1->getSuffixEquipe(),     // 1
                                    "corposEquipe2" => $var1->getChcorporationId(),   // 1
                                    "nbContraintes" => $nbContrainteEq1 + $nbContrainteEq2
                                );

                            }

                            $tour++;

                        } while ($tour <= $nbTours);
                    }
                }
            }
        }

        
        $session = new Session();
        $session->set('progress', 30);
        $session->set('progressText', 'Sauvegarde du planning vierge');
        session_write_close ();

        if (!isset($rencontresAller)) {
            throw $this->createNotFoundException("Aucune équipe trouvée pour le championnat");
        }

        // 7. Insertion des slots horaire du championnat

        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        foreach ($slots_championnat as $keys => $date) {

            foreach ($date as $keys0 => $salle) {

                foreach ($salle as $keys1 => $var) {

                    $rencontre = new ChPlanning();
                    $rencontre->setChampionnatId($var->getChampionnatId());
                    $rencontre->setChsalleId($var->getChsalleId());
                    $rencontre->setDateRencontre(date_create_from_format('Y-m-d', $keys));
                    $rencontre->setStatus('-');
                    

                    $em->persist($rencontre);
                    $em->flush();
                }
            }
        }

        $session = new Session();
        $session->set('progress', 40);
        $session->set('progressText', 'Optimisation du planning Aller');
        session_write_close ();
        
        
        // Traitement des tableaux de rencontres (optimisation de la génération du championnat)
        
        $eq1 = '';
        $eq2 = '';
        $eq3 = '';
        $eq4 = '';
        $eq5 = '';
        $eq6 = '';
        $eq7 = '';
        $eq8 = '';        
        $nb = 0;
        $increment = 0;
        $sw1 = 0;
        $sw2 = 0;
        $swContrainte = 1;
        
        do{
        
	        foreach ($rencontresAller as $keys1 => $renc) {
	        
	       	
	        	if (
                    (
                        ($renc->chEquipe1Id == $eq1 or $renc->chEquipe1Id == $eq2 or $renc->chEquipe1Id == $eq3 or $renc->chEquipe1Id == $eq4 or $renc->chEquipe1Id == $eq5 or $renc->chEquipe1Id == $eq6 or $renc->chEquipe1Id == $eq7 or $renc->chEquipe1Id == $eq8)
                    or
                        ($renc->chEquipe2Id == $eq2 or $renc->chEquipe2Id == $eq1 or $renc->chEquipe2Id == $eq3 or $renc->chEquipe2Id == $eq4 or $renc->chEquipe2Id == $eq5 or $renc->chEquipe2Id == $eq6 or $renc->chEquipe2Id == $eq7 or $renc->chEquipe2Id == $eq8)
                    )
                    and ($nb <= 2)) {
	        	
	        	$nb++;
	        	
	        	}
	        	else{
	        	
	        		if (($swContrainte == 1 and $renc->nbContraintes > 0 ) or  $swContrainte == 0){
	        		

			            $rencontresAllerOpt[] = $renc;
		            	    unset($rencontresAller[$keys1]);

		                    if ($increment % 2 == 0){
                    
                		    	if ($sw1 == 0){
			                    	$eq3 = $renc->chEquipe1Id;
			                        $eq4 = $renc->chEquipe2Id;
			                        $sw1 = 1;                    	
		                    	}
                		    	else{
			                    	$eq7 = $renc->chEquipe1Id;
			                        $eq8 = $renc->chEquipe2Id;
			                        $sw1 = 0;                                     	
		                    	}

                        	   }
		                   else{
                    
	        	            if ($sw2 == 0){
	                    
	                       		 $eq1 = $renc->chEquipe1Id;
	                        	 $eq2 = $renc->chEquipe2Id;
	 	                         $sw2 = 1; 
	 	                    }
		                    else{
		                        $eq5 = $renc->chEquipe1Id;
	        	                $eq6 = $renc->chEquipe2Id;
	                	        $sw2 = 0;                     
	                    	    }

		               }

                	       $nb = 0;
                               $increment++;
                              }
	        	}

	        }
	        
	        $swContrainte = 0;
	  }while(count($rencontresAller) != 0);

        $session = new Session();
        $session->set('progress', 50);
        $session->set('progressText', 'Optimisation du planning Retour');
        session_write_close ();

        $eq1 = '';
        $eq2 = '';
        $eq3 = '';
        $eq4 = '';
        $eq5 = '';
        $eq6 = '';
        $eq7 = '';
        $eq8 = '';         
        $nb = 0;
        $increment = 0;
        $sw1 = 0;
        $sw2 = 0;   
        $swContrainte = 1;    
        
        do{

	        foreach ($rencontresRetour as $keys1 => $renc) {


	        	if (
                    (
                        ($renc->chEquipe1Id == $eq1 or $renc->chEquipe1Id == $eq2 or $renc->chEquipe1Id == $eq3 or $renc->chEquipe1Id == $eq4 or $renc->chEquipe1Id == $eq5 or $renc->chEquipe1Id == $eq6 or $renc->chEquipe1Id == $eq7 or $renc->chEquipe1Id == $eq8)
                    or
                        ($renc->chEquipe2Id == $eq2 or $renc->chEquipe2Id == $eq1 or $renc->chEquipe2Id == $eq3 or $renc->chEquipe2Id == $eq4 or $renc->chEquipe2Id == $eq5 or $renc->chEquipe2Id == $eq6 or $renc->chEquipe2Id == $eq7 or $renc->chEquipe2Id == $eq8)
                    )
                    and ($nb <= 2)) {
	        	
	        	$nb++;
	        	
	        	}
	        	else{
	        	
	        	if (($swContrainte == 1 and $renc->nbContraintes > 0 ) or  $swContrainte == 0){
		            $rencontresRetourOpt[] = $renc;
		            unset($rencontresRetour[$keys1]);

                    if ($increment % 2 == 0){
                    
                    	if ($sw1 == 0){
                    	$eq3 = $renc->chEquipe1Id;
                        $eq4 = $renc->chEquipe2Id;
                        $sw1 = 1;                    	
                    	}
                    	else{
                    	$eq7 = $renc->chEquipe1Id;
                        $eq8 = $renc->chEquipe2Id;
                        $sw1 = 0;                                     	
                    	}

                        

                    }
                    else{
                    
	                    if ($sw2 == 0){
	                    
	                        $eq1 = $renc->chEquipe1Id;
	                        $eq2 = $renc->chEquipe2Id;
	                        $sw2 = 1; 
	                    }
	                    else{
	                        $eq5 = $renc->chEquipe1Id;
	                        $eq6 = $renc->chEquipe2Id;
	                        $sw2 = 0;                     
	                    }

                    }

                    $nb = 0;
                    $increment++;
                    }
	        	}
	        }
	        
	         $swContrainte = 0;
	  }while(count($rencontresRetour) != 0);

        $session = new Session();
        $session->set('progress', 60);
        $session->set('progressText', 'Assignation d\'un slot à chaque rencontre');
        session_write_close ();
        


        // Ordonner aléatoirement le contenu de $rencontresAller et $rencontresRetour (pour ne pas avoir un planning séquentiel des corporations

        //shuffle($rencontresAller);
        //shuffle($rencontresRetour);
        
        //8. Traitement des rencontres
        $nb_reject = 0;
        $nb_Updated = 0;

        $traitement = 1;
        do {

            if ($traitement == 1) {
                $rencontreAtraiter = $rencontresAllerOpt;
            } else {
                $rencontreAtraiter = $rencontresRetourOpt;
            }

            foreach ($rencontreAtraiter as $keys1 => $renc) {

                $sw_debut_championnat_eq1 = 0;
                $sw_debut_championnat_eq2 = 0;

                // Definir la date de la dernière rencontre de l'équipe 1
                $dateRencontreEq1 = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getMaxDateRencontreEquipe($renc->chEquipe1Id, $championnat->getId());

                if ($dateRencontreEq1 == null) {

                    $dateRencontreEq1 = date_format($championnat->getDateDebut(), 'Y-m-d');
                    $date_temp = strtotime($dateRencontreEq1);
                    $date_temp = strtotime('-5 days', $date_temp); // On retire 5 jours pour s'aligner sur la bonne date de début dans les process suivants
                    $dateRencontreEq1 = date('Y-m-d', $date_temp);
                    $sw_debut_championnat_eq1 = 1;
                }

                // Definir la date de la dernière rencontre de l'équipe 2
                $dateRencontreEq2 = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getMaxDateRencontreEquipe($renc->chEquipe2Id, $championnat->getId());

                if ($dateRencontreEq2 == null) {

                    $dateRencontreEq2 = date_format($championnat->getDateDebut(), 'Y-m-d');
                    $date_temp = strtotime($dateRencontreEq2);
                    $date_temp = strtotime('-5 days', $date_temp); // On retire 5 jours pour s'aligner sur la bonne date de début dans les process suivants
                    $dateRencontreEq2 = date('Y-m-d', $date_temp);
                    $sw_debut_championnat_eq2 = 1;
                }

                if ($dateRencontreEq1 >= $dateRencontreEq2) {
                    $dateReference = $dateRencontreEq1;
                } else {
                    $dateReference = $dateRencontreEq2;
                }

                //if ($dateReference <> date_format($championnat->getDateDebut(),'Y-m-d')){
                if ($sw_debut_championnat_eq1 == 1 and $sw_debut_championnat_eq2 == 1) {

                    $date_borne_inferieure = $dateReference;
                } else {
                    $date_temp = strtotime($dateReference);
                    $date_temp = strtotime('+10 days', $date_temp); // On ajoute x jours
                    $date_borne_inferieure = date('Y-m-d', $date_temp);
                    //$date_borne_inferieure = $date_temp;                    
                }

                // Recherche des contraintes de type "jours" des équipes de la rencontre
                $ContrainteJourEquipesExclusion = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesJour('E', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                $ContrainteJourEquipesInclusion = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesJour('I', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                // Recherche des contraintes de type "salles" des équipes de la rencontre
                $ContrainteSalleEquipesExclusion = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesSalle('E', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                $ContrainteSalleEquipesInclusion = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesSalle('I', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                // Recherche des contraintes de type "Periode" des équipes de la rencontre
                $ContraintePeriodeEquipesExclusion = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesPeriode('E', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());


                $itemJour = array();

                if ($ContrainteJourEquipesExclusion) { // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteJourEquipesExclusion as $keys => $jour) {

                        $itemJour[] = '"' . $jour->getJour() . '"';
                    }

                    $contraintesJourExclusionCh = join(', ', $itemJour);  // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesJourExclusionCh = 0; // Si aucune contrainte trouvée
                }

                $itemJour = array();

                if ($ContrainteJourEquipesInclusion) { // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteJourEquipesInclusion as $keys => $jour) {

                        $itemJour[] = '"' . $jour->getJour() . '"';
                    }

                    $contraintesJourInclusionCh = join(', ', $itemJour);  // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesJourInclusionCh = 0; // Si aucune contrainte trouvée
                }

                $itemSalle = array();

                if ($ContrainteSalleEquipesExclusion) {  // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteSalleEquipesExclusion as $keys => $salle) {

                        $itemSalle[] = '"' . $salle->getChsalleId()->getId() . '"';
                    }

                    $contraintesSalleExclusionCh = join(', ', $itemSalle); // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesSalleExclusionCh = 0;  // Si aucune contrainte trouvée
                }

                $itemSalle = array();

                if ($ContrainteSalleEquipesInclusion) {  // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteSalleEquipesInclusion as $keys => $salle) {

                        $itemSalle[] = '"' . $salle->getChsalleId()->getId() . '"';
                    }

                    $contraintesSalleInclusionCh = join(', ', $itemSalle); // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesSalleInclusionCh = 0;  // Si aucune contrainte trouvée
                }

                // Recherche un slot pour la rencontre
                $slotRencontre = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getSlotRencontre(
                        $championnat->getId(),
                        //$date_borne_inferieure,
                        $dateReference,
                        $contraintesSalleExclusionCh,
                        $contraintesSalleInclusionCh,
                        $contraintesJourExclusionCh,
                        $contraintesJourInclusionCh
                    );

                if (!empty($slotRencontre)) {

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
                    $ChPlanningCh = $repository->find($slotRencontre[0]->getId());

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisitee = $repository->find($renc->chEquipe1Id);
                    $ChPlanningCh->setChequipeVisiteeId($ChEquipeChVisitee);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisitee = $repository->find($renc->corposEquipe1);
                    $ChPlanningCh->setChcorporationVisiteeId($ChCorporationVisitee);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisiteuse = $repository->find($renc->chEquipe2Id);
                    $ChPlanningCh->setChequipeVisiteuseId($ChEquipeChVisiteuse);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisiteuse = $repository->find($renc->corposEquipe2);
                    $ChPlanningCh->setChcorporationVisiteuseId($ChCorporationVisiteuse);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
                    $ChDivisionCh = $repository->find($renc->chDivisionsId);
                    $ChPlanningCh->setChdivisionId($ChDivisionCh);

                    $ChPlanningCh->setStatus('N');

                    $em->persist($ChPlanningCh);
                    $em->flush();

                    $nb_Updated++;
                } else {

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
                    $Championnat = $repository->find($championnat->getId());

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisitee = $repository->find($renc->chEquipe1Id);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisitee = $repository->find($renc->corposEquipe1);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisiteuse = $repository->find($renc->chEquipe2Id);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisiteuse = $repository->find($renc->corposEquipe2);

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
                    $ChDivisionCh = $repository->find($renc->chDivisionsId);

                    $rencontreRejected = new ChRencontreReject();
                    $rencontreRejected->setChampionnatId($Championnat);
                    $rencontreRejected->setNbContrainte($renc->nbContraintes);
                    $rencontreRejected->setChequipeVisiteeId($ChEquipeChVisitee);
                    $rencontreRejected->setChcorporationVisiteeId($ChCorporationVisitee);
                    $rencontreRejected->setChequipeVisiteuseId($ChEquipeChVisiteuse);
                    $rencontreRejected->setChcorporationVisiteuseId($ChCorporationVisiteuse);
                    $rencontreRejected->setChdivisionId($ChDivisionCh);

                    $em->persist($rencontreRejected);
                    $em->flush();

                    $nb_reject++;
                }
            }


            $traitement++;

        } while ($traitement < 3);

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChParametres');
        $chparametres = $repository->findOneBy(array('championnat_id' => $idChampionnat));
        $chparametres->setConfirmed('N');
        $em->persist($chparametres);
        $em->flush();

        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'bord');
        $session->set('progress', 80);
        $session->set('progressText', 'Finalisation du traitement');
        session_write_close ();

        $em->getConnection()->commit();
        
        $session = new Session();
        $session->set('progress', 100);
        $session->set('progressText', 'Terminé !');
        session_write_close ();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
    }

    /**
     * Supprime une entité Salle
     *
     * @param int $id Valeur de l'identification de la salle
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listsalle
     */
    public function deleteAction($idChampionnat)
    {
        // Paramètrage des onglets
        $session = new Session();
        $session->set('onglet', 'bord');
        $session->set('progress', 0);
        $session->set('progressText', 'Initialisation');
        session_write_close ();

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $chplanning = $repository->findOneBy(array('championnat_id' => $idChampionnat));

        if (!$chplanning) {
            throw $this->createNotFoundException("Aucun planning trouvé pour le championnat avec l'identifiant: ".$idChampionnat);
        }


        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();
        
        $session = new Session();
        $session->set('progress', 25);
        $session->set('progressText', 'Suppression du planning');
        session_write_close ();


        // On procède à la suppression du planning et des rencontres rejetées pour le championnat
        $planningDelete = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->deleteChPlanning($idChampionnat);

        $em->flush();
        
        $session = new Session();
        $session->set('progress', 50);
        $session->set('progressText', 'Suppression des rencontres rejetées');
        session_write_close ();
 
        $rencontreRejectedDelete = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChRencontreReject')
            ->deleteChRencontreReject($idChampionnat);
        $em->flush();
        
        $session = new Session();
        $session->set('progress', 75);
        $session->set('progressText', 'Réinitialisation des paramètres du championnat');
        session_write_close ();

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChParametres');
        $chparametres = $repository->findOneBy(array('championnat_id' => $idChampionnat));
        $chparametres->setConfirmed('-');
        $em-> persist($chparametres);
        $em->flush();

        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'bord');

        $em->getConnection()->commit();
        
        $session = new Session();
        $session->set('progress', 100);
        $session->set('progressText', 'Suppression terminée');
        session_write_close ();        

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array(
            'id' => $idChampionnat)));

    }

    public function confirmAction($idChampionnat)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChParametres');
        $parametres = $repository->findOneBy(array('championnat_id' => $idChampionnat));

        if (!$parametres) {
            throw $this->createNotFoundException("Les paramètres pour le championnat ".$idChampionnat." n'ont pas été trouvé !");
        }

        $em = $this->getDoctrine()->getEntityManager();

        $parametres->setConfirmed('O');

        $em->persist($parametres);
        $em->flush();

        // Paramètrage des onglets
        $session = new Session();
        $session->set('onglet', 'bord');

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
    }

    public function listRencontresAction($idChampionnat, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status)
    {
        setlocale(LC_TIME, "fr_FR");
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat ".$idChampionnat." n'a pas été trouvé !");
        }

        if ($idDivisionCh <> '*'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
            $ChDivision = $repository->find($idDivisionCh);

            if (!$ChDivision) {
                throw $this->createNotFoundException("La division ".$idDivisionCh." n'a pas été trouvée !");
            }
        }
        else{ $ChDivision = null; }

        if ($idSalleCh <> '*'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
            $ChSalle = $repository->find($idSalleCh);

            if (!$ChSalle) {
                throw $this->createNotFoundException("La SalleCh ".$idSalleCh." n'a pas été trouvée !");
            }
        }
        else{ $ChSalle = null; }       

        if ($idCorporationCh <> '*'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorporationCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La CorporationCh ".$idCorporationCh." n'a pas été trouvée !");
            }
        }
        else{ $ChCorporation = null; }      

        if ($idCorporationCh <> '*'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorporationCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La CorporationCh ".$idCorporationCh." n'a pas été trouvée !");
            }
        }
        else{ $ChCorporation = null; }     

        if ($idEquipeCh <> '*'){
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe = $repository->find($idEquipeCh);

            if (!$ChEquipe) {
                throw $this->createNotFoundException("L'équipeCh ".$idEquipeCh." n'a pas été trouvée !");
            }
        }
        else{ $ChEquipe = null; }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);


        $listRencontre = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontres($idChampionnat, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status);

        
        if ($Status <> '\'-\''){

            //Rappel Status = '-' --> slot libre

            return $this->render('swsBackBundle:ChRencontre:list.rencontre.html.twig',array(
                'Championnat' => $Championnat,
                'listrencontre' => $listRencontre,
                'ChDivision' => $ChDivision,
                'ChSalle' => $ChSalle,
                'ChCorporation' => $ChCorporation,
                'ChEquipe' => $ChEquipe,
                'ChParametres' => $ChParametres,
                'Status' => $Status
            ));

           /* return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml($html),
                200,
                array(
                    'Content-Type'          => 'application/pdf',
                    'Content-Disposition'   => 'attachment; filename="file.pdf"'
                )
            );
           */

        }
        else{

            return $this->render('swsBackBundle:ChRencontre:slot.libre.html.twig',array(
                'Championnat' => $Championnat,
                'listrencontre' => $listRencontre,
                'ChSalle' => $ChSalle
        ));
        }

    }

    public function resultatRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat ".$idChampionnat." n'a pas été trouvé !");
        }
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $planningCh = $repository->find($idPlanningCh);

        if (!$planningCh) {
                throw $this->createNotFoundException("La rencontre ".$planningCh." n'a pas été trouvée !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $divisionCh = $repository->find($planningCh->getChdivisionId());

        if (!$divisionCh) {
            throw $this->createNotFoundException("La divisionCh ".$idDivisionCh." n'a pas été trouvée !");
        }

        $ChJoueursEq1 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteeId(), $divisionCh->getGenre());

        $ChJoueursEq2 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteuseId(), $divisionCh->getGenre());


        if ($request->ismethod('post')) {

            // Début du traitement -------------------------------------------------

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            // Traitement du simple N°1 -------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s1'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur_Eq1Id_s1 ".$request->request->get('joueur_Eq1Id_s1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s1'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s1 ".$request->request->get('joueur_Eq2Id_s1')." n'a pas été trouvé !");
            }

            $simple1 = new ChSimples();

            $simple1->setChampionnatId($Championnat);
            $simple1->setChplanningId($planningCh);
            
            $simple1->setJoueurEq1Id($joueur1);
            $simple1->setJoueurEq2Id($joueur2);
            
            $simple1->setChdivisionId($planningCh->getChdivisionId());
            $simple1->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple1->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple1->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple1->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple1->setNumeroSimple(1);

            $simple1->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s1'));
            $simple1->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s1'));
            $simple1->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s1'));
            $simple1->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s1'));
            $simple1->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s1'));
            $simple1->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s1'));
            $simple1->setPointsEquipe1($request->request->get('points_Eq1_s1'));
            $simple1->setPointsEquipe2($request->request->get('points_Eq2_s1'));

            $simple1->setUser($this->getUser());

            $em-> persist($simple1);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°1

            $CalculPtsJoueur = $this->get('calculPoints');

            if ($divisionCh->getGenre() == 'X'){

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilMixteId()->getnumeroOrdre(),$joueur2->getChClassementRilMixteId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s1'), $request->request->get('jeuxSet2_Eq1_s1'), $request->request->get('jeuxSet3_Eq1_s1'), $request->request->get('jeuxSet1_Eq2_s1'), $request->request->get('jeuxSet2_Eq2_s1'), $request->request->get('jeuxSet3_Eq2_s1'));
            }
            else{

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s1'), $request->request->get('jeuxSet2_Eq1_s1'), $request->request->get('jeuxSet3_Eq1_s1'), $request->request->get('jeuxSet1_Eq2_s1'), $request->request->get('jeuxSet2_Eq2_s1'), $request->request->get('jeuxSet3_Eq2_s1'));
            }


            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°1

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Traitement du simple N°2 -------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s2'));


            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s2 ".$request->request->get('joueur_Eq1Id_s2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s2'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s2 ".$request->request->get('joueur_Eq2Id_s2')." n'a pas été trouvée !");
            }            

            $simple2 = new ChSimples();

            $simple2->setChampionnatId($Championnat);
            $simple2->setChplanningId($planningCh);
            
            $simple2->setJoueurEq1Id($joueur1);
            $simple2->setJoueurEq2Id($joueur2);
            
            $simple2->setChdivisionId($planningCh->getChdivisionId());
            $simple2->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple2->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple2->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple2->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple2->setNumeroSimple(2);

            $simple2->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s2'));
            $simple2->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s2'));
            $simple2->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s2'));
            $simple2->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s2'));
            $simple2->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s2'));
            $simple2->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s2'));
            $simple2->setPointsEquipe1($request->request->get('points_Eq1_s2'));
            $simple2->setPointsEquipe2($request->request->get('points_Eq2_s2'));

            $simple2->setUser($this->getUser());

            $em-> persist($simple2);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°2

            $CalculPtsJoueur = $this->get('calculPoints');
            if ($divisionCh->getGenre() == 'X'){

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilMixteId()->getnumeroOrdre(),$joueur2->getChClassementRiLMixteId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s2'), $request->request->get('jeuxSet2_Eq1_s2'), $request->request->get('jeuxSet3_Eq1_s2'), $request->request->get('jeuxSet1_Eq2_s2'), $request->request->get('jeuxSet2_Eq2_s2'), $request->request->get('jeuxSet3_Eq2_s2'));
            }
            else{

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s2'), $request->request->get('jeuxSet2_Eq1_s2'), $request->request->get('jeuxSet3_Eq1_s2'), $request->request->get('jeuxSet1_Eq2_s2'), $request->request->get('jeuxSet2_Eq2_s2'), $request->request->get('jeuxSet3_Eq2_s2'));
            }


            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°2

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Traitement du simple N°3 -------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s3'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s3 ".$request->request->get('joueur_Eq1Id_s3')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s3'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s3 ".$request->request->get('joueur_Eq2Id_s3')." n'a pas été trouvée !");
            }            

            $simple3 = new ChSimples();

            $simple3->setChampionnatId($Championnat);
            $simple3->setChplanningId($planningCh);
            
            $simple3->setJoueurEq1Id($joueur1);
            $simple3->setJoueurEq2Id($joueur2);
            
            $simple3->setChdivisionId($planningCh->getChdivisionId());
            $simple3->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple3->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple3->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple3->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple3->setNumeroSimple(3);

            $simple3->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s3'));
            $simple3->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s3'));
            $simple3->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s3'));
            $simple3->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s3'));
            $simple3->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s3'));
            $simple3->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s3'));
            $simple3->setPointsEquipe1($request->request->get('points_Eq1_s3'));
            $simple3->setPointsEquipe2($request->request->get('points_Eq2_s3'));

            $simple3->setUser($this->getUser());

            $em-> persist($simple3);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°3

            $CalculPtsJoueur = $this->get('calculPoints');

            if ($divisionCh->getGenre() == 'X'){

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilMixteId()->getnumeroOrdre(),$joueur2->getChClassementRilMixteId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s3'), $request->request->get('jeuxSet2_Eq1_s3'), $request->request->get('jeuxSet3_Eq1_s3'), $request->request->get('jeuxSet1_Eq2_s3'), $request->request->get('jeuxSet2_Eq2_s3'), $request->request->get('jeuxSet3_Eq2_s3'));
            }
            else{

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s3'), $request->request->get('jeuxSet2_Eq1_s3'), $request->request->get('jeuxSet3_Eq1_s3'), $request->request->get('jeuxSet1_Eq2_s3'), $request->request->get('jeuxSet2_Eq2_s3'), $request->request->get('jeuxSet3_Eq2_s3'));
            }


            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°3

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Traitement du simple N°4 -------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s4'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s4 ".$request->request->get('joueur_Eq1Id_s4')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s4'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s4 ".$request->request->get('joueur_Eq2Id_s4')." n'a pas été trouvé !");
            }            

            $simple4 = new ChSimples();

            $simple4->setChampionnatId($Championnat);
            $simple4->setChplanningId($planningCh);
            
            $simple4->setJoueurEq1Id($joueur1);
            $simple4->setJoueurEq2Id($joueur2);
            
            $simple4->setChdivisionId($planningCh->getChdivisionId());
            $simple4->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple4->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple4->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple4->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple4->setNumeroSimple(4);

            $simple4->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s4'));
            $simple4->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s4'));
            $simple4->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s4'));
            $simple4->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s4'));
            $simple4->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s4'));
            $simple4->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s4'));
            $simple4->setPointsEquipe1($request->request->get('points_Eq1_s4'));
            $simple4->setPointsEquipe2($request->request->get('points_Eq2_s4'));

            $simple4->setUser($this->getUser());

            $em-> persist($simple4);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°4

            $CalculPtsJoueur = $this->get('calculPoints');

            if ($divisionCh->getGenre() == 'X'){

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilMixteId()->getnumeroOrdre(),$joueur2->getChClassementRilMixteId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s4'), $request->request->get('jeuxSet2_Eq1_s4'), $request->request->get('jeuxSet3_Eq1_s4'), $request->request->get('jeuxSet1_Eq2_s4'), $request->request->get('jeuxSet2_Eq2_s4'), $request->request->get('jeuxSet3_Eq2_s4'));
            }
            else{

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s4'), $request->request->get('jeuxSet2_Eq1_s4'), $request->request->get('jeuxSet3_Eq1_s4'), $request->request->get('jeuxSet1_Eq2_s4'), $request->request->get('jeuxSet2_Eq2_s4'), $request->request->get('jeuxSet3_Eq2_s4'));
            }


            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°4

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Traitement du double N°1 -------------------------------------
            
            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq1 = $repository1->find($request->request->get('joueur1_Eq1Id_d1'));

            if (!$joueur1Eq1) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq1Id_d1 ".$request->request->get('joueur1_Eq1Id_d1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq1 = $repository2->find($request->request->get('joueur2_Eq1Id_d1'));

            if (!$joueur2Eq1) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq1Id_d1 ".$request->request->get('joueur2_Eq1Id_d1')." n'a pas été trouvé !");
            }      

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq2 = $repository1->find($request->request->get('joueur1_Eq2Id_d1'));

            if (!$joueur1Eq2) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq2Id_d1 ".$request->request->get('joueur1_Eq2Id_d1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq2 = $repository2->find($request->request->get('joueur2_Eq2Id_d1'));

            if (!$joueur2Eq2) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq2Id_d1 ".$request->request->get('joueur2_Eq2Id_d1')." n'a pas été trouvé !");
            }  

            $double1 = new ChDoubles();

            $double1->setChampionnatId($Championnat);
            $double1->setChplanningId($planningCh);
            
            $double1->setJoueurs1Eq1Id($joueur1Eq1);
            $double1->setJoueurs2Eq1Id($joueur2Eq1);            
            $double1->setJoueurs1Eq2Id($joueur1Eq2);
            $double1->setJoueurs2Eq2Id($joueur2Eq2);            

            
            $double1->setChdivisionId($planningCh->getChdivisionId());
            $double1->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $double1->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $double1->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $double1->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $double1->setNumeroDouble(1);

            $double1->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_d1'));
            $double1->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_d1'));
            $double1->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_d1'));
            $double1->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_d1'));
            $double1->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_d1'));
            $double1->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_d1'));
            $double1->setPointsEquipe1($request->request->get('points_Eq1_d1'));
            $double1->setPointsEquipe2($request->request->get('points_Eq2_d1'));

            $double1->setUser($this->getUser());

            $em-> persist($double1);
            $em->flush();

            // Calcul des points du joueur 1 equipe 1 pour le double N°1

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('D', null, null, $request->request->get('jeuxSet1_Eq1_d1'), $request->request->get('jeuxSet2_Eq1_d1'), $request->request->get('jeuxSet3_Eq1_d1'), $request->request->get('jeuxSet1_Eq2_d1'), $request->request->get('jeuxSet2_Eq2_d1'), $request->request->get('jeuxSet3_Eq2_d1'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq1);
            $JoueurPointsDouble->setJoueurId($joueur1Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 1 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq1);
            $JoueurPointsDouble->setJoueurId($joueur2Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 1 equipe 2 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq2);
            $JoueurPointsDouble->setJoueurId($joueur1Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 2 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq2);
            $JoueurPointsDouble->setJoueurId($joueur2Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();


            // Traitement du double N°2 -------------------------------------
            
            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq1 = $repository1->find($request->request->get('joueur1_Eq1Id_d2'));

            if (!$joueur1Eq1) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq1Id_d2 ".$request->request->get('joueur1_Eq1Id_d2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq1 = $repository2->find($request->request->get('joueur2_Eq1Id_d2'));

            if (!$joueur2Eq1) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq1Id_d2 ".$request->request->get('joueur2_Eq1Id_d2')." n'a pas été trouvé !");
            }      

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq2 = $repository1->find($request->request->get('joueur1_Eq2Id_d2'));

            if (!$joueur1Eq2) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq2Id_d2 ".$request->request->get('joueur1_Eq2Id_d2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq2 = $repository2->find($request->request->get('joueur2_Eq2Id_d2'));

            if (!$joueur2Eq2) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq2Id_d2 ".$request->request->get('joueur2_Eq2Id_d2')." n'a pas été trouvé !");
            }  

            $double2 = new ChDoubles();

            $double2->setChampionnatId($Championnat);
            $double2->setChplanningId($planningCh);
            
            $double2->setJoueurs1Eq1Id($joueur1Eq1);
            $double2->setJoueurs2Eq1Id($joueur2Eq1);            
            $double2->setJoueurs1Eq2Id($joueur1Eq2);
            $double2->setJoueurs2Eq2Id($joueur2Eq2);            

            
            $double2->setChdivisionId($planningCh->getChdivisionId());
            $double2->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $double2->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $double2->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $double2->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $double2->setNumeroDouble(2);

            $double2->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_d2'));
            $double2->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_d2'));
            $double2->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_d2'));
            $double2->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_d2'));
            $double2->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_d2'));
            $double2->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_d2'));
            $double2->setPointsEquipe1($request->request->get('points_Eq1_d2'));
            $double2->setPointsEquipe2($request->request->get('points_Eq2_d2'));

            $double2->setUser($this->getUser());

            $em-> persist($double2);
            $em->flush();

            // Calcul des points du joueur 1 equipe 1 pour le double N°2

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('D', null, null, $request->request->get('jeuxSet1_Eq1_d2'), $request->request->get('jeuxSet2_Eq1_d2'), $request->request->get('jeuxSet3_Eq1_d2'), $request->request->get('jeuxSet1_Eq2_d2'), $request->request->get('jeuxSet2_Eq2_d2'), $request->request->get('jeuxSet3_Eq2_d2'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq1);
            $JoueurPointsDouble->setJoueurId($joueur1Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 1 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq1);
            $JoueurPointsDouble->setJoueurId($joueur2Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 1 equipe 2 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq2);
            $JoueurPointsDouble->setJoueurId($joueur1Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 2 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq2);
            $JoueurPointsDouble->setJoueurId($joueur2Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Traitement de la rencontre -------------------------------------

            $planningCh -> setStatus('J');

            $ptsEquipeVisitee = $request->request->get('points_Eq1_s1') +  $request->request->get('points_Eq1_s2') + $request->request->get('points_Eq1_s3') + $request->request->get('points_Eq1_s4');
            $ptsEquipeVisitee = $ptsEquipeVisitee + $request->request->get('points_Eq1_d1') +  $request->request->get('points_Eq1_d2');
            $ptsEquipeVisiteuse = $request->request->get('points_Eq2_s1') +  $request->request->get('points_Eq2_s2') + $request->request->get('points_Eq2_s3') + $request->request->get('points_Eq2_s4');
            $ptsEquipeVisiteuse = $ptsEquipeVisiteuse + $request->request->get('points_Eq2_d1') +  $request->request->get('points_Eq2_d2');

            $planningCh -> setptsEquipeVisitee($ptsEquipeVisitee);
            $planningCh -> setptsEquipeVisiteuse($ptsEquipeVisiteuse);

            if ($ptsEquipeVisitee == $ptsEquipeVisiteuse){
                $statusEqVisitee = 'N';
                $statusEqVisiteuse = 'N';
            }
            if ($ptsEquipeVisitee > $ptsEquipeVisiteuse){
                $statusEqVisitee = 'G';
                $statusEqVisiteuse = 'P';
            }
            if ($ptsEquipeVisitee < $ptsEquipeVisiteuse){
                $statusEqVisitee = 'P';
                $statusEqVisiteuse = 'G';
            }

            $planningCh -> setStatusEqVisitee($statusEqVisitee);
            $planningCh -> setStatusEqVisiteuse($statusEqVisiteuse);
            $planningCh->setUser($this->getUser());

            $em-> persist($planningCh);
            $em->flush();

            if ($ptsEquipeVisitee == $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 1;
                $ptsEquipeVisiteuse = 1;
            }

            if ($ptsEquipeVisitee > $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 2;
                $ptsEquipeVisiteuse = 0;
            }

            if ($ptsEquipeVisitee < $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 0;
                $ptsEquipeVisiteuse = 2;
            }

            // Traitement de l'équipe visitée  -------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe1 = $repository1->find($planningCh->getChequipeVisiteeId());

            if (!$ChEquipe1) {
                throw $this->createNotFoundException("L'équipe ChEquipe1 ".$planningCh->getChequipeVisiteeId()." n'a pas été trouvé !");
            }            

            $ChEquipe1 -> setCalculPtsEquipe($ChEquipe1->getCalculPtsEquipe() + $ptsEquipeVisitee);
            $em-> persist($ChEquipe1);
            $em->flush();

            // Traitement de l'équipe visiteuse  -------------------------------------

            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe2 = $repository2->find($planningCh->getChequipeVisiteuseId());

            if (!$ChEquipe2) {
                throw $this->createNotFoundException("L'équipe ChEquipe2 ".$planningCh->getChequipeVisiteuseId()." n'a pas été trouvé !");
            }            

            $ChEquipe2 -> setCalculPtsEquipe($ChEquipe2->getCalculPtsEquipe() + $ptsEquipeVisiteuse);
            $em-> persist($ChEquipe2);
            $em->flush();

            // Fin du traitement -------------------------------------------------

            $em->getConnection()->commit();


            return $this->redirect($this->generateUrl('sws_back_listrencontre',array(
                'idChampionnat'=> $idChampionnat,
                'Championnat' => $Championnat,
                'idDivisionCh' => $idDivisionCh,
                'idSalleCh' => $idSalleCh,
                'idCorporationCh' => $idCorporationCh,
                'idEquipeCh' =>  $idEquipeCh,
                'Status' => $Status    
            )));
        }


        return $this->render('swsBackBundle:ChRencontre:resultat.rencontre.html.twig',array(
            'ChJoueursEq1' => $ChJoueursEq1,
            'ChJoueursEq2' => $ChJoueursEq2,
            'Championnat' => $Championnat,
            'planningCh' => $planningCh,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status      
        ));
    }

    public function deleteResultatRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $planningCh = $repository->find($idPlanningCh);

        if (!$planningCh) {
            throw $this->createNotFoundException("La rencontre " . $planningCh . " n'a pas été trouvée !");
        }

        $ptsEquipeVisitee_old =  $planningCh -> getptsEquipeVisitee();
        $ptsEquipeVisiteuse_old =  $planningCh -> getptsEquipeVisiteuse();

        if ($ptsEquipeVisitee_old == $ptsEquipeVisiteuse_old){
            $ptsEquipeVisitee_old = 1;
            $ptsEquipeVisiteuse_old = 1;
        }

        if ($ptsEquipeVisitee_old > $ptsEquipeVisiteuse_old){
            $ptsEquipeVisitee_old = 2;
            $ptsEquipeVisiteuse_old = 0;
        }

        if ($ptsEquipeVisitee_old < $ptsEquipeVisiteuse_old){
            $ptsEquipeVisitee_old = 2;
            $ptsEquipeVisiteuse_old = 0;
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSimples')
            ->deleteChSimples($idPlanningCh);

        $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueurPtsSimple')
            ->deleteChJoueurPtsSimple($idPlanningCh);

        $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChDoubles')
            ->deleteChDoubles($idPlanningCh);

        $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueurPtsDouble')
            ->deleteChJoueurPtsDouble($idPlanningCh);

        $planningCh -> setStatus('N');
        $planningCh -> setptsEquipeVisitee(null);
        $planningCh -> setptsEquipeVisiteuse(null);
        $planningCh -> setStatusEqVisitee('-');
        $planningCh -> setStatusEqVisiteuse('-');
        $em-> persist($planningCh);
        $em->flush();

         // -------------------------------------------------

        $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe1 = $repository1->find($planningCh->getChequipeVisiteeId());

        if (!$ChEquipe1) {
            throw $this->createNotFoundException("L'équipe ChEquipe1 ".$planningCh->getChequipeVisiteeId()." n'a pas été trouvé !");
        }            

        $ChEquipe1 -> setCalculPtsEquipe($ChEquipe1->getCalculPtsEquipe() - $ptsEquipeVisitee_old);
        $em-> persist($ChEquipe1);
        $em->flush();

        // -------------------------------------------------

        $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe2 = $repository2->find($planningCh->getChequipeVisiteuseId());

        if (!$ChEquipe2) {
            throw $this->createNotFoundException("L'équipe ChEquipe2 ".$planningCh->getChequipeVisiteuseId()." n'a pas été trouvé !");
        }            

        $ChEquipe2 -> setCalculPtsEquipe($ChEquipe2->getCalculPtsEquipe() - $ptsEquipeVisiteuse_old);
        $em-> persist($ChEquipe2);
        $em->flush();

        // -------------------------------------------------  

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($planningCh->getChampionnatId());

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat " . $planningCh->getChampionnatId . " n'a pas été trouvé !");
        }


        $em->getConnection()->commit();

        //return $this->redirect($this->generateUrl('sws_back_listrencontre',array('idChampionnat'=> $idChampionnat)));

       return $this->forward('swsBackBundle:ChPlanning:listRencontres', array(
            'idChampionnat'=> $idChampionnat,
            'Championnat' => $Championnat,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status             
        ));

    }

    public function modifyResultatRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat ".$idChampionnat." n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $planningCh = $repository->find($idPlanningCh);

        if (!$planningCh) {
                throw $this->createNotFoundException("La rencontre ".$planningCh." n'a pas été trouvée !");
        }  
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $divisionCh = $repository->find($planningCh->getChdivisionId());

        if (!$divisionCh) {
            throw $this->createNotFoundException("La divisionCh ".$idDivisionCh." n'a pas été trouvée !");
        }
        
        $ChJoueursEq1 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteeId(), $divisionCh->getGenre());

        $ChJoueursEq2 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteuseId(), $divisionCh->getGenre());


        if ($request->ismethod('post')) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueurPtsSimple')
                ->deleteChJoueurPtsSimple($idPlanningCh);

            $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueurPtsDouble')
                ->deleteChJoueurPtsDouble($idPlanningCh);

            // -------------------------------------

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
            $simple1 = $repository->find($request->request->get('id_s1'));

            if (!$simple1) {
                throw $this->createNotFoundException("Le simple n°1 ".$request->request->get('id_s1')." n'a pas été trouvé !");
            }            

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s1'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur_Eq1Id_s1 ".$request->request->get('joueur_Eq1Id_s1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s1'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s1 ".$request->request->get('joueur_Eq2Id_s1')." n'a pas été trouvé !");
            }            
                       
            $simple1->setChampionnatId($Championnat);
            $simple1->setChplanningId($planningCh);
            
            $simple1->setJoueurEq1Id($joueur1);
            $simple1->setJoueurEq2Id($joueur2);
            
            $simple1->setChdivisionId($planningCh->getChdivisionId());
            $simple1->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple1->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple1->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple1->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple1->setNumeroSimple(1);

            $simple1->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s1'));
            $simple1->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s1'));
            $simple1->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s1'));
            $simple1->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s1'));
            $simple1->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s1'));
            $simple1->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s1'));
            $simple1->setPointsEquipe1($request->request->get('points_Eq1_s1'));
            $simple1->setPointsEquipe2($request->request->get('points_Eq2_s1'));

            $simple1->setUser($this->getUser());

            $em-> persist($simple1);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°1

            $CalculPtsJoueur = $this->get('calculPoints');

            if ($divisionCh->getGenre() == 'X'){

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilMixteId()->getnumeroOrdre(),$joueur2->getChClassementRilMixteId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s1'), $request->request->get('jeuxSet2_Eq1_s1'), $request->request->get('jeuxSet3_Eq1_s1'), $request->request->get('jeuxSet1_Eq2_s1'), $request->request->get('jeuxSet2_Eq2_s1'), $request->request->get('jeuxSet3_Eq2_s1'));
            }
            else{

                $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s1'), $request->request->get('jeuxSet2_Eq1_s1'), $request->request->get('jeuxSet3_Eq1_s1'), $request->request->get('jeuxSet1_Eq2_s1'), $request->request->get('jeuxSet2_Eq2_s1'), $request->request->get('jeuxSet3_Eq2_s1'));
            }


            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°1

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // -------------------------------------

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
            $simple2 = $repository->find($request->request->get('id_s2'));

            if (!$simple2) {
                throw $this->createNotFoundException("Le simple n°2 ".$request->request->get('id_s2')." n'a pas été trouvé !");
            }             

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s2'));


            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s2 ".$request->request->get('joueur_Eq1Id_s2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s2'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s2 ".$request->request->get('joueur_Eq2Id_s2')." n'a pas été trouvée !");
            }            

            $simple2->setChampionnatId($Championnat);
            $simple2->setChplanningId($planningCh);
            
            $simple2->setJoueurEq1Id($joueur1);
            $simple2->setJoueurEq2Id($joueur2);
            
            $simple2->setChdivisionId($planningCh->getChdivisionId());
            $simple2->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple2->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple2->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple2->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple2->setNumeroSimple(2);

            $simple2->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s2'));
            $simple2->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s2'));
            $simple2->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s2'));
            $simple2->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s2'));
            $simple2->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s2'));
            $simple2->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s2'));
            $simple2->setPointsEquipe1($request->request->get('points_Eq1_s2'));
            $simple2->setPointsEquipe2($request->request->get('points_Eq2_s2'));

            $simple2->setUser($this->getUser());

            $em-> persist($simple2);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°2

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRIlId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s2'), $request->request->get('jeuxSet2_Eq1_s2'), $request->request->get('jeuxSet3_Eq1_s2'), $request->request->get('jeuxSet1_Eq2_s2'), $request->request->get('jeuxSet2_Eq2_s2'), $request->request->get('jeuxSet3_Eq2_s2'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°2

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // -------------------------------------

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
            $simple3 = $repository->find($request->request->get('id_s3'));

            if (!$simple3) {
                throw $this->createNotFoundException("Le simple n°3 ".$request->request->get('id_s3')." n'a pas été trouvé !");
            }              

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s3'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s3 ".$request->request->get('joueur_Eq1Id_s3')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s3'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s3 ".$request->request->get('joueur_Eq2Id_s3')." n'a pas été trouvée !");
            }            

            $simple3->setChampionnatId($Championnat);
            $simple3->setChplanningId($planningCh);
            
            $simple3->setJoueurEq1Id($joueur1);
            $simple3->setJoueurEq2Id($joueur2);
            
            $simple3->setChdivisionId($planningCh->getChdivisionId());
            $simple3->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple3->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple3->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple3->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple3->setNumeroSimple(3);

            $simple3->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s3'));
            $simple3->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s3'));
            $simple3->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s3'));
            $simple3->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s3'));
            $simple3->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s3'));
            $simple3->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s3'));
            $simple3->setPointsEquipe1($request->request->get('points_Eq1_s3'));
            $simple3->setPointsEquipe2($request->request->get('points_Eq2_s3'));

            $simple3->setUser($this->getUser());

            $em-> persist($simple3);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°3

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s3'), $request->request->get('jeuxSet2_Eq1_s3'), $request->request->get('jeuxSet3_Eq1_s3'), $request->request->get('jeuxSet1_Eq2_s3'), $request->request->get('jeuxSet2_Eq2_s3'), $request->request->get('jeuxSet3_Eq2_s3'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°3

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // -------------------------------------

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
            $simple4 = $repository->find($request->request->get('id_s4'));

            if (!$simple4) {
                throw $this->createNotFoundException("Le simple n° ".$request->request->get('id_s4')." n'a pas été trouvé !");
            } 

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1 = $repository1->find($request->request->get('joueur_Eq1Id_s4'));

            if (!$joueur1) {
                throw $this->createNotFoundException("Le joueur joueur_Eq1Id_s4 ".$request->request->get('joueur_Eq1Id_s4')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2 = $repository2->find($request->request->get('joueur_Eq2Id_s4'));

            if (!$joueur2) {
                throw $this->createNotFoundException("Le joueur joueur_Eq2Id_s4 ".$request->request->get('joueur_Eq2Id_s4')." n'a pas été trouvé !");
            }            

            $simple4->setChampionnatId($Championnat);
            $simple4->setChplanningId($planningCh);
            
            $simple4->setJoueurEq1Id($joueur1);
            $simple4->setJoueurEq2Id($joueur2);
            
            $simple4->setChdivisionId($planningCh->getChdivisionId());
            $simple4->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $simple4->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $simple4->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $simple4->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $simple4->setNumeroSimple(4);

            $simple4->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_s4'));
            $simple4->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_s4'));
            $simple4->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_s4'));
            $simple4->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_s4'));
            $simple4->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_s4'));
            $simple4->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_s4'));
            $simple4->setPointsEquipe1($request->request->get('points_Eq1_s4'));
            $simple4->setPointsEquipe2($request->request->get('points_Eq2_s4'));

            $simple4->setUser($this->getUser());

            $em-> persist($simple4);
            $em->flush();

            // Calcul des points du joueur 1 pour le simple N°4

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('S',$joueur1->getChClassementRilId()->getnumeroOrdre(),$joueur2->getChClassementRilId()->getnumeroOrdre(), $request->request->get('jeuxSet1_Eq1_s4'), $request->request->get('jeuxSet2_Eq1_s4'), $request->request->get('jeuxSet3_Eq1_s4'), $request->request->get('jeuxSet1_Eq2_s4'), $request->request->get('jeuxSet2_Eq2_s4'), $request->request->get('jeuxSet3_Eq2_s4'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur1);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur1);
            $JoueurPointsSimple->setJoueurId($joueur1->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();

            // Calcul des points du joueur 2 pour le simple N°4

            $JoueurPointsSimple = new ChJoueurPtsSimple();

            $JoueurPointsSimple->setPointsJoueur($pointsJoueur2);
            $JoueurPointsSimple->setChplanningId($planningCh);
            $JoueurPointsSimple->setChJoueurId($joueur2);
            $JoueurPointsSimple->setJoueurId($joueur2->getJoueurId());
            $JoueurPointsSimple->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsSimple->setChEquipeId($planningCh->getChequipeVisiteuseId());
            $JoueurPointsSimple->setChcorporationId($planningCh->getChcorporationVisiteuseId());
            $JoueurPointsSimple->setCorporationId($planningCh->getChcorporationVisiteuseId()->getCorporationId());
            $JoueurPointsSimple->setChampionnatId($Championnat);
            $JoueurPointsSimple->setUser($this->getUser());

            $em-> persist($JoueurPointsSimple);
            $em->flush();
            
            // ------------------------------------------------- Double 1

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
            $double1 = $repository->find($request->request->get('id_d1'));

            if (!$double1) {
                throw $this->createNotFoundException("Le double n°1 ".$request->request->get('id_d1')." n'a pas été trouvé !");
            }             
            
            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq1 = $repository1->find($request->request->get('joueur1_Eq1Id_d1'));

            if (!$joueur1Eq1) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq1Id_d1 ".$request->request->get('joueur1_Eq1Id_d1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq1 = $repository2->find($request->request->get('joueur2_Eq1Id_d1'));

            if (!$joueur2Eq1) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq1Id_d1 ".$request->request->get('joueur2_Eq1Id_d1')." n'a pas été trouvé !");
            }      

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq2 = $repository1->find($request->request->get('joueur1_Eq2Id_d1'));

            if (!$joueur1Eq2) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq2Id_d1 ".$request->request->get('joueur1_Eq2Id_d1')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq2 = $repository2->find($request->request->get('joueur2_Eq2Id_d1'));

            if (!$joueur2Eq2) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq2Id_d1 ".$request->request->get('joueur2_Eq2Id_d1')." n'a pas été trouvé !");
            }  

            $double1->setChampionnatId($Championnat);
            $double1->setChplanningId($planningCh);
            
            $double1->setJoueurs1Eq1Id($joueur1Eq1);
            $double1->setJoueurs2Eq1Id($joueur2Eq1);            
            $double1->setJoueurs1Eq2Id($joueur1Eq2);
            $double1->setJoueurs2Eq2Id($joueur2Eq2);            

            
            $double1->setChdivisionId($planningCh->getChdivisionId());
            $double1->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $double1->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $double1->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $double1->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $double1->setNumeroDouble(1);

            $double1->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_d1'));
            $double1->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_d1'));
            $double1->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_d1'));
            $double1->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_d1'));
            $double1->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_d1'));
            $double1->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_d1'));
            $double1->setPointsEquipe1($request->request->get('points_Eq1_d1'));
            $double1->setPointsEquipe2($request->request->get('points_Eq2_d1'));

            $double1->setUser($this->getUser());

            $em-> persist($double1);
            $em->flush();

            // Calcul des points du joueur 1 equipe 1 pour le double N°1

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('D', null, null, $request->request->get('jeuxSet1_Eq1_d1'), $request->request->get('jeuxSet2_Eq1_d1'), $request->request->get('jeuxSet3_Eq1_d1'), $request->request->get('jeuxSet1_Eq2_d1'), $request->request->get('jeuxSet2_Eq2_d1'), $request->request->get('jeuxSet3_Eq2_d1'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq1);
            $JoueurPointsDouble->setJoueurId($joueur1Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 1 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq1);
            $JoueurPointsDouble->setJoueurId($joueur2Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 1 equipe 2 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq2);
            $JoueurPointsDouble->setJoueurId($joueur1Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 2 pour le double N°1

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq2);
            $JoueurPointsDouble->setJoueurId($joueur2Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // ------------------------------------------------- Double 2

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
            $double2 = $repository->find($request->request->get('id_d2'));

            if (!$double2) {
                throw $this->createNotFoundException("Le double n°2 ".$request->request->get('id_d2')." n'a pas été trouvé !");
            }                
            
            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq1 = $repository1->find($request->request->get('joueur1_Eq1Id_d2'));

            if (!$joueur1Eq1) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq1Id_d2 ".$request->request->get('joueur1_Eq1Id_d2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq1 = $repository2->find($request->request->get('joueur2_Eq1Id_d2'));

            if (!$joueur2Eq1) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq1Id_d2 ".$request->request->get('joueur2_Eq1Id_d2')." n'a pas été trouvé !");
            }      

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur1Eq2 = $repository1->find($request->request->get('joueur1_Eq2Id_d2'));

            if (!$joueur1Eq2) {
                throw $this->createNotFoundException("Le joueur joueur1_Eq2Id_d2 ".$request->request->get('joueur1_Eq2Id_d2')." n'a pas été trouvé !");
            }
            
            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $joueur2Eq2 = $repository2->find($request->request->get('joueur2_Eq2Id_d2'));

            if (!$joueur2Eq2) {
                throw $this->createNotFoundException("Le joueur joueur2_Eq2Id_d2 ".$request->request->get('joueur2_Eq2Id_d2')." n'a pas été trouvé !");
            }  

            $double2->setChampionnatId($Championnat);
            $double2->setChplanningId($planningCh);
            
            $double2->setJoueurs1Eq1Id($joueur1Eq1);
            $double2->setJoueurs2Eq1Id($joueur2Eq1);            
            $double2->setJoueurs1Eq2Id($joueur1Eq2);
            $double2->setJoueurs2Eq2Id($joueur2Eq2);            

            
            $double2->setChdivisionId($planningCh->getChdivisionId());
            $double2->setChcorporationEq1Id($planningCh->getChcorporationVisiteeId());
            $double2->setChequipeEq1Id($planningCh->getChequipeVisiteeId());
            $double2->setChcorporationEq2Id($planningCh->getChcorporationVisiteuseId());
            $double2->setChequipeEq2Id($planningCh->getChequipeVisiteuseId());
            $double2->setNumeroDouble(2);

            $double2->setJeuxSet1Eq1($request->request->get('jeuxSet1_Eq1_d2'));
            $double2->setJeuxSet1Eq2($request->request->get('jeuxSet1_Eq2_d2'));
            $double2->setJeuxSet2Eq1($request->request->get('jeuxSet2_Eq1_d2'));
            $double2->setJeuxSet2Eq2($request->request->get('jeuxSet2_Eq2_d2'));
            $double2->setJeuxSet3Eq1($request->request->get('jeuxSet3_Eq1_d2'));
            $double2->setJeuxSet3Eq2($request->request->get('jeuxSet3_Eq2_d2'));
            $double2->setPointsEquipe1($request->request->get('points_Eq1_d2'));
            $double2->setPointsEquipe2($request->request->get('points_Eq2_d2'));

            $double2->setUser($this->getUser());

            $em-> persist($double2);
            $em->flush();

            // Calcul des points du joueur 1 equipe 1 pour le double N°2

            $CalculPtsJoueur = $this->get('calculPoints');
            $CalculPtsJoueur->processPointsJoueur('D', null, null, $request->request->get('jeuxSet1_Eq1_d2'), $request->request->get('jeuxSet2_Eq1_d2'), $request->request->get('jeuxSet3_Eq1_d2'), $request->request->get('jeuxSet1_Eq2_d2'), $request->request->get('jeuxSet2_Eq2_d2'), $request->request->get('jeuxSet3_Eq2_d2'));

            $pointsJoueur1 = $CalculPtsJoueur->getPointsJoueur1();
            $pointsJoueur2 = $CalculPtsJoueur->getPointsJoueur2();

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq1);
            $JoueurPointsDouble->setJoueurId($joueur1Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 1 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur1);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq1);
            $JoueurPointsDouble->setJoueurId($joueur2Eq1->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 1 equipe 2 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur1Eq2);
            $JoueurPointsDouble->setJoueurId($joueur1Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();

            // Calcul des points du joueur 2 equipe 2 pour le double N°2

            $JoueurPointsDouble = new ChJoueurPtsDouble();

            $JoueurPointsDouble->setPointsJoueur($pointsJoueur2);
            $JoueurPointsDouble->setChplanningId($planningCh);
            $JoueurPointsDouble->setChJoueurId($joueur2Eq2);
            $JoueurPointsDouble->setJoueurId($joueur2Eq2->getJoueurId());
            $JoueurPointsDouble->setChdivisionId($planningCh->getChdivisionId());
            $JoueurPointsDouble->setChEquipeId($planningCh->getChequipeVisiteeId());
            $JoueurPointsDouble->setChcorporationId($planningCh->getChcorporationVisiteeId());
            $JoueurPointsDouble->setCorporationId($planningCh->getChcorporationVisiteeId()->getCorporationId());
            $JoueurPointsDouble->setChampionnatId($Championnat);
            $JoueurPointsDouble->setUser($this->getUser());

            $em-> persist($JoueurPointsDouble);
            $em->flush();
            
            // -------------------------------------------------

            $planningCh -> setStatus('J');

            $ptsEquipeVisitee = $request->request->get('points_Eq1_s1') +  $request->request->get('points_Eq1_s2') + $request->request->get('points_Eq1_s3') + $request->request->get('points_Eq1_s4');
            $ptsEquipeVisitee = $ptsEquipeVisitee + $request->request->get('points_Eq1_d1') +  $request->request->get('points_Eq1_d2');
            $ptsEquipeVisiteuse = $request->request->get('points_Eq2_s1') +  $request->request->get('points_Eq2_s2') + $request->request->get('points_Eq2_s3') + $request->request->get('points_Eq2_s4');
            $ptsEquipeVisiteuse = $ptsEquipeVisiteuse + $request->request->get('points_Eq2_d1') +  $request->request->get('points_Eq2_d2');

            $ptsEquipeVisitee_old =  $planningCh -> getptsEquipeVisitee();
            $ptsEquipeVisiteuse_old =  $planningCh -> getptsEquipeVisiteuse();

            $planningCh -> setptsEquipeVisitee($ptsEquipeVisitee);
            $planningCh -> setptsEquipeVisiteuse($ptsEquipeVisiteuse);

            if ($ptsEquipeVisitee_old == $ptsEquipeVisiteuse_old){
                $ptsEquipeVisitee_old = 1;
                $ptsEquipeVisiteuse_old = 1;
            }

            if ($ptsEquipeVisitee_old > $ptsEquipeVisiteuse_old){
                $ptsEquipeVisitee_old = 2;
                $ptsEquipeVisiteuse_old = 0;
            }

            if ($ptsEquipeVisitee_old < $ptsEquipeVisiteuse_old){
                $ptsEquipeVisitee_old = 0;
                $ptsEquipeVisiteuse_old = 2;
            }

            if ($ptsEquipeVisitee == $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 1;
                $statusEqVisitee = 'N';
                $ptsEquipeVisiteuse = 1;
                $statusEqVisiteuse = 'N';
            }

            if ($ptsEquipeVisitee > $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 2;
                $statusEqVisitee = 'G';
                $ptsEquipeVisiteuse = 0;
                $statusEqVisiteuse = 'P';
            }

            if ($ptsEquipeVisitee < $ptsEquipeVisiteuse){
                $ptsEquipeVisitee = 0;
                $statusEqVisitee = 'P';
                $ptsEquipeVisiteuse = 2;
                $statusEqVisiteuse = 'G';
            }

            $planningCh -> setStatusEqVisitee($statusEqVisitee);
            $planningCh -> setStatusEqVisiteuse($statusEqVisiteuse);

            $em-> persist($planningCh);
            $em->flush();

            // -------------------------------------------------

            $repository1 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe1 = $repository1->find($planningCh->getChequipeVisiteeId());

            if (!$ChEquipe1) {
                throw $this->createNotFoundException("L'équipe ChEquipe1 ".$planningCh->getChequipeVisiteeId()." n'a pas été trouvé !");
            }            

            $ChEquipe1 -> setCalculPtsEquipe($ChEquipe1->getCalculPtsEquipe() - $ptsEquipeVisitee_old + $ptsEquipeVisitee);
            $em-> persist($ChEquipe1);
            $em->flush();

            // -------------------------------------------------

            $repository2 = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe2 = $repository2->find($planningCh->getChequipeVisiteuseId());

            if (!$ChEquipe2) {
                throw $this->createNotFoundException("L'équipe ChEquipe2 ".$planningCh->getChequipeVisiteuseId()." n'a pas été trouvé !");
            }            

            $ChEquipe2 -> setCalculPtsEquipe($ChEquipe2->getCalculPtsEquipe() - $ptsEquipeVisiteuse_old + $ptsEquipeVisiteuse);
            $em-> persist($ChEquipe2);
            $em->flush();

            // -------------------------------------------------             

            $em->getConnection()->commit();


            return $this->redirect($this->generateUrl('sws_back_listrencontre',array(
                'idChampionnat'=> $idChampionnat,
                'Championnat' => $Championnat,
                'idDivisionCh' => $idDivisionCh,
                'idSalleCh' => $idSalleCh,
                'idCorporationCh' => $idCorporationCh,
                'idEquipeCh' =>  $idEquipeCh,
                'Status' => $Status                    
            )));
        }


        return $this->render('swsBackBundle:ChRencontre:resultat.rencontre.html.twig',array(
            'ChJoueursEq1' => $ChJoueursEq1,
            'ChJoueursEq2' => $ChJoueursEq2,
            'Championnat' => $Championnat,
            'planningCh' => $planningCh,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status            
        ));
    }   

     public function readResultatRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat " . $planningCh->getChampionnatId . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $planningCh = $repository->find($idPlanningCh);

        if (!$planningCh) {
            throw $this->createNotFoundException("La rencontre " . $idPlanningCh . " n'a pas été trouvée !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS1 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 1));

        if (!$rencontreS1) {
            throw $this->createNotFoundException("Le simple n°1 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        } 

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS2 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 2));

        if (!$rencontreS2) {
            throw $this->createNotFoundException("Le simple n°2 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS3 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 3));

        if (!$rencontreS3) {
            throw $this->createNotFoundException("Le simple n°3 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !"); 
        }   

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS4 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 4));

        if (!$rencontreS4) {
            throw $this->createNotFoundException("Le simple n°4 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }   

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreD1 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroDouble' => 1));

        if (!$rencontreD1) {
            throw $this->createNotFoundException("Le double n°1 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");            
        }
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreD2 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroDouble' => 2));

        if (!$rencontreD2) {
            throw $this->createNotFoundException("Le double n°2 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $divisionCh = $repository->find($planningCh->getChdivisionId());

        if (!$divisionCh) {
            throw $this->createNotFoundException("La divisionCh" . $idDivisionCh . " n'a pas été trouvée !");
        }

        $ChJoueursEq1 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteeId(), $divisionCh->getGenre());

        $ChJoueursEq2 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteuseId(), $divisionCh->getGenre());
        
       return $this->render('swsBackBundle:ChRencontre:modif.resultat.rencontre.html.twig', array(
            'Championnat'  => $Championnat,
            'planningCh' => $planningCh,
            'rencontreS1' => $rencontreS1,
            'rencontreS2' => $rencontreS2,
            'rencontreS3' => $rencontreS3,
            'rencontreS4' => $rencontreS4,
            'rencontreD1' => $rencontreD1,
            'rencontreD2' => $rencontreD2,
            'ChJoueursEq1' => $ChJoueursEq1,
            'ChJoueursEq2' => $ChJoueursEq2,
            'idChampionnat'=> $idChampionnat,
            'Championnat' => $Championnat,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status              
        ));

    }

    public function choisirAutreSlotRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $ChPlanning_old = $repository->find($idPlanningCh);

        if (!$ChPlanning_old) {
            throw $this->createNotFoundException("La rencontre ChPlanning old avec l'identifiant ".$idPlanningCh." n'existe pas.");
        }

        $SlotsLibres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getSlotsLibres($idChampionnat);

        if ($request->ismethod('post')) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
            $ChPlanning_new = $repository->find($request->request->get('dateRencontre'));

            if (!$ChPlanning_new) {
                throw $this->createNotFoundException("La rencontre ChPlanning new avec l'identifiant ".$request->request->get('dateRencontre')." n'existe pas.");
            }

            $ChPlanning_new->setChdivisionId($ChPlanning_old->getChdivisionId());
            $ChPlanning_new->setStatus($ChPlanning_old->getStatus());
            $ChPlanning_new->setChsalleId($ChPlanning_old->getChsalleId());
            $ChPlanning_new->setChequipeVisiteeId($ChPlanning_old->getChequipeVisiteeId());
            $ChPlanning_new->setChequipeVisiteuseId($ChPlanning_old->getChequipeVisiteuseId());
            $ChPlanning_new->setChcorporationVisiteeId($ChPlanning_old->getChcorporationVisiteeId());
            $ChPlanning_new->setChcorporationVisiteuseId($ChPlanning_old->getChcorporationVisiteuseId());
            $ChPlanning_new->setUser($this->getUser());
            $em-> persist($ChPlanning_new);
            $em->flush();

            $ChPlanning_old->setChdivisionId(null);
            $ChPlanning_old->setStatus('-');
            $ChPlanning_old->setChsalleId(null);
            $ChPlanning_old->setChequipeVisiteeId(null);
            $ChPlanning_old->setChequipeVisiteuseId(null);
            $ChPlanning_old->setChcorporationVisiteeId(null);
            $ChPlanning_old->setChcorporationVisiteuseId(null);
            $ChPlanning_old->setUser($this->getUser());
            $em-> persist($ChPlanning_old);
            $em->flush();

            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('sws_back_listrencontre',array(
                'idChampionnat'=> $idChampionnat,
                'Championnat' => $Championnat,
                'idDivisionCh' => $idDivisionCh,
                'idSalleCh' => $idSalleCh,
                'idCorporationCh' => $idCorporationCh,
                'idEquipeCh' =>  $idEquipeCh,
                'Status' => $Status                
            )));
        }

        return $this->render('swsBackBundle:ChRencontre:choix.autre.slot.rencontre.html.twig',array(
            'SlotsLibres' => $SlotsLibres,
            'planningCh' => $ChPlanning_old,
            'Championnat' => $Championnat,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status

        ));
    }

    public function choisirAutreDateRencontreAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $ChPlanning_old = $repository->find($idPlanningCh);

        if (!$ChPlanning_old) {
            throw $this->createNotFoundException("La rencontre ChPlanning old avec l'identifiant ".$idPlanningCh." n'existe pas.");
        }

        $ChSalles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getChSalle($idChampionnat);

        if ($request->ismethod('post')) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $date1 = $request->request->get('dateRencontre');
            $date2 = substr($date1,6,4).'-'.substr($date1,3,2).'-'.substr($date1,0,2);
            $dateRencontre_date            = new \DateTime($date2);

            $ChPlanning_new = new ChPlanning();
            $ChPlanning_new->setDateRencontre($dateRencontre_date);
            $ChPlanning_new->setChampionnatId($Championnat);
            $ChPlanning_new->setChdivisionId($ChPlanning_old->getChdivisionId());
            $ChPlanning_new->setStatus($ChPlanning_old->getStatus());
            $ChPlanning_new->setChsalleId($ChPlanning_old->getChsalleId());
            $ChPlanning_new->setChequipeVisiteeId($ChPlanning_old->getChequipeVisiteeId());
            $ChPlanning_new->setChequipeVisiteuseId($ChPlanning_old->getChequipeVisiteuseId());
            $ChPlanning_new->setChcorporationVisiteeId($ChPlanning_old->getChcorporationVisiteeId());
            $ChPlanning_new->setChcorporationVisiteuseId($ChPlanning_old->getChcorporationVisiteuseId());
            $ChPlanning_new->setUser($this->getUser());

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
            $ChSalle = $repository->find($request->request->get('ChSalle'));

            if (!$ChSalle) {
                throw $this->createNotFoundException("La ChSalle l'identifiant ".$request->request->get('ChSalle')." n'existe pas.");
            }

            $ChPlanning_new->setChsalleId($ChSalle);

            $em-> persist($ChPlanning_new);
            $em->flush();

            $ChPlanning_old->setChdivisionId(null);
            $ChPlanning_old->setStatus('-');
            $ChPlanning_old->setChequipeVisiteeId(null);
            $ChPlanning_old->setChequipeVisiteuseId(null);
            $ChPlanning_old->setChcorporationVisiteeId(null);
            $ChPlanning_old->setChcorporationVisiteuseId(null);
            $ChPlanning_old->setUser($this->getUser());

            $em-> persist($ChPlanning_old);
            $em->flush();

            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('sws_back_listrencontre',array(
                'idChampionnat'=> $idChampionnat,
                'Championnat' => $Championnat,
                'ChSalles' => $ChSalles,
                'idDivisionCh' => $idDivisionCh,
                'idSalleCh' => $idSalleCh,
                'idCorporationCh' => $idCorporationCh,
                'idEquipeCh' =>  $idEquipeCh,
                'Status' => $Status
            )));
        }

        return $this->render('swsBackBundle:ChRencontre:choix.date.horsplanning.html.twig',array(
            'planningCh' => $ChPlanning_old,
            'Championnat' => $Championnat,
            'ChSalles' => $ChSalles,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status
        ));
    }

    public function listRencontresRejectAction($idChampionnat)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat ".$idChampionnat." n'a pas été trouvé !");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);


        $listRencontre = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChRencontreReject')
            ->getChRencontreReject($idChampionnat);

        return $this->render('swsBackBundle:ChRencontre:list.rencontre.rejetee.html.twig',array(
            'Championnat' => $Championnat,
            'listrencontre' => $listRencontre,
            'ChParametres' => $ChParametres
        ));
    }    

    public function rencontreRejectchoisirAutreSlotAction($idChampionnat, $idRencontreReject, Request $request)
    {
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChRencontreReject');
        $ChRencontreReject = $repository->find($idRencontreReject);

        if (!$ChRencontreReject) {
            throw $this->createNotFoundException("La ChRencontreReject avec l'identifiant ".$ChRencontreReject." n'existe pas.");
        }        

        $SlotsLibres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getSlotsLibres($idChampionnat);

        if ($request->ismethod('post')) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
            $ChPlanning_new = $repository->find($request->request->get('dateRencontre'));

            if (!$ChPlanning_new) {
                throw $this->createNotFoundException("La rencontre ChPlanning new avec l'identifiant ".$request->request->get('dateRencontre')." n'existe pas.");
            }

            $ChPlanning_new->setChdivisionId($ChRencontreReject->getChdivisionId());
            $ChPlanning_new->setStatus('N');
            $ChPlanning_new->setChequipeVisiteeId($ChRencontreReject->getChequipeVisiteeId());
            $ChPlanning_new->setChequipeVisiteuseId($ChRencontreReject->getChequipeVisiteuseId());
            $ChPlanning_new->setChcorporationVisiteeId($ChRencontreReject->getChcorporationVisiteeId());
            $ChPlanning_new->setChcorporationVisiteuseId($ChRencontreReject->getChcorporationVisiteuseId());
            $ChPlanning_new->setUser($this->getUser());
            $em-> persist($ChPlanning_new);
            $em->flush();

            $em->remove($ChRencontreReject);
            $em->flush();

            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('sws_back_listrencontrereject',array(
                'idChampionnat' => $idChampionnat
            )));
        }

        return $this->render('swsBackBundle:ChRencontre:rencontre.rejetee.choix.slot.html.twig',array(
            'SlotsLibres' => $SlotsLibres,
            'Championnat' => $Championnat,
            'ChRencontreReject' => $ChRencontreReject
        ));
    }    

    public function rencontreRejectchoisirAutreDateAction($idChampionnat, $idRencontreReject, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChRencontreReject');
        $ChRencontreReject = $repository->find($idRencontreReject);

        if (!$ChRencontreReject) {
            throw $this->createNotFoundException("La ChRencontreReject avec l'identifiant ".$ChRencontreReject." n'existe pas.");
        }         

        $ChSalles = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getChSalle($idChampionnat);

        if ($request->ismethod('post')) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $date1 = $request->request->get('dateRencontre');
            $date2 = substr($date1,6,4).'-'.substr($date1,3,2).'-'.substr($date1,0,2);
            $dateRencontre_date            = new \DateTime($date2);

            $ChPlanning_new = new ChPlanning();
            $ChPlanning_new->setDateRencontre($dateRencontre_date);
            $ChPlanning_new->setChampionnatId($Championnat);
            $ChPlanning_new->setChdivisionId($ChRencontreReject->getChdivisionId());
            $ChPlanning_new->setStatus('N');
            $ChPlanning_new->setChequipeVisiteeId($ChRencontreReject->getChequipeVisiteeId());
            $ChPlanning_new->setChequipeVisiteuseId($ChRencontreReject->getChequipeVisiteuseId());
            $ChPlanning_new->setChcorporationVisiteeId($ChRencontreReject->getChcorporationVisiteeId());
            $ChPlanning_new->setChcorporationVisiteuseId($ChRencontreReject->getChcorporationVisiteuseId());
            $ChPlanning_new->setUser($this->getUser());

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
            $ChSalle = $repository->find($request->request->get('ChSalle'));

            if (!$ChSalle) {
                throw $this->createNotFoundException("La ChSalle l'identifiant ".$request->request->get('ChSalle')." n'existe pas.");
            }

            $ChPlanning_new->setChsalleId($ChSalle);

            $em-> persist($ChPlanning_new);
            $em->flush();

            $em->remove($ChRencontreReject);
            $em->flush();

            $em->getConnection()->commit();

           return $this->redirect($this->generateUrl('sws_back_listrencontrereject',array(
                'idChampionnat' => $idChampionnat
            )));
        }

        return $this->render('swsBackBundle:ChRencontre:rencontre.rejetee.choix.date.html.twig',array(
            'ChSalles' => $ChSalles,
            'Championnat' => $Championnat,
            'ChRencontreReject' => $ChRencontreReject
        ));
    }    

     public function resultatPdfAction($idChampionnat,$idPlanningCh, $idDivisionCh, $idSalleCh, $idCorporationCh, $idEquipeCh, $Status, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat " . $planningCh->getChampionnatId . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChPlanning');
        $planningCh = $repository->find($idPlanningCh);

        if (!$planningCh) {
            throw $this->createNotFoundException("La rencontre " . $idPlanningCh . " n'a pas été trouvée !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS1 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 1));

        if (!$rencontreS1) {
            throw $this->createNotFoundException("Le simple n°1 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        } 

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS2 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 2));

        if (!$rencontreS2) {
            throw $this->createNotFoundException("Le simple n°2 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS3 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 3));

        if (!$rencontreS3) {
            throw $this->createNotFoundException("Le simple n°3 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !"); 
        }   

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSimples');
        $rencontreS4 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroSimple' => 4));

        if (!$rencontreS4) {
            throw $this->createNotFoundException("Le simple n°4 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }   

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreD1 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroDouble' => 1));

        if (!$rencontreD1) {
            throw $this->createNotFoundException("Le double n°1 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");            
        }
        
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDoubles');
        $rencontreD2 = $repository->findOneBy(array('chplanning_id' => $idPlanningCh, 'numeroDouble' => 2));

        if (!$rencontreD2) {
            throw $this->createNotFoundException("Le double n°2 de la rencontre" . $idPlanningCh . " n'a pas été trouvé !");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $divisionCh = $repository->find($planningCh->getChdivisionId());

        if (!$divisionCh) {
            throw $this->createNotFoundException("La divisionCh" . $idDivisionCh . " n'a pas été trouvée !");
        }

        $ChJoueursEq1 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteeId(), $divisionCh->getGenre());

        $ChJoueursEq2 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueur($planningCh->getChcorporationVisiteuseId(), $divisionCh->getGenre());
        

        $fileName = 'RIL_feuille_match.pdf';
        $sanitizer = $this->get('sanitizeFileName');
        $sanitizer->processSanitizeFileNamle($fileName);
        $fileName = $sanitizer->getFileName();

       /*return $this->render('swsBackBundle:ChRencontre:feuille.resultat.rencontre.complete.html.twig', array(
            'Championnat'  => $Championnat,
            'planningCh' => $planningCh,
            'rencontreS1' => $rencontreS1,
            'rencontreS2' => $rencontreS2,
            'rencontreS3' => $rencontreS3,
            'rencontreS4' => $rencontreS4,
            'rencontreD1' => $rencontreD1,
            'rencontreD2' => $rencontreD2,
            'ChJoueursEq1' => $ChJoueursEq1,
            'ChJoueursEq2' => $ChJoueursEq2,
            'idChampionnat'=> $idChampionnat,
            'Championnat' => $Championnat,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status              
        ));

       */
        //$url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
        //        ->get('templating.helper.assets')
        //        ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);

        $html = $this->renderView('swsBackBundle:ChRencontre:pdf.feuille.resultat.rencontre.html.twig', array(
            'Championnat'  => $Championnat,
            'planningCh' => $planningCh,
            'rencontreS1' => $rencontreS1,
            'rencontreS2' => $rencontreS2,
            'rencontreS3' => $rencontreS3,
            'rencontreS4' => $rencontreS4,
            'rencontreD1' => $rencontreD1,
            'rencontreD2' => $rencontreD2,
            'ChJoueursEq1' => $ChJoueursEq1,
            'ChJoueursEq2' => $ChJoueursEq2,
            'idChampionnat'=> $idChampionnat,
            'Championnat' => $Championnat,
            'idDivisionCh' => $idDivisionCh,
            'idSalleCh' => $idSalleCh,
            'idCorporationCh' => $idCorporationCh,
            'idEquipeCh' =>  $idEquipeCh,
            'Status' => $Status,
        ));

        return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml(
                $html,
                array('orientation'=>'Landscape',
                  'margin-left' => 0,
                  'margin-right' => 0,
                  'margin-top' => 0,
                  //'header-font-size' => 10,
                  'header-spacing' => '0',
                  //'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),

                  'footer-font-size' => 8,
                  //'footer-line' => false,
                  //'footer-left' => $now_format,
                  //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                  //'footer-right' => 'Page n°[page] / [toPage]', 
                  'footer-spacing' => '6',
                  'footer-center' => "RILTennis - Affiliée à la ligue Francophone Belge des Sports d'Entreprise et de Loisirs et à l'Association Francophone de Tennis n°4021"
                  //'footer-html' => $url_footer
                  //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
            )),
            200,
            array(
            'Content-Type'          => 'application/pdf',
            'Content-Disposition'   => 'attachment; filename='.$fileName
            )
        );
    }         
}
