<?php

/**
 * Fichier: ChParametresController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité ChParametres
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use sws\Bundle\BackBundle\Form\Type\ChParametresType;
use sws\Bundle\BackBundle\Form\Handler\ChParametresHandler;


class ChParametresController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'parametre');
    }

    /**
     * Modifie une entité ChParametres
     *
     * @param int $id Valeur de l'identification du championnat
     * @param Request $request Contenu de la requête HTTP
     */
    public function modifyAction($idChampionnat, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le joueurCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChParametres');
        $parametres = $repository->findOneBy(array('championnat_id' => $Championnat->getId()));


        if (!$parametres) {
            throw $this->createNotFoundException("Les parametres pour le championnat l'identifiant ".$Championnat->getId()." n'existe pas.");
        }

        $formHandler = new ChParametresHandler($this->createForm(new ChParametresType((array('idChampionnat' => $idChampionnat))), $parametres), $request);

        if ($formHandler->verification()) {

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($formHandler->getForm()->getData());
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat', array(
              'id' => $idChampionnat
             )));
        }

        return $this->render('swsBackBundle:ChParametres:modify.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'Championnat' => $Championnat
        ));
    }
}

