<?php

/**
 * Fichier: ChLocationController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chlocation
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\ChLocation;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use sws\Bundle\BackBundle\Form\Type\ChLocationType;
use sws\Bundle\BackBundle\Form\Handler\ChLocationHandler;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;

class ChLocationController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'salle');
    }

    /**
     * Affiche une entité ChLocation
     *
     * @param int $id Valeur de l'identification de la chlocation
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:chlocation:view.html.twig
     */
    public function viewAction($idChampionnat, $idSalleCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $chlocation = $repository->find($id);

        if (!$chlocation) {
            throw $this->createNotFoundException("La location avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChLocationHandler($this->createForm(new ChLocationType(), $chlocation, array('disabled' => true)), $request);

        return $this->render('swsBackBundle:ChLocation:view.html.twig',array('form' => $formHandler->getForm()->createView()));

    }

    /**
     * Supprime une entité ChLocation
     *
     * @param int $id Valeur de l'identification de la chlocation
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchlocation
     */
    public function deleteAction($idChampionnat, $idSalleCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $chlocation = $repository->find($id);

        if (!$chlocation) {
            throw $this->createNotFoundException("La chlocation avec l'identifiant ".$id." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($chlocation);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchlocation', array('idChampionnat' => $idChampionnat, 'idSalleCh' => $idSalleCh)));

    }

    /**
     * Crée une entité ChLocation
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchlocation
     * @return form vers la template swsBackBundle:chlocation:create.html.twig
     */
    public function createAction($idChampionnat, $idSalleCh, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $chsalle = $repository->find($idSalleCh);

        if (!$chsalle) {
            throw $this->createNotFoundException("La ChSalle avec l'identifiant ".$idSalleCh." n'existe pas.");
        }

        $formHandler = new ChLocationHandler($this->createForm(new ChLocationType(), new ChLocation()), $request);

        if ($formHandler->verification()) {

            $chlocation = $formHandler->getForm()->getData();

            //$joueur->setUser($this->get('security.context')->getToken()->getUser());
            //var_dump($this->get('security.context')->getToken()->getUser()->getemail());

            $chlocation->setUser($this->getUser());
            $chlocation->setChsalleId($chsalle);
            $chlocation->setChampionnatId($championnat);


            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($chlocation);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchlocation', array('idChampionnat' => $idChampionnat, 'idSalleCh' => $idSalleCh)));
        }

        return $this->render('swsBackBundle:ChLocation:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
            )
        );
    }

    /**
     * Modifie une entité ChLocation
     *
     * @param int $id Valeur de l'identification de la chlocation
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchlocation
     * @return form vers la template swsBackBundle:chlocation:modify.html.twig
     */
    public function modifyAction($idChampionnat, $idSalleCh, $id, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $championnat = $repository->find($idChampionnat);

        // On recupere la sallech passée en paramètre
        $chsalle = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getCh1Salle($idSalleCh);

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChLocation');
        $chlocation = $repository->find($id);

        if (!$chlocation) {
            throw $this->createNotFoundException("La chlocation avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChLocationHandler($this->createForm(new ChLocationType(), $chlocation), $request);

        if ($formHandler->verification()) {

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($formHandler->getForm()->getData());
            $chlocation->setChsalleId($chsalle);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchlocation', array('idChampionnat' => $idChampionnat, 'idSalleCh' => $idSalleCh)));
        }

        return $this->render('swsBackBundle:ChLocation:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    /**
     * Affiche la liste des chlocation
     *
     * Si le paramètre $critereParam est = à 'no#critere", la fonction renvoie les joueurs sans appliquer de filtre.
     * Si le paramètre $critereParam est != de 'no#critere", la fonction renvoie les chlocations filtrées sur le nom et
     * le nom succinct selon le critère fourni.
     *
     * Le paramètre "critereParam" de la route sws_back_listjoueur est initialisé par défaut à 'no#critere' via la
     * configuration de la route.
     *
     * @param int $id Valeur de l'identification de la chlocation
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchlocation
     * @return form vers la template swsBackBundle:chlocation:modify.html.twig
     */
    public function listAction($idChampionnat, $idSalleCh, $page, $critereParam, Request $request)
    {
        if (!is_numeric($page)) {
            throw $this->createNotFoundException("La chlocation avec l'identifiant ".$page." n'existe pas.");
        }


        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        if (!$ChParametres) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }            

        // On recupere la sallech passée en paramètre
        $chsalle = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChSalle')
            ->getCh1Salle($idSalleCh);

        if (!$chsalle) {
            throw $this->createNotFoundException("La chSalle avec l'identifiant ".$idSalleCh." n'existe pas.");
        }

        $form = $this->get('form.factory')->createBuilder('form')
            ->add('critere','text')
            ->getForm()
        ;

        $form->handleRequest($request);

        if ($form->isValid() or $critereParam <> 'no#critere') {

            if ($page < 1) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 15;
            $postForm = $request->request->get('form');

            if ($critereParam <> 'no#critere'){

                $critere = $critereParam;
            }
            else{

                $critere = $postForm['critere'];
            }


            $listChLocations = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChLocation')
                ->getChLocationsByCritere($idSalleCh, $critere, $page, $nbPerPage)
            ;

            $nbPages = ceil(count($listChLocations)/$nbPerPage);

            /*if ($page > $nbPages) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }*/

            return $this->render('swsBackBundle:ChLocation:list.html.twig', array(
                'listChLocations' => $listChLocations,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => $critere,
                'Championnat' => $championnat,
                'chsalle' => $chsalle,
                'ChParametres' => $ChParametres
            ));
        }
        else {

            if ($page < 1) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }

            $nbPerPage = 15;

            $listChLocations = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChLocation')
                ->getChLocations($idSalleCh, $page, $nbPerPage)
            ;

            $nbPages = ceil(count($listChLocations)/$nbPerPage);

            /*if ($page > $nbPages) {
                throw $this->createNotFoundException("La page ".$page." n'existe pas.");
            }*/

            return $this->render('swsBackBundle:ChLocation:list.html.twig', array(
                'listChLocations' => $listChLocations,
                'nbPages'     => $nbPages,
                'page'        => $page,
                'form'        => $form->createView(),
                'critereParam' => 'no#critere',
                'Championnat' => $championnat,
                'chsalle' => $chsalle,
                'ChParametres' => $ChParametres
            ));
        }
    }

    /**
     * Export les locations
     *
     * @param int $id Valeur de l'identification de la chlocation
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchlocation
     * @return form vers la template swsBackBundle:chlocation:modify.html.twig
     */

    /* Remplacée par la V2 */
    public function exportAction($idChampionnat, $type, Request $request)
    {

       if ($request->ismethod('post')) {

            if ( !$request->request->get('SalleId')){

                return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

            }
          
            $now = new \Datetime();
            $now_format = $now->format('d-m-y H:i');
            $now_format2 = $now->format('d_m_y ');

            $html = '';
          
            foreach ($request->request->get('SalleId') as $ChSalleId) {

                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
                $ChSalle = $repository->find($ChSalleId);
                $ChSalles[] = $ChSalle;

                /*
                if (!$ChLocation) {
                    throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$ChCorporationId." n'existe pas.");
                }
                */

                if ($request->request->get('locationsXls')){
                    // On recupere la liste de force de la corpoCH
                    $locations[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChLocation')
                        ->getLocationsSalleArray($ChSalleId);
                }
                else{
                    // On recupere la liste de force de la corpoCH
                    $locations[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChLocation')
                        ->getLocationsSalle($ChSalleId);
                }
            }

           // Si le bouton listeForcePdf est cliqué
           if ($request->request->get('locationsXls')){

               // Traitement des dates

               $x = 0;

               foreach ($locations as $salle){

                   $i = 0;
                   foreach ($salle as $terrain){

                       $listesLocations[$x][$i]['nom'] = $terrain['nom'];
                       $listesLocations[$x][$i]['heureDebut'] = $terrain['heureDebut']->format('H:i');
                       $listesLocations[$x][$i]['heureFin'] = $terrain['heureFin']->format('H:i');
                       
                       if ($terrain['jour'] == 1){ $listesLocations[$x][$i]['jour'] = 'Lundi'; }                       
                       if ($terrain['jour'] == 2){ $listesLocations[$x][$i]['jour'] = 'Mardi'; }                       
                       if ($terrain['jour'] == 3){ $listesLocations[$x][$i]['jour'] = 'Mercredi'; }                       
                       if ($terrain['jour'] == 4){ $listesLocations[$x][$i]['jour'] = 'Jeudi'; }                       
                       if ($terrain['jour'] == 5){ $listesLocations[$x][$i]['jour'] = 'Vendredi'; }                       
                       if ($terrain['jour'] == 6){ $listesLocations[$x][$i]['jour'] = 'Samedi'; }                       
                       if ($terrain['jour'] == 7){ $listesLocations[$x][$i]['jour'] = 'Dimanche'; }                       

                       $listesLocations[$x][$i]['tarifHeure'] = $terrain['tarifHeure'];
                       $listesLocations[$x][$i]['numeroRencontre'] = $terrain['numeroRencontre'];

                       //$listesLocations[$x][$i]['typeSurface'] = $terrain['typeSurface_id']['type'];

                       $i = $i + 1;
                   }

                   if ($i == 0){
                       $listesLocations[$x][$x]['salle'] = $ChSalles[$x]->getSalleId()->getNom();
                   }


                   $x = $x + 1;
               }

               // ask the service for a Excel5
               $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();


               $phpExcelObject->getProperties()->setCreator($this->getUser()->getNom().' '.$this->getUser()->getPrenom())
                   ->setTitle("Locations de salle");

               $y = 0;
               foreach ($listesLocations as $listesLocations2){

                   if ($y <> 0 ){
                       $phpExcelObject->createSheet($y);
                   }
                   $phpExcelObject->setActiveSheetIndex($y);
                   $phpExcelObject->getActiveSheet()
                       ->fromArray(
                           $listesLocations2,  // The data to set
                           NULL,        // Array values with this value will not be set
                           'A1'         // Top left coordinate of the worksheet range where
                       //    we want to set these values (default is A1)
                       );

                   $phpExcelObject->getActiveSheet()->setTitle( $ChSalles[$y]->getSalleId()->getNom());
                   // Set active sheet index to the first sheet, so Excel opens this as the first sheet

                   $y = $y + 1;
               }

               $phpExcelObject->setActiveSheetIndex(0);

               // create the writer
               $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
               // create the response
               $response = $this->get('phpexcel')->createStreamedResponse($writer);
               // adding headers
               $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');

               $fileName = 'RIL_locations_salle_'.$now_format2.'.xls';
               $sanitizer = $this->get('sanitizeFileName');
               $sanitizer->processSanitizeFileNamle($fileName);
               $fileName = $sanitizer->getFileName();

               $response->headers->set('Content-Disposition', 'attachment;filename='.$fileName);
               $response->headers->set('Pragma', 'public');
               $response->headers->set('Cache-Control', 'maxage=1');

               return $response;

           }

           // Si le bouton locationPdf est cliqué
           if ($request->request->get('locationsPdf')){

                $fileName = 'RIL_locations_salles.pdf';
                $sanitizer = $this->get('sanitizeFileName');
                $sanitizer->processSanitizeFileNamle($fileName);
                $fileName = $sanitizer->getFileName();

               $html = $this->renderView('swsBackBundle:ChLocation:pdf.locations.html.twig', array(
                   'locations' => $locations,
                   'ChSalles' => $ChSalles
               ));

              /* $url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
                       ->get('templating.helper.assets')
                       ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);*/

                return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml(
                        $html,
                        array('orientation'=>'Portrait',
                            'margin-left' => 0,
                            'margin-right' => 0,
                            //'header-font-size' => 10,
                            //'header-spacing' => '0.5',
                            /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                            'footer-font-size' => 8,
                            /*'footer-line' => false,
                            'footer-left' => $now_format,
                            'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                            'footer-right' => 'Page n°[page] / [toPage]', */
                            'footer-spacing' => '6',
                            'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                            //'footer-html' => $url_footer
                            //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                        )),
                    200,
                    array(
                        'Content-Type'          => 'application/pdf',
                        'Content-Disposition'   => 'attachment; filename='.$fileName
                    )
                );                    
            }

            // arrivé ici !!!

            // Si le bouton listeForceHtml est cliqué
            if ($request->request->get('locationsHtml')){

                return $this->render('swsBackBundle:ChLocation:locations.complete.html.twig', array(
                    'locations' => $locations,
                    'ChSalles' => $ChSalles
                ));
                
                /*return $this->render('swsBackBundle:PrintPackage:package.html.twig', array(
                    'listesForce' => $listesForce,
                    'ChCorporations' => $ChCorporations
                ));*/
            }
        }
    }

    public function exportV2Action($idChampionnat)
    {

        $now = new \Datetime();
        $now_format = $now->format('d-m-y H:i');
        $now_format2 = $now->format('d_m_y ');

        $html = '';

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $ChSalles = $repository->findby(
            array('championnat_id' => $idChampionnat)
        );

        foreach ($ChSalles as $ChSalleId) {

            $locations[] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChLocation')
                ->getLocationsSalle($ChSalleId);
        }


        $fileName = 'RIL_locations_salles.pdf';
        $sanitizer = $this->get('sanitizeFileName');
        $sanitizer->processSanitizeFileNamle($fileName);
        $fileName = $sanitizer->getFileName();

        $html = $this->renderView('swsBackBundle:ChLocation:pdf.locations.html.twig', array(
            'locations' => $locations,
            'ChSalles' => $ChSalles
        ));



        /*
         return $this->render('swsBackBundle:ChLocation:pdf.locations.html.twig', array(
            'locations' => $locations,
            'ChSalles' => $ChSalles
        ));
        */



        return new Response(
            $this->get('knp_snappy.pdf')->getOutputFromHtml(
                $html,
                array('orientation'=>'Portrait',
                    'margin-left' => 4,
                    'margin-right' => 4,
                    'margin-top' => 5,
                    //'header-font-size' => 10,
                    'header-spacing' => '0',
                    /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                    'footer-font-size' => 8,
                    //'footer-line' => false,
                    'footer-left' => $now_format,
                    //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                    'footer-right' => 'P. [page]/[toPage]',
                    'footer-spacing' => '6',
                    'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                    //'footer-html' => $url_footer
                    //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                )),
            200,
            array(
                'Content-Type'          => 'application/pdf',
                'Content-Disposition'   => 'attachment; filename='.$fileName
            )
        );

    }
 }





