<?php

/**
 * Fichier: ChJoueurController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chJoueur
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChJoueur;
use sws\Bundle\BackBundle\Entity\Joueurs;
use sws\Bundle\BackBundle\Entity\Corporation;
use sws\Bundle\BackBundle\Entity\ChParametres;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use sws\Bundle\BackBundle\Form\Type\ChJoueurType;
use sws\Bundle\BackBundle\Form\Handler\ChJoueurHandler;


class ChJoueurController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'corporation');
    }


    /**
     * Affiche une entité Championnat
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:Championnat:view.html.twig
     */
    public function listAction($idChampionnat, $idCorpoCh, Request $request)
    {
       // $session = new Session();
       // $session->set('onglet', 'tdb'); // Onglet tableau de bord

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        $repCorporationCh = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');

        // On recupère la corporationCH
        $ChCorporation = $repCorporationCh->find($idCorpoCh);

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repCorporation = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Corporation');

        // On recupère la Corporation
        $Corporation = $repCorporation->findOneById($ChCorporation->getCorporationId());

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        // On recupere les joueurs associés à la corporationCH
        $ChJoueur = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueurCorpo($idCorpoCh);

        // On recupere les joueurs a ajouter à  la corporationCH (pas encore associées)
        $listJoueurs = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:Joueurs')
            ->getJoueursCh($idCorpoCh);

        return $this->render('swsBackBundle:ChJoueur:list.html.twig',array(
            'Championnat' => $Championnat,
            'ChCorporation' => $ChCorporation,
            'ChJoueurs' => $ChJoueur,
            'listJoueurs' => $listJoueurs,
            'Corporation' => $Corporation,
            'ChParametres' => $ChParametres
            )
        );

    }


    /**
     * Crée une entité Chjoueur
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchjoueur
     * @return form vers la template swsBackBundle:chjoueur:create.html.twig
     */
    public function JoueurCreateAction($idChampionnat, $idCorpoCh, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $ChCorporation = $repository->find($idCorpoCh);

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $idJoueur = $request->request->get('joueur');
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Joueurs');
        $joueur = $repository->find($idJoueur);

        if (!$joueur) {
            throw $this->createNotFoundException("Le joueurCH avec l'identifiant ".$idJoueur." n'existe pas.");
        }
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Redu');
        $redu = $repository->findOneBy(array('AFNUMERO' => $joueur->getNumAft()));

        if (!$redu) {
            $classementRedu = null;
        }
        else{
            $classRedu = $redu->getAFNUMCLASS();

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
            $classementRedu = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $classRedu));

            if (!$classementRedu) {
                throw $this->createNotFoundException("Le classement pour le championnat ".$idChampionnat." et la valeur ".$classRedu);
            }
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        // Calcul du classement RIL du joueur (Héritage + Classement REDU)
        // Si championnatHerit = null --> pas d'héritage à gérer -> Calssement REDU d'office
        // Si championnatHertit <> null --> calcul du bonus/malus acquis ds championnatHerit et comparer avec classement redu
            //Si classementHerit > classement redu -> classementHerit est pris en compte, sinon classement redu

        $chjoueur = new ChJoueur();
        $chjoueur->setTotalPtGagne(0);
        $chjoueur->setTotalPtPerdu(0);
        $chjoueur->setUser($this->getUser());
        $chjoueur->setChampionnatId($championnat);
        $chjoueur->setChcorporationId($ChCorporation);
        $chjoueur->setJoueurId($joueur);
        $chjoueur->setChClassementReduId($classementRedu);

        if ($ChParametres->getChampionnatHeritId() == null){

            // Ici, il n'existe pas de championnat parent -> on se base sur le classement redu uniquement

            $chjoueur->setChClassementRilPrecedentId(null);
            $chjoueur->setChclassementRilCalculId($classementRedu);
            $chjoueur->setChclassementRilId($classementRedu);
            
            // Calcul classement mixte ------------
            
            if ($classementRedu == null){

                $chjoueur->setChclassementRilMixteId(null);
                $chjoueur->setChclassementRilMixteCalculId(null);
            }
            else{

                if ($joueur->getSexe() == 'F'){

                    $ClassemmentMixte = $this->get('calculClassementMixte');

                    $ClassemmentMixte->processClassementMixte($classementRedu->getnumeroOrdre());
                    $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                    $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                    if (!$ClassementMixte_new) {
                        throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                    }                
                    
                    $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                    $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);

                }
                else
                {

                    // Si masculin --> classement mixte = classement RIL normal
                    $chjoueur->setChclassementRilMixteId($classementRedu);
                    $chjoueur->setChclassementRilMixteCalculId($classementRedu);

                }

                // Fin classement mixte ------------

            }
        }
        else{

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
            $ChJoueursParents = $repository->findBy(array('championnat_id' => $ChParametres->getChampionnatHeritId(), 'joueur_id' => $joueur->getId()));

            // Il pourrait y avoir plusieur joueurCH parent si le joueur à jouer dans 2 corpos différentes pendant le championnat (comme les dames -> F et mixte)

            if (empty($ChJoueursParents)) {
                
                // Ici, il existe un championnat parent, mais le joueur n'existe pas pour ce championnat parent

                $chjoueur->setChClassementRilPrecedentId(null);

                $chjoueur->setChclassementRilCalculId($classementRedu);
                $chjoueur->setChclassementRilId($classementRedu);

                // Calcul classement mixte ------------
                if ($joueur->getSexe() == 'F'){
                    $ClassemmentMixte = $this->get('calculClassementMixte');
                    $ClassemmentMixte->processClassementMixte($classementRedu->getnumeroOrdre());
                    $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                    $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                    if (!$ClassementMixte_new) {
                        throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                    }                
                    
                    $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                    $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);
                }
                else{

                    // Si masculin --> classement mixte = classement RIL normal

                    $chjoueur->setChclassementRilMixteId($classementRedu);
                    $chjoueur->setChclassementRilMixteCalculId($classementRedu);

                }

                // Fin classement mixte -----------
            }
            else {

                // Ici, Il existe un championnat parent etau moins un jouer parent existe pour ce championnat parent

                $totalPoints = 0;

                foreach ($ChJoueursParents as $ChJoueurParent){

                    // On recupere le total des points en simple du ChJoueurs

                    $pointsSimple = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChJoueurPtsSimple')
                        ->getPoints($ChJoueurParent->getId());

                    if (!$pointsSimple) {
                        $pointsSimple = 0;
                    }

                    $pointsDouble = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChJoueurPtsDouble')
                        ->getPoints($ChJoueurParent->getId());

                    if (!$pointsDouble) {
                        $pointsDouble = 0;
                    }


                    $totalPoints = $totalPoints + $pointsSimple + $pointsDouble;

                }
                
                // Le $ChJoueurParent utilisé ci-après est le dernier traité par la boucle FOR ci-dessus


                // Calcul du nouveau classement RIL du joueur

                $CalculClassementJoueur = $this->get('calculClassement');
                $CalculClassementJoueur->processClassementJoueur($ChJoueurParent->getChclassementRilId()->getvaleur(), $totalPoints);
                $valeurClassement = $CalculClassementJoueur->getValeurClassement();
                
                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                $ChclassementRil = $repository->findOneBy(array('championnat_id' => $idChampionnat, 'valeur' => $valeurClassement));

                if (!$ChclassementRil) {
                    throw $this->createNotFoundException("Le classementCh avec la valeur ".$valeurClassement." n'existe pas pour le championnat".$idChampionnat);
                }

                if ($classementRedu == null or $ChclassementRil->getnumeroOrdre() < $classementRedu->getnumeroOrdre() ){
                    $chjoueur->setChclassementRilCalculId($ChclassementRil);
                    $chjoueur->setChClassementRilPrecedentId($ChJoueurParent->getChclassementRilId());
                    $chjoueur->setChclassementRilId($ChclassementRil);
                }
                else{
                    
                    $chjoueur->setChclassementRilCalculId($classementRedu);
                    $chjoueur->setChClassementRilPrecedentId($ChJoueurParent->getChclassementRilId());
                    $chjoueur->setChclassementRilId($classementRedu);
                    
                }

                // Calcul classement mixte ------------

                if ($joueur->getSexe() == 'F'){
                    $ClassemmentMixte = $this->get('calculClassementMixte');
                    $ClassemmentMixte->processClassementMixte($ChclassementRil->getnumeroOrdre()); // On se baase sur le classement RIL calculé !!!
                    $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                    $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                    if (!$ClassementMixte_new) {
                        throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                    }                
                    
                    $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                    $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);

                }
                else{
                    
                    // Si masculin --> classement mixte = classement RIL normal
                    
                    if ($classementRedu == null or $ChclassementRil->getnumeroOrdre() < $classementRedu->getnumeroOrdre() ){

                        $chjoueur->setChclassementRilMixteId($ChclassementRil);
                        $chjoueur->setChclassementRilMixteCalculId($ChclassementRil);
                    }
                    else{
                        
                        $chjoueur->setChclassementRilMixteId($classementRedu);
                        $chjoueur->setChclassementRilMixteCalculId($classementRedu);
                    
                    }
                }

                // Fin classement mixte -----------
            }
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->persist($chjoueur);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchjoueur', array(
            'idChampionnat' => $idChampionnat,
            'idCorpoCh' => $idCorpoCh
        )));
    }

    /**
     * Supprime une entité ChJoueur
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette joueur :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la joueur du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idCorpoCh, $idJoueurCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
        $JoueurCh = $repository->find($idJoueurCh);

        if (!$JoueurCh) {
            throw $this->createNotFoundException("La joueurCH avec l'identifiant ".$idJoueurCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($JoueurCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchjoueur', array(
            'idChampionnat' => $idChampionnat,
            'idCorpoCh' => $idCorpoCh
        )));

    }

    /**
     * Modifie une entité ChJoueur
     *
     * @param int $id Valeur de l'identification du joueur
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchjoueur
     * @return form vers la template swsBackBundle:ChJoueur:modify.html.twig
     */
    public function modifyAction($idChampionnat,$idCorpoCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le joueurCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
        $ChJoueur = $repository->find($id);

        if (!$ChJoueur) {
            throw $this->createNotFoundException("Le joueurCH avec l'identifiant ".$id." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Joueurs');
        $Joueur = $repository->find($ChJoueur->getJoueurId());


        if (!$Joueur) {
            throw $this->createNotFoundException("Le Joueur avec l'identifiant ".$ChJoueur->getJoueurId()." n'existe pas.");
        }


        $formHandler = new ChJoueurHandler($this->createForm(new ChJoueurType(array('idChampionnat' => $idChampionnat, 'idChCorporation' => $ChJoueur->getChCorporationId() )), $ChJoueur), $request);

        if ($formHandler->verification()) {

            $em = $this->getDoctrine()->getEntityManager();
            $em->getConnection()->beginTransaction();

            $em-> persist($formHandler->getForm()->getData());
            $em->flush();

            $form = $request->request->get('ChJoueur_form');


            if ($form['ChequipecapitaineId'] <> '') {

                // Si le joueur est capitaine d'une équipe on supprime le capitainat à d'autre joueur pour cette même équipe
                $removeCapitainat = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChJoueur')
                    ->removeCapitainatEquipe($form['ChequipecapitaineId'], $ChJoueur->getChcorporationId()->getId(),$ChJoueur->getId());
            }

            if (array_key_exists('delegue', $form )){
                // Si le joueur est délégué de la corporation on supprime la délégation d'autre joueur pour cette même corporation

                $removeDelegation = $this->getDoctrine()
                    ->getManager()
                    ->getRepository('swsBackBundle:ChJoueur')
                    ->removeDelegation($ChJoueur->getChcorporationId()->getId(),$ChJoueur->getId());
            }

            $em->getConnection()->commit();


            return $this->redirect($this->generateUrl('sws_back_listchjoueur', array(
              'idChampionnat' => $idChampionnat,
              'idCorpoCh' => $idCorpoCh
             )));
        }

        return $this->render('swsBackBundle:ChJoueur:modify.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'ChJoueur' => $ChJoueur,
            'Joueur' => $Joueur
        ));
    }

    public function getJoueurChAction(Request $request)
    {

       $idJoueurCh = $request->request->get('idJoueurCh');

       if ($request->isXMLHttpRequest()) {

            $JoueurCh = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getChJoueurArray($idJoueurCh);

                if (!$JoueurCh) {
                    throw $this->createNotFoundException("Le joueurCH avec l'identifiant ".$idJoueurCh." n'existe pas.");
                }

           return new JsonResponse($JoueurCh);
       }
       else{
            throw new \Exception('Accès non autorisé !');
       }
    }

    /*
       * Recopier les ChJoueur d'une ChCorporation par héritage
       *
       * @return route sws_back_listchjoueur
       */
    public function inheritJoueurAction($idChampionnat, $idCorpoCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $chcorporation = $repository->find($idCorpoCh);

        if (!$chcorporation) {
            throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        if (!$ChParametres) {
            throw $this->createNotFoundException("Les paramètres pour le hampionnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere la corporationCh parent
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $chcorporation_parent = $repository->findOneBy(array(
            'corporation_id' => $chcorporation->getCorporationId(),
            'championnat_id' => $ChParametres->getChampionnatHeritId()
        ));

        if (!$chcorporation_parent) {
            throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

         // On recupere les ChJoueurs de la ChCorporation parent
        $ChJoueurs = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChJoueur')
            ->getChJoueurs($chcorporation_parent->getId());

        // --------

        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        foreach ($ChJoueurs as $joueur)  {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Redu');
            $redu = $repository->findOneBy(array('AFNUMERO' => $joueur->getJoueurId()->getNumAft()));

            if (!$redu) {
                $classementRedu = null;
            }
            else{
                $classRedu = $redu->getAFNUMCLASS();

                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                $classementRedu = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $classRedu));

                if (!$classementRedu) {
                    throw $this->createNotFoundException("Le classement pour le championnat ".$idChampionnat." et la valeur ".$classRedu);
                }
            }

            // Calcul du classement RIL du joueur (Héritage + Classement REDU)
            // Si championnatHerit = null --> pas d'héritage à gérer -> Calssement REDU d'office
            // Si championnatHertit <> null --> calcul du bonus/malus acquis ds championnatHerit et comparer avec classement redu
                //Si classementHerit > classement redu -> classementHerit est pris en compte, sinon classement redu

            $chjoueur = new ChJoueur();
            $chjoueur->setTotalPtGagne(0);
            $chjoueur->setTotalPtPerdu(0);
            $chjoueur->setUser($this->getUser());
            $chjoueur->setChampionnatId($championnat);
            $chjoueur->setChcorporationId($chcorporation);
            $chjoueur->setJoueurId($joueur->getJoueurId());
            $chjoueur->setChClassementReduId($classementRedu);

            if ($ChParametres->getChampionnatHeritId() == null){

                // Ici, il n'existe pas de championnat parent -> on se base sur le classement redu uniquement

                $chjoueur->setChClassementRilPrecedentId(null);
                $chjoueur->setChclassementRilCalculId($classementRedu);
                $chjoueur->setChclassementRilId($classementRedu);
                
                // Calcul classement mixte ------------
                
                if ($classementRedu == null){

                    $chjoueur->setChclassementRilMixteId(null);
                    $chjoueur->setChclassementRilMixteCalculId(null);
                }
                else{

                    if ($joueur->getSexe() == 'F'){

                        $ClassemmentMixte = $this->get('calculClassementMixte');

                        $ClassemmentMixte->processClassementMixte($classementRedu->getnumeroOrdre());
                        $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                        $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                        if (!$ClassementMixte_new) {
                            throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                        }                
                        
                        $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                        $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);
                    }
                    else{

                        // Si masculin --> classement mixte = classement RIL normal
                        $chjoueur->setChclassementRilMixteId($classementRedu);
                        $chjoueur->setChclassementRilMixteCalculId($classementRedu);
                    }

                    // Fin classement mixte ------------

                }
            }
            else{

                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChJoueur');
                $ChJoueursParents = $repository->findBy(array('championnat_id' => $ChParametres->getChampionnatHeritId(), 'joueur_id' => $joueur->getJoueurId()->getId()));

                // Il pourrait y avoir plusieur joueurCH parent si le joueur à jouer dans 2 corpos différentes pendant le championnat (comme les dames -> F et mixte)

                if (empty($ChJoueursParents)) {

                    // Ici, il existe un championnat parent, mais le joueur n'existe pas pour ce championnat parent

                    $chjoueur->setChClassementRilPrecedentId(null);

                    $chjoueur->setChclassementRilCalculId($classementRedu);
                    $chjoueur->setChclassementRilId($classementRedu);

                    // Calcul classement mixte ------------
                    if ($joueur->getJoueurId()->getSexe() == 'F'){
                        $ClassemmentMixte = $this->get('calculClassementMixte');
                        $ClassemmentMixte->processClassementMixte($classementRedu->getnumeroOrdre());
                        $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                        $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                        if (!$ClassementMixte_new) {
                            throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                        }                
                        
                        $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                        $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);

                    }
                    else{

                        // Si masculin --> classement mixte = classement RIL normal

                        $chjoueur->setChclassementRilMixteId($classementRedu);
                        $chjoueur->setChclassementRilMixteCalculId($classementRedu);
                    }

                    // Fin classement mixte -----------
                }
                else{

                    // Ici, Il existe un championnat parent et le joueur existe pour ce championnat parent

                    $totalPoints = 0;

                    foreach ($ChJoueursParents as $ChJoueurParent) {

                        // On recupere le total des points en simple du ChJoueurs
                        $pointsSimple = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChJoueurPtsSimple')
                            ->getPoints($ChJoueurParent->getId());

                        if (!$pointsSimple) {
                            $pointsSimple = 0;
                        }

                        $pointsDouble = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChJoueurPtsDouble')
                            ->getPoints($ChJoueurParent->getId());

                        if (!$pointsDouble) {
                            $pointsDouble = 0;
                        }

                        $totalPoints = $totalPoints + $pointsSimple + $pointsDouble;
                    }

                    // Le $ChJoueurParent utilisé ci-après est le dernier traité par la boucle FOR ci-dessus

                    // Calcul du nouveau classement RIL du joueur

                    if ($ChJoueurParent->getChclassementRilId() <> null){

                        $CalculClassementJoueur = $this->get('calculClassement');
                        $CalculClassementJoueur->processClassementJoueur($ChJoueurParent->getChclassementRilId()->getvaleur(), $totalPoints);
                        $valeurClassement = $CalculClassementJoueur->getValeurClassement();

                        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                        $ChclassementRil = $repository->findOneBy(array('championnat_id' => $idChampionnat, 'valeur' => $valeurClassement));

                        if (!$ChclassementRil) {
                            throw $this->createNotFoundException("Le classementCh avec la valeur ".$valeurClassement." n'existe pas pour le championnat".$idChampionnat);
                        }

                        if ($classementRedu == null or $ChclassementRil->getnumeroOrdre() < $classementRedu->getnumeroOrdre() ){
                            $chjoueur->setChclassementRilCalculId($ChclassementRil);
                            $chjoueur->setChClassementRilPrecedentId($ChJoueurParent->getChclassementRilId());
                            $chjoueur->setChclassementRilId($ChclassementRil);
                        }
                        else{
                            
                            $chjoueur->setChclassementRilCalculId($classementRedu);
                            $chjoueur->setChClassementRilPrecedentId($ChJoueurParent->getChclassementRilId());
                            $chjoueur->setChclassementRilId($classementRedu);
                            
                        }

                    }


                    // Calcul classement mixte ------------

                    if ($joueur->getJoueurId()->getSexe() == 'F'){
                        $ClassemmentMixte = $this->get('calculClassementMixte');
                        $ClassemmentMixte->processClassementMixte($ChclassementRil->getnumeroOrdre()); // On se base sur le classement RIL calculé !!!
                        $numeroOrdreMixte = $ClassemmentMixte->getValeurMixteClassement();

                        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
                        $ClassementMixte_new = $repository->findOneBy(array('championnat_id' => $idChampionnat , 'numeroOrdre' => $numeroOrdreMixte));

                        if (!$ClassementMixte_new) {
                            throw $this->createNotFoundException("Le classement mixte pour le championnat ".$idChampionnat." et le numero ordre: ".$numeroOrdreMixte." non trouvé !");
                        }                
                        
                        $chjoueur->setChclassementRilMixteId($ClassementMixte_new);
                        $chjoueur->setChclassementRilMixteCalculId($ClassementMixte_new);
                    }
                    else{
                        
                        // Si masculin --> classement mixte = classement RIL normal
                        
                         if ($classementRedu == null or $ChclassementRil->getnumeroOrdre() < $classementRedu->getnumeroOrdre() ){

                            $chjoueur->setChclassementRilMixteId($ChclassementRil);
                            $chjoueur->setChclassementRilMixteCalculId($ChclassementRil);
                         }
                         else{
                             $chjoueur->setChclassementRilMixteId($classementRedu);
                             $chjoueur->setChclassementRilMixteCalculId($classementRedu);
                         }
                    }

                    // Fin classement mixte -----------
                }
            }
/*


            // On recupere le total des points en simple du ChJoueurs
            $pointsSimple = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueurPtsSimple')
                ->getPoints($ChJoueur->getId());

            if (!$pointsSimple) {
                $pointsSimple  = 0;
            }

            $pointsDouble = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueurPtsDouble')
                ->getPoints($ChJoueur->getId());

            if (!$pointsDouble) {
                $pointsDouble  = 0;
            }

            $totalPoints = $pointsSimple + $pointsDouble;

            // Calcul du nouveau classement RIL du joueur

            $CalculClassementJoueur = $this->get('calculClassement');
            $CalculClassementJoueur->processClassementJoueur($ChJoueur->getChClassementRilId()->getvaleur(), $totalPoints);
            $valeurClassement = $CalculClassementJoueur->ValeurClassement();

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChClassement');
            $ChclassementRil = $repository->findOneBy(array('valeur' => $valeurClassement));

            if (!$ChclassementRil) {
                throw $this->createNotFoundException("Le classementCh avec la valeur ".$valeurClassement." n'existe pas pour le championnat".$idChampionnat);
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Redu');
            $redu = $repository->findOneBy(array('AFNUMERO' => $ChJoueur->getNumAft()));

            if (!$redu) {
                $classRedu = null;
            }
            else{
                $classRedu = $redu->getAFCLASSMT();
            }

            $chjoueur_new = new ChJoueur();

            $chjoueur_new->setTotalPtGagne(0);
            $chjoueur_new->setTotalPtPerdu(0);
            $chjoueur_new->setChcorporationId($chcorporation);
            $chjoueur_new->setJoueurId($ChJoueur->getJoueurId());
            $chjoueur_new->setUser($this->getUser());
            $chjoueur_new->setChampionnatId($championnat);

            if ($ChParametres->getChampionnatHeritId() == null){
                $chjoueur_new->setChClassementReduId($classementRedu);
                $chjoueur_new->setChclassementRilId($classementRedu);
                $chjoueur_new->setChclassementRilPrecedentId(null);
            }
            else{
                $chjoueur_new->setChClassementReduId($classementRedu);
                $chjoueur_new->setChclassementRilId($ChclassementRil);
                $chjoueur_new->setChClassementRilPrecedentId($ChJoueur->getClassementRil());
            }
*/
            $em->persist($chjoueur);
            $em->flush();
        }

        if ($ChJoueurs) {
            
            $bag = $this->get('session')->getFlashBag();
            $bag->set('message', 'L\'importation des joueurs et de leurs nouveaux classements a été réalisée avec succès.');
        }
        else{
            $bag = $this->get('session')->getFlashBag();
            $bag->set('warning', 'Aucun joueur trouvé pour la corporation parente.');
        }

        $em->getConnection()->commit();

        return $this->redirect($this->generateUrl('sws_back_listchjoueur', array('idChampionnat' => $idChampionnat, 'idCorpoCh' => $idCorpoCh)));
    }

}

