<?php

/**
 * Fichier: ChIndisponibiliteController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité ChIndisponibilite
 *
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChIndisponibilite;
use sws\Bundle\BackBundle\Form\Handler\ChIndisponibiliteJourFerieHandler;
use sws\Bundle\BackBundle\Form\Handler\ChIndisponibiliteVacancesScolairesHandler;
use sws\Bundle\BackBundle\Form\Type\ChIndisponibiliteJourFerieType;
use sws\Bundle\BackBundle\Form\Type\ChIndisponibiliteVacancesScolairesType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;



class ChIndisponibiliteController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'corporation');
    }


    /**
     * Affiche une entité Championnat
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:Championnat:view.html.twig
     */
    public function listAction($idChampionnat, Request $request)
    {

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

       if (!$ChParametres) {
            throw $this->createNotFoundException("Les ChParametres avec pour le championnat ".$idChampionnat." n'existe pas.");
        }

        // On recupere les indisponibilites associés au championnat
        $ChIndisponibilite = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChIndisponibilite')
            ->getChIndisponibilite($idChampionnat);

        return $this->render('swsBackBundle:ChIndisponibilite:list.html.twig',array(
            'Championnat' => $Championnat,
            'ChIndisponibilite' => $ChIndisponibilite,
            'ChParametres' => $ChParametres
            )
        );

    }


    public function createJourFerieAction($idChampionnat, Request $request)
    {
        $formHandler = new ChIndisponibiliteJourFerieHandler($this->createForm(new ChIndisponibiliteJourFerieType(), new ChIndisponibilite()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $indisponibilite = $formHandler->getForm()->getData();
            $indisponibilite->setUser($this->getUser());
            $indisponibilite->setChampionnatId($Championnat);
 
            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($indisponibilite);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChIndisponibilite:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }

    public function createCreateVacancesScolairesAction($idChampionnat, Request $request)
    {
        $formHandler = new ChIndisponibiliteVacancesScolairesHandler($this->createForm(new ChIndisponibiliteVacancesScolairesType(), new ChIndisponibilite()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $indisponibilite = $formHandler->getForm()->getData();
            $indisponibilite->setUser($this->getUser());
            $indisponibilite->setChampionnatId($Championnat);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($indisponibilite);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChIndisponibilite:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }


    public function deleteAction($idChampionnat, $id)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $IndisponibiliteCh = $repository->find($id);

        if (!$IndisponibiliteCh) {
            throw $this->createNotFoundException("L'indisponibiliteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($IndisponibiliteCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

    }

    public function indisponibiliteJourFerieModifyAction($idChampionnat, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $ChIndisponibilite = $repository->find($id);

        if (!$ChIndisponibilite) {
            throw $this->createNotFoundException("L'indisponibiliteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChIndisponibiliteJourFerieHandler($this->createForm(new ChIndisponibiliteJourFerieType(), $ChIndisponibilite), $request);

        if ($formHandler->verification()) {

            $indisponibilite = $formHandler->getForm()->getData();
            $indisponibilite->setUser($this->getUser());
            $indisponibilite->setChampionnatId($Championnat);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($indisponibilite);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChIndisponibilite:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    public function indisponibiliteVacancesScolairesModifyAction($idChampionnat, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChIndisponibilite');
        $ChIndisponibilite = $repository->find($id);

        if (!$ChIndisponibilite) {
            throw $this->createNotFoundException("L'indisponibiliteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChIndisponibiliteVacancesScolairesHandler($this->createForm(new ChIndisponibiliteVacancesScolairesType(), $ChIndisponibilite), $request);

        if ($formHandler->verification()) {

            $indisponibilite = $formHandler->getForm()->getData();
            $indisponibilite->setUser($this->getUser());
            $indisponibilite->setChampionnatId($Championnat);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($indisponibilite);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChIndisponibilite:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

}

