<?php

/**
 * Fichier: ChEquipeController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chEquipe
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChEquipe;
use sws\Bundle\BackBundle\Entity\Corporation;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChEquipeType;
use sws\Bundle\BackBundle\Form\Handler\ChEquipeHandler;


class ChEquipeController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'corporation');
    }

    /**
     * Affiche une entité Chequipe
     *
     * @param int $id Valeur de l'identification du chequipe
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:chequipes:view.html.twig
     */
    public function viewAction($idChampionnat, $idCorpoCh, $id, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($id);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("La chequipe avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChequipeHandler($this->createForm(new ChequipeType(), $ChEquipe, array('disabled' => true)), $request);

        return $this->render('swsBackBundle:ChEquipe:view.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));
    }
    
    /**
     * Affiche une entité Championnat
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:Championnat:view.html.twig
     */
    public function listAction($idChampionnat, $idCorpoCh, Request $request)
    {

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);     
            
       if (!$ChParametres) {
            throw $this->createNotFoundException("Les ChParametres avec pour le championnat ".$idChampionnat." n'existe pas.");
        }


        $repCorporationCh = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');

        // On recupère la corporationCH
        $ChCorporation = $repCorporationCh->find($idCorpoCh);

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repCorporation = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Corporation');

        // On recupère la Corporation
        $Corporation = $repCorporation->findOneById($ChCorporation->getCorporationId());

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        // On recupere les equipes associées à la corporationCH
        $ChEquipe = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipe($idCorpoCh);

        return $this->render('swsBackBundle:ChEquipe:list.html.twig',array(
                'Championnat' => $Championnat,
                'ChCorporation' => $ChCorporation,
                'ChEquipes' => $ChEquipe,
                'Corporation' => $Corporation,
                'ChParametres' => $ChParametres
            )
        );

    }


    /**
     * Crée une entité Chequipe
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchequipe
     * @return form vers la template swsBackBundle:chequipe:create.html.twig
     */
    public function EquipeCreateAction($idChampionnat, $idCorpoCh, Request $request)
    {
        $formHandler = new ChEquipeHandler($this->createForm(new ChEquipeType(), new ChEquipe()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorpoCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corpoCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
            }

            $equipe = $formHandler->getForm()->getData();
            $equipe->setUser($this->getUser());
            $equipe->setChcorporationId($ChCorporation);
            $equipe->setChampionnatId($Championnat);


            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($equipe);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchequipe', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh
            )));
        }

        return $this->render('swsBackBundle:ChEquipe:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }

    /**
     * Supprime une entité ChEquipe
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette equipe :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la equipe du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idCorpoCh, $idEquipeCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $EquipeCh = $repository->find($idEquipeCh);

        if (!$EquipeCh) {
            throw $this->createNotFoundException("La equipeCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($EquipeCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchequipe', array(
            'idChampionnat' => $idChampionnat,
            'idCorpoCh' => $idCorpoCh
        )));

    }

    /**
     * Modifie une entité ChEquipe
     *
     * @param int $id Valeur de l'identification du equipe
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchequipe
     * @return form vers la template swsBackBundle:ChEquipe:modify.html.twig
     */
    public function modifyAction($idChampionnat,$idCorpoCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le equipeCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);     
            
       if (!$ChParametres) {
            throw $this->createNotFoundException("Les ChParametres avec pour le championnat ".$idChampionnat." n'existe pas.");
        }        

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($id);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("Le equipeCH avec l'identifiant ".$id." n'existe pas.");
        }

        $formHandler = new ChEquipeHandler($this->createForm(new ChEquipeType(array('idChampionnat' => $idChampionnat)), $ChEquipe), $request);

        if ($formHandler->verification()) {

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($formHandler->getForm()->getData());
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchequipe', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh
            )));
        }

        return $this->render('swsBackBundle:ChEquipe:modify.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'ChParametres' => $ChParametres
        ));
    }

}

