<?php

/**
 * Fichier: ChDivisionController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chDivision
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use Proxies\__CG__\sws\Bundle\BackBundle\Entity\ChEquipe;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChDivision;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChDivisionType;
use sws\Bundle\BackBundle\Form\Handler\ChDivisionHandler;
use Symfony\Component\HttpFoundation\Response;


class ChDivisionController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'division');
    }
    /**
     * Crée une entité Chdivision
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchdivision
     * @return form vers la template swsBackBundle:chdivision:create.html.twig
     */
    public function divisionCreateAction($idChampionnat, Request $request)
    {
        $formHandler = new ChDivisionHandler($this->createForm(new ChDivisionType(), new ChDivision()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $division = $formHandler->getForm()->getData();
            $division->setUser($this->getUser());
            $division->setChampionnatId($Championnat);


            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($division);
            $em->flush();

             return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChDivision:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));
    }

    /**
     * Supprime une entité ChDivision
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette division :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la division du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idDivisionCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $DivisionCh = $repository->find($idDivisionCh);

        if (!$DivisionCh) {
            throw $this->createNotFoundException("La division/championnat avec l'identifiant ".$idDivisionCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($DivisionCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

    }
    
    public function modifyAction($idChampionnat,$idDivisionCh, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le equipeCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivision = $repository->find($idDivisionCh);

        if (!$ChDivision) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idDivisionCh." n'existe pas.");
        }

        $formHandler = new ChDivisionHandler($this->createForm(new ChDivisionType(), $ChDivision), $request);

        if ($formHandler->verification()) {

            $division = $formHandler->getForm()->getData();
            $division->setUser($this->getUser());

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($division);
            $em->flush();

             return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
        }

        return $this->render('swsBackBundle:ChDivision:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }


    /**
     * @param $idChampionnat
     * @param $idDivisionCh
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function assoDivisionAction($idChampionnat,$idDivisionCh, Request $request)
    {

        // a changer car pas de formtype dans ce cas ci !
        // + ajouter une focntion de liste des equipe associées

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le equipeCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivision = $repository->find($idDivisionCh);

        if (!$ChDivision) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idDivisionCh." n'existe pas.");
        }

        $idEquipeCh = $request->request->get('idEquipeCh');
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        $ChEquipe->setChdivisionId($ChDivision);

        $em = $this->getDoctrine()->getEntityManager();
        $em-> persist($ChEquipe);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchequipedivision', array('idChampionnat' => $idChampionnat, 'idDivisionCh' => $idDivisionCh)));

    }

    public function cancelAssoDivisionAction($idChampionnat,$idDivisionCh, $idEquipeCh, Request $request)
    {

        // a changer car pas de formtype dans ce cas ci !
        // + ajouter une focntion de liste des equipe associées

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le equipeCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivision = $repository->find($idDivisionCh);

        if (!$ChDivision) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idDivisionCh." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        $ChEquipe->setChdivisionId(null);

        $em = $this->getDoctrine()->getEntityManager();
        $em-> persist($ChEquipe);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchequipedivision', array('idChampionnat' => $idChampionnat, 'idDivisionCh' => $idDivisionCh)));

    }

    public function listEquipeDivisionAction($idChampionnat, $idDivisionCh, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$repository) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivision = $repository->find($idDivisionCh);

        if (!$repository) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idDivisionCh . " n'existe pas.");
        }

        // On recupere les équipes associées à la division
        $listEquipesAsso = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipeAsso($idDivisionCh);

        // On recupere les équipes a ajouter à la division (pas encore associées)
        $listEquipesNonAsso = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getChEquipesNonAsso($idChampionnat, $ChDivision->getPtsMinimum(), $ChDivision->getPtsMaximum(), $ChDivision->getGenre());


        return $this->render('swsBackBundle:ChDivision:list.equipe.html.twig',array(
            'Championnat' => $Championnat,
            'ChDivision' => $ChDivision,
            'listEquipesAsso' => $listEquipesAsso,
            'listEquipesNonAsso' => $listEquipesNonAsso,
            'ChParametres' => $ChParametres
            )
        );
    }

    public function classementDivisionAction($idChampionnat, $idDivisionCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le championnat avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivision = $repository->find($idDivisionCh);

        if (!$ChDivision) {
            throw $this->createNotFoundException("La division/championnat avec l'identifiant ".$idDivisionCh." n'existe pas.");
        }

        $classementDivision = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChEquipe')
            ->getClassement($idDivisionCh);

        return $this->render('swsBackBundle:ChDivision:classement.html.twig',array(
            'Championnat' => $Championnat,
            'ChDivision' => $ChDivision,
            'classementDivision' => $classementDivision
            )
        );
    }    

    /**
     * Export des rencontres des divisions
     *
     */
    public function exportAction($idChampionnat, $type, Request $request)
    {

       if ($request->ismethod('post')) {

            if ( !$request->request->get('DivisionId')){

                return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

            }
          
            $now = new \Datetime();
            $now_format = $now->format('d-m-y H:i');
            $now_format2 = $now->format('d_m_y ');
            
            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            $html = '';
          
            foreach ($request->request->get('DivisionId') as $ChDivisionId) {

                $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
                $ChDivision = $repository->find($ChDivisionId);
                $ChDivisions[] = $ChDivision;

                /*
                if (!$ChLocation) {
                    throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$ChCorporationId." n'existe pas.");
                }
                */

                if ($request->request->get('listeRencDivisionXls')){
                    // On recupere la liste de force de la corpoCH
                    $rencontres[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChPlanning')
                        ->getRencontresDivisionArray($ChDivision);
                }
                else{

                    $rencontres[] = $this->getDoctrine()
                        ->getManager()
                        ->getRepository('swsBackBundle:ChPlanning')
                        ->getRencontresDivision($ChDivision);
                }
            }

           // Si le bouton listeForceXls est cliqué
           if ($request->request->get('listeRencDivisionXls')){

               $x = 0;

               foreach ($rencontres as $division){

                   $i = 0;
                   foreach ($division as $rencontre){

                   //dump($rencontre);
                   //die;

                   $listeRencontres[$x][$i]['date'] = $rencontre['dateRencontre']->format('d-m-Y');
                   $listeRencontres[$x][$i]['nomCorpoVisitee'] = $rencontre['chcorporationVisitee_id']['corporation_id']['nom'];
                   $listeRencontres[$x][$i]['numeroEqVisitee'] = $rencontre['chequipeVisitee_id']['numeroEquipe'];
                   $listeRencontres[$x][$i]['nomCorpoVisiteuse'] = $rencontre['chcorporationVisiteuse_id']['corporation_id']['nom'];
                   $listeRencontres[$x][$i]['numeroEqVisiteuse'] = $rencontre['chequipeVisiteuse_id']['numeroEquipe'];
                   $listeRencontres[$x][$i]['salle'] = $rencontre['chsalle_id']['salle_id']['nom'];
                   $listeRencontres[$x][$i]['heureDebut'] = $rencontre['chsalle_id']['chlocations'][0]['heureDebut']->format('H:i');
                   $listeRencontres[$x][$i]['division'] = $rencontre['chdivision_id']['nom'] . ' ' . $rencontre['chdivision_id']['numero'] . ' ' . $rencontre['chdivision_id']['suffixe'] ;
                   
                   
                       /*

                       if ($terrain['jour'] == 1){ $listesLocations[$x][$i]['jour'] = 'Lundi'; }
                       if ($terrain['jour'] == 2){ $listesLocations[$x][$i]['jour'] = 'Mardi'; }                       
                       if ($terrain['jour'] == 3){ $listesLocations[$x][$i]['jour'] = 'Mercredi'; }                       
                       if ($terrain['jour'] == 4){ $listesLocations[$x][$i]['jour'] = 'Jeudi'; }                       
                       if ($terrain['jour'] == 5){ $listesLocations[$x][$i]['jour'] = 'Vendredi'; }                       
                       if ($terrain['jour'] == 6){ $listesLocations[$x][$i]['jour'] = 'Samedi'; }                       
                       if ($terrain['jour'] == 7){ $listesLocations[$x][$i]['jour'] = 'Dimanche'; }                       

                       $listesLocations[$x][$i]['tarifHeure'] = $terrain['tarifHeure'];
                       $listesLocations[$x][$i]['numeroRencontre'] = $terrain['numeroRencontre'];
                       */


                       //$listesLocations[$x][$i]['typeSurface'] = $terrain['typeSurface_id']['type'];


                       $i = $i + 1;
                   }

                   /*if ($i == 0){
                       $listesLocations[$x][$x]['salle'] = $ChSalles[$x]->getSalleId()->getNom();
                   }
                   */


                   $x = $x + 1;
               }
               
               // ask the service for a Excel5
               $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();


               $phpExcelObject->getProperties()->setCreator($this->getUser()->getNom().' '.$this->getUser()->getPrenom())
                   ->setTitle("Liste des rencontres");

               $y = 0;
               foreach ($listeRencontres as $listeRencontres2){

                   if ($y <> 0 ){
                       $phpExcelObject->createSheet($y);
                   }
                   $phpExcelObject->setActiveSheetIndex($y);
                   $phpExcelObject->getActiveSheet()
                       ->fromArray(
                           $listeRencontres2,  // The data to set
                           NULL,        // Array values with this value will not be set
                           'A1'         // Top left coordinate of the worksheet range where
                       //    we want to set these values (default is A1)
                       );
                   $phpExcelObject->getActiveSheet()->setTitle($listeRencontres2[$y]['division']);
                   // Set active sheet index to the first sheet, so Excel opens this as the first sheet

                   $y = $y + 1;
               }

               $phpExcelObject->setActiveSheetIndex(0);

               // create the writer
               $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
               // create the response
               $response = $this->get('phpexcel')->createStreamedResponse($writer);
               // adding headers
               $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');

               $fileName = 'RIL_rencontres_division_'.$Championnat->getNom().'_'.$now_format2.'.xls';
               $sanitizer = $this->get('sanitizeFileName');
               $sanitizer->processSanitizeFileNamle($fileName);
               $fileName = $sanitizer->getFileName();

               $response->headers->set('Content-Disposition', 'attachment;filename='.$fileName);
               $response->headers->set('Pragma', 'public');
               $response->headers->set('Cache-Control', 'maxage=1');

               return $response;

           }

           // Si le bouton listeForcePdf est cliqué
           if ($request->request->get('listeRencDivisionPdf')){

                $fileName = 'RIL_rencontres_division.pdf';
                $sanitizer = $this->get('sanitizeFileName');
                $sanitizer->processSanitizeFileNamle($fileName);
                $fileName = $sanitizer->getFileName();

               $html = $this->renderView('swsBackBundle:ChRencontre:pdf.rencontres.division.html.twig', array(
                    'rencontres' => $rencontres,
                    'ChDivisions' => $ChDivisions
               ));

               $url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
                       ->get('templating.helper.assets')
                       ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);

                return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml(
                        $html,
                        array('orientation'=>'Portrait',
                            'margin-left' => 4,
                            'margin-right' => 4,
                            'margin-top' => 5,
                            //'header-font-size' => 10,
                            'header-spacing' => '0',
                            /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                            'footer-font-size' => 8,
                            //'footer-line' => false,
                            'footer-left' => $now_format,
                            //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                            'footer-right' => 'P. [page]/[toPage]',
                            'footer-spacing' => '6',
                            'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                            //'footer-html' => $url_footer
                            //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                        )),
                    200,
                    array(
                        'Content-Type'          => 'application/pdf',
                        'Content-Disposition'   => 'attachment; filename='.$fileName
                    )
                );                    
            }

            // arrivé ici !!!

            // Si le bouton listeForceHtml est cliqué
            if ($request->request->get('listeRencDivisionHtml')){

                return $this->render('swsBackBundle:ChRencontre:rencontres.divisions.complete.html.twig', array(
                    'rencontres' => $rencontres,
                    'ChDivisions' => $ChDivisions
                ));
            }
        }
    }

    public function permutationEquipeAction($idChampionnat, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$repository) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        // On recupere les divisions du championnat
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivisions = $repository->findBy(array('championnat_id' => $idChampionnat));

        return $this->render('swsBackBundle:ChDivision:permutation.equipe.html.twig',array(
                'Championnat' => $Championnat,
                'ChDivisions' => $ChDivisions,
                'ChParametres' => $ChParametres
            )
        );
    }

    public function permuterEquipeAction($idChampionnat, Request $request)
    {

        /* sws-todo: ajouter les vérifications avant d'effectuer la permutation (match déjà joué ?) */
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$repository) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        $em = $this->getDoctrine()->getEntityManager();
        $em->getConnection()->beginTransaction();

        // Mise à jour de la permutation du N° de division pour chaque équipe
        $idEquipeCh = $request->request->get('idEquipeCh2');
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe2 = $repository->find($idEquipeCh);

        if (!$ChEquipe2) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        $idEquipeCh = $request->request->get('idEquipeCh3');
        $ChEquipe3 = $repository->find($idEquipeCh);

        if (!$ChEquipe3) {
            throw $this->createNotFoundException("La divisionCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        $divEq2 = $ChEquipe3->getChdivisionId();
        $divEq3 = $ChEquipe2->getChdivisionId();

        $ChEquipe2->setChdivisionId($divEq2);
        $ChEquipe3->setChdivisionId($divEq3);

        $em-> persist($ChEquipe2);
        $em-> persist($ChEquipe3);
        $em->flush();

        // On recupere les rencontres pour l'équipe 2
        $ChPlanningEq2 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresEquipe($ChEquipe2);

        $ChPlanningEq3 = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChPlanning')
            ->getRencontresEquipe($ChEquipe3);

        foreach ($ChPlanningEq2 as $rencontre){

            if ($rencontre->getChEquipeVisiteeId()->getId() == $ChEquipe2->getId()){

                $rencontre->setChEquipeVisiteeId($ChEquipe3);
                $rencontre->setChCorporationVisiteeId($ChEquipe3->getChcorporationId());

                $em-> persist($rencontre);

            }
            else{

                $rencontre->setChEquipeVisiteuseId($ChEquipe3);
                $rencontre->setChCorporationVisiteuseId($ChEquipe3->getChcorporationId());

                $em-> persist($rencontre);

            }

        }

        foreach ($ChPlanningEq3 as $rencontre){

            if ($rencontre->getChEquipeVisiteeId()->getId() == $ChEquipe3->getId()){

                $rencontre->setChEquipeVisiteeId($ChEquipe2);
                $rencontre->setChCorporationVisiteeId($ChEquipe2->getChcorporationId());

                $em-> persist($rencontre);

            }
            else{

                $rencontre->setChEquipeVisiteuseId($ChEquipe2);
                $rencontre->setChCorporationVisiteuseId($ChEquipe2->getChcorporationId());

                $em-> persist($rencontre);

            }

        }

        $em->flush();
        $em->getConnection()->commit();

        // On recupere les divisions du championnat
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivisions = $repository->findBy(array('championnat_id' => $idChampionnat));

        return $this->render('swsBackBundle:ChDivision:permutation.equipe.html.twig',array(
                'Championnat' => $Championnat,
                'ChDivisions' => $ChDivisions,
                'ChParametres' => $ChParametres
            )
        );
    }
}
