<?php

/**
 * Fichier: ChCorporationController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chCorporation
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChCorporation;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChCorporationType;
use sws\Bundle\BackBundle\Form\Handler\ChCorporationHandler;
use Symfony\Component\HttpFoundation\Response;


class ChCorporationController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'corporation');
    }
    /**
     * Crée une entité Chcorporation
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcorporation
     * @return form vers la template swsBackBundle:chcorporation:create.html.twig
     */
    public function managerCorporationCreateAction($idChampionnat, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        $idCorporation = $request->request->get('corporation');
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Corporation');
        $corporation = $repository->find($idCorporation);

        $chcorporation = new ChCorporation();
        $chcorporation->setUser($this->getUser());
        $chcorporation->setChampionnatId($championnat);
        $chcorporation->setcorporationId($corporation);

        $em = $this->getDoctrine()->getEntityManager();
        $em->persist($chcorporation);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
    }

    /**
     * Supprime une entité ChCorporation
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette corporation :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la corporation du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idCorporationCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $CorporationCh = $repository->find($idCorporationCh);

        if (!$CorporationCh) {
            throw $this->createNotFoundException("La corporation/championnat avec l'identifiant ".$idCorporationCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($CorporationCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

    }

    /*
       * Recopier les ChCorporation d'un championnat par héritage
       *
       * @return route sws_back_manager_championnat
       */
    public function managerInheritCorporationAction($id)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($id);

        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$id." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($id);

        if (!$ChParametres) {
            throw $this->createNotFoundException("Les paramètres pour le hampionnat avec l'identifiant ".$id." n'existe pas.");
        }

        // On recupere les ChCorporatrions du championnat parent
        $ChCorporations = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChCorporation')
            ->getChCorporation($ChParametres->getChampionnatHeritId());

        foreach ($ChCorporations as $ChCorporation)  {

            $chcorporation_new = new ChCorporation();
            $chcorporation_new->setUser($this->getUser());
            $chcorporation_new->setChampionnatId($championnat);
            $chcorporation_new->setcorporationId($ChCorporation->getCorporationId());

            $em = $this->getDoctrine()->getEntityManager();
            $em->persist($chcorporation_new);

        }

        if ($ChCorporations) {
            $em->flush();
            $bag = $this->get('session')->getFlashBag();
            $bag->set('message', 'L\'importation des corporations a été réalisée avec succès.');
        }
        else{
            $bag = $this->get('session')->getFlashBag();
            $bag->set('warning', 'Aucune corporation trouvée dans le championnat parent.');
        }



        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $id)));
    }

    public function listeForceChcorporationAction($idChampionnat, ChCorporation $ChCorporation, $type, Request $request){

        $ChCorporations[0] = $ChCorporation;

        if ($ChCorporations[0]->getCorporationId()->getGenre() == 'F'){

            // On recupere la liste de force de la corpoCH Dame
            $listesForce[] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getListeForceCorpoDames($ChCorporation->getId());
        }
        else{

            // On recupere la liste de force de la corpoCH Mixte et Homme
            $listesForce[] = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChJoueur')
                ->getListeForceCorpo($ChCorporation->getId());
        }

        if ($type == 'pdf'){

            $now = new \Datetime();
            $now_format = $now->format('d-m-y H:i');
            $now_format2 = $now->format('d_m_y ');

            $html = $this->renderView('swsBackBundle:ChCorporation:pdf.liste2.force.html.twig', array(
                        'listesForce' => $listesForce,
                        'ChCorporations' => $ChCorporations
                    ));

            $fileName = 'RIL_liste_force_'.$ChCorporation->getCorporationId()->getNomsuccinct().'.pdf';
            $sanitizer = $this->get('sanitizeFileName');
            $sanitizer->processSanitizeFileNamle($fileName);
            $fileName = $sanitizer->getFileName();

            return new Response(
                $this->get('knp_snappy.pdf')->getOutputFromHtml(
                                                $html,
                                                array('orientation'=>'Portrait',
                                                    'margin-left' => 4,
                                                    'margin-right' => 4,
                                                    'margin-top' => 5,
                                                    //'header-font-size' => 10,
                                                    'header-spacing' => '0',
                                                    /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/
                        
                                                    'footer-font-size' => 8,
                                                    //'footer-line' => false,
                                                    'footer-left' => $now_format,
                                                    //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                                                    'footer-right' => 'P. [page]/[toPage]',
                                                    'footer-spacing' => '6',
                                                    'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                                                    //'footer-html' => $url_footer
                                                    //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                                            )),
                    200,
                    array(
                    'Content-Type'          => 'application/pdf',
                        'Content-Disposition'   => 'attachment; filename='.$fileName
                )
            );

        }
        else{

            return $this->render('swsBackBundle:ChCorporation:liste2.force.html.twig', array(
                        'listesForce' => $listesForce,
                        'ChCorporations' => $ChCorporations
            ));                    

        }
    }

   public function exportChcorporationAction($idChampionnat, $type, Request $request){



       if ($request->ismethod('post')) {

            if ( !$request->request->get('corposId')){

                return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));

            }


          
            $now = new \Datetime();
            $now_format = $now->format('d-m-y H:i');
            $now_format2 = $now->format('d_m_y ');


            // Gestion du planning des rencontres
          
            if ($request->request->get('planningHtml') or $request->request->get('planningPdf') or $request->request->get('planningPdfQr')
                or $request->request->get('planningHtmlQr') or $request->request->get('planningXls'))
            {



                $ind_corpo = 0;
                foreach ($request->request->get('corposId') as $ChCorporationId) {

                    $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporation = $repository->find($ChCorporationId);
                    $ChCorporations[] = $ChCorporation;

                    if (!$ChCorporation) {
                        throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$ChCorporationId." n'existe pas.");
                    }

                    $equipesCorpo[$ind_corpo] = $this->getDoctrine()
                          ->getManager()
                          ->getRepository('swsBackBundle:ChEquipe')
                          ->getChEquipe($ChCorporationId);

                    if (empty($equipesCorpo[0])) {

                        $bag = $this->get('session')->getFlashBag();
                        $bag->set('warning', 'Aucune équipe trouvée pour cette corporation  ('.$ChCorporation->getCorporationId()->getNom().') !');
                        return $this->redirect($this->generateUrl('sws_back_manager_championnat', array('id' => $idChampionnat)));
                    }

                    $ind_equipe = 0;

                    foreach ($equipesCorpo[$ind_corpo] as $equipe) {

                        if ($request->request->get('planningXls')){

                            $rencontres[$ind_corpo][$ind_equipe] = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChPlanning')
                            ->getrencontresEquipeArray($equipe->getId());
                            }
                        else{

                            $rencontres[$ind_corpo][$ind_equipe] = $this->getDoctrine()
                              ->getManager()
                              ->getRepository('swsBackBundle:ChPlanning')
                              ->getrencontresEquipe($equipe->getId());
                          }

                        $ind_equipe = $ind_equipe + 1;
                      }

                    $ind_corpo = $ind_corpo + 1;
                }

               // Si le bouton listeForceXls est cliqué
               if ($request->request->get('planningXls')){

                   // Traitement des dates

                   $x = 0; // Corpo

                   foreach ($rencontres as $corpos){

                       $i = 0; // Equipe
                       foreach ($corpos as $equipe){

                           $y = 0; // Rencontres
                           foreach ($equipe as $rencontres_eq){


                               $listesRencontre[$x][$i][$y]['dateRencontre'] = $rencontres_eq['dateRencontre']->format('d-m-Y');
                               $listesRencontre[$x][$i][$y]['EquipeVisitee'] = $rencontres_eq['chequipeVisitee_id']['nom'].$rencontres_eq['chequipeVisitee_id']['numeroEquipe'].$rencontres_eq['chequipeVisitee_id']['suffixEquipe'];
                               $listesRencontre[$x][$i][$y]['CorporationVisitee'] = $rencontres_eq['chcorporationVisitee_id']['corporation_id']['nom'];

                               $listesRencontre[$x][$i][$y]['EquipeVisiteuse'] = $rencontres_eq['chequipeVisiteuse_id']['nom'].$rencontres_eq['chequipeVisiteuse_id']['numeroEquipe'].$rencontres_eq['chequipeVisiteuse_id']['suffixEquipe'];
                               $listesRencontre[$x][$i][$y]['CorporationVisiteuse'] = $rencontres_eq['chcorporationVisiteuse_id']['corporation_id']['nom'];

                               $listesRencontre[$x][$i][$y]['chsalle_id'] = $rencontres_eq['chsalle_id']['salle_id']['nom'];

                               $listesRencontre[$x][$i][$y]['corpo'] = $ChCorporations[$x]->getCorporationId()->getNomsuccinct();
                               $y = $y + 1;
                           }

                           $i = $i + 1;
                       }

                       if ($i == 0){
                           $listesRencontre[$x][$x][y]['corpo'] = $ChCorporations[$x]->getCorporationId()->getNomsuccinct();
                       }

                       $x = $x + 1;
                   }

                   // ask the service for a Excel5
                   $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();


                   $phpExcelObject->getProperties()->setCreator($this->getUser()->getNom().' '.$this->getUser()->getPrenom())
                       ->setTitle("Listes de force");

                   $y = 0;
                   foreach ($listesRencontre as $listesRencontre2){
                       foreach($listesRencontre2 as $listesRencontre3)

                       if ($y <> 0 ){
                           $phpExcelObject->createSheet($y);
                       }
                       $phpExcelObject->setActiveSheetIndex($y);
                       $phpExcelObject->getActiveSheet()
                           ->fromArray(
                               $listesRencontre3,  // The data to set
                               NULL,        // Array values with this value will not be set
                               'A1'         // Top left coordinate of the worksheet range where
                           //    we want to set these values (default is A1)
                           );

                       $phpExcelObject->getActiveSheet()->setTitle( $ChCorporations[$y]->getCorporationId()->getNomsuccinct());
                       // Set active sheet index to the first sheet, so Excel opens this as the first sheet

                       $y = $y + 1;
                   }

                   $phpExcelObject->setActiveSheetIndex(0);

                   // create the writer
                   $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
                   // create the response
                   $response = $this->get('phpexcel')->createStreamedResponse($writer);
                   // adding headers
                   $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');

                   $fileName = 'RIL_planning_corpo'.$now_format2.'.xls';
                   $sanitizer = $this->get('sanitizeFileName');
                   $sanitizer->processSanitizeFileNamle($fileName);
                   $fileName = $sanitizer->getFileName();

                   $response->headers->set('Content-Disposition', 'attachment;filename='.$fileName);
                   $response->headers->set('Pragma', 'public');
                   $response->headers->set('Cache-Control', 'maxage=1');

                   return $response;

               }

               // Si le bouton listeForcePdf est cliqué
               if ($request->request->get('planningPdf') or $request->request->get('planningPdfQr')){

                    $fileName = 'RIL_planning_corpo.pdf';
                    $sanitizer = $this->get('sanitizeFileName');
                    $sanitizer->processSanitizeFileNamle($fileName);
                    $fileName = $sanitizer->getFileName();

                    if ($request->request->get('planningPdf')){

                        $html = $this->renderView('swsBackBundle:ChRencontre:pdf.rencontres.corporation.html.twig', array(
                        'rencontres' => $rencontres,
                        'ChCorporations' => $ChCorporations,
                        'equipesCorpo' => $equipesCorpo
                        ));
                    }
                    elseif($request->request->get('planningPdfQr')){
                        $html = $this->renderView('swsBackBundle:ChRencontre:pdf.rencontres.corporation.qrcode.html.twig', array(
                            'rencontres' => $rencontres,
                            'ChCorporations' => $ChCorporations,
                            'equipesCorpo' => $equipesCorpo
                        ));
                    }

                   $url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
                       ->get('templating.helper.assets')
                       ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);

                    return new Response(
                        $this->get('knp_snappy.pdf')->getOutputFromHtml(
                            $html,
                        array('orientation'=>'Portrait',
                            'margin-left' => 4,
                            'margin-right' => 4,
                            'margin-top' => 5,
                            //'header-font-size' => 10,
                            'header-spacing' => '0',
                            /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                            'footer-font-size' => 8,
                            //'footer-line' => false,
                            'footer-left' => $now_format,
                            //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                            'footer-right' => 'P. [page]/[toPage]',
                            'footer-spacing' => '6',
                            'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                            //'footer-html' => $url_footer
                            //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                        )),
                        200,
                        array(
                            'Content-Type'          => 'application/pdf',
                            'Content-Disposition'   => 'attachment; filename='.$fileName
                        )
                    );                    
                }

                // Si le bouton listeForceHtml est cliqué
                if ($request->request->get('planningHtml')){

                    return $this->render('swsBackBundle:ChRencontre:rencontres.corporation.complete.html.twig', array(
                        'rencontres' => $rencontres,
                        'ChCorporations' => $ChCorporations,
                        'equipesCorpo' => $equipesCorpo
                    ));
                }
                // Si le bouton listeForceHtml est cliqué
                if ($request->request->get('planningHtmlQr')){

                    return $this->render('swsBackBundle:ChRencontre:rencontres.corporation.qrcode.complete.html.twig', array(
                        'rencontres' => $rencontres,
                        'ChCorporations' => $ChCorporations,
                        'equipesCorpo' => $equipesCorpo
                    ));
                }
            }

            // Gestion des listes de force
            
            else{
           
              foreach ($request->request->get('corposId') as $ChCorporationId) {

                  $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
                  $ChCorporation = $repository->find($ChCorporationId);
                  $ChCorporations[] = $ChCorporation;


                  if (!$ChCorporation) {
                      throw $this->createNotFoundException("La corporationCh avec l'identifiant ".$ChCorporationId." n'existe pas.");
                  }

                  if ($request->request->get('listeForceXls') or $request->request->get('listeForce_S_Xls') ){

                      if ($ChCorporation->getCorporationId()->getgenre() == 'F')
                      {
                      // On recupere la liste de force de la corpoCH
                      $listesForce[] = $this->getDoctrine()
                          ->getManager()
                          ->getRepository('swsBackBundle:ChJoueur')
                          ->getListeForceCorpoArray($ChCorporationId);
                      }
                      else{
                          // On recupere la liste de force de la corpoCH
                          $listesForce[] = $this->getDoctrine()
                              ->getManager()
                              ->getRepository('swsBackBundle:ChJoueur')
                              ->getListeForceCorpoDamesArray($ChCorporationId);
                      }
                  }
                  else{
                      if ($ChCorporation->getCorporationId()->getgenre() == 'F') {
                          // On recupere la liste de force de la corpoCH
                          $listesForce[] = $this->getDoctrine()
                              ->getManager()
                              ->getRepository('swsBackBundle:ChJoueur')
                              ->getListeForceCorpoDames($ChCorporationId);
                      }
                      else{
                          // On recupere la liste de force de la corpoCH
                          $listesForce[] = $this->getDoctrine()
                              ->getManager()
                              ->getRepository('swsBackBundle:ChJoueur')
                              ->getListeForceCorpo($ChCorporationId);
                      }
                  }
              }

             // Si le bouton listeForceXls est cliqué
             if ($request->request->get('listeForceXls') or $request->request->get('listeForce_S_Xls')){

                 // Traitement des dates

                 $x = 0;

                 foreach ($listesForce as $listeForce){

                     $i = 0;
                     foreach ($listeForce as $joueur){

                         $listesForce2[$x][$i]['nom'] = $joueur['joueur_id']['nom'];
                         $listesForce2[$x][$i]['prenom'] = $joueur['joueur_id']['prenom'];
                         $listesForce2[$x][$i]['telPrive'] = $joueur['joueur_id']['telPrive'];
                         $listesForce2[$x][$i]['gsmPrive'] = $joueur['joueur_id']['gsmPrive'];
                         $listesForce2[$x][$i]['numAFT'] = $joueur['joueur_id']['numAft'];
                         $listesForce2[$x][$i]['dateNaissance'] = $joueur['joueur_id']['dateNaissance']->format('d-m-Y');
                         $listesForce2[$x][$i]['classementRil'] = $joueur['chclassementRil_id']['classement'];
                         $listesForce2[$x][$i]['valeur'] = $joueur['chclassementRil_id']['valeur'];

                         $listesForce2[$x][$i]['classementRilMixte'] = $joueur['chclassementRilMixte_id']['classement'];
                         $listesForce2[$x][$i]['valeurMixte'] = $joueur['chclassementRilMixte_id']['valeur'];

                         if ($joueur['desactive'] == '1' ){

                             $listesForce2[$x][$i]['desactive'] = 'Non qualifie';
                         }
                         else
                         {
                             $listesForce2[$x][$i]['desactive'] = 'Qualifié';
                         }

                         $listesForce2[$x][$i]['corpo'] = $ChCorporations[$x]->getCorporationId()->getNomsuccinct();

                         // Données signalétiques //

                         $listesForce2[$x][$i]['sexe'] = $joueur['joueur_id']['sexe'];
                         $listesForce2[$x][$i]['emailPro'] = $joueur['joueur_id']['emailPro'];
                         $listesForce2[$x][$i]['emailPrive'] = $joueur['joueur_id']['emailPrive'];
                         $listesForce2[$x][$i]['gsmPro'] = $joueur['joueur_id']['gsmPro'];
                         $listesForce2[$x][$i]['gsmPrive'] = $joueur['joueur_id']['gsmPrive'];
                         $listesForce2[$x][$i]['telPro'] = $joueur['joueur_id']['telPro'];
                         $listesForce2[$x][$i]['telPrive'] = $joueur['joueur_id']['telPrive'];
                         $listesForce2[$x][$i]['rue'] = $joueur['joueur_id']['rue'];
                         $listesForce2[$x][$i]['numRue'] = $joueur['joueur_id']['numRue'];
                         $listesForce2[$x][$i]['boiteNumero'] = $joueur['joueur_id']['boiteNumero'];

                         $listesForce2[$x][$i]['codePostal'] = $joueur['joueur_id']['codePostal'];
                         $listesForce2[$x][$i]['commune'] = $joueur['joueur_id']['commune'];
                         $listesForce2[$x][$i]['numClubAft'] = $joueur['joueur_id']['numClubAft'];
                         $listesForce2[$x][$i]['nomClubAft'] = $joueur['joueur_id']['nomClubAft'];
                         $listesForce2[$x][$i]['updatedAt'] = $joueur['joueur_id']['updatedAt']->format('d-m-Y');

                         //dump($joueur);
                         //die;
                         $listesForce2[$x][$i]['user'] = $joueur['joueur_id']['user']['prenom'].' '.$joueur['joueur_id']['user']['nom'];


                         $i = $i + 1;
                     }

                     if ($i == 0){
                         $listesForce2[$x][$x]['corpo'] = $ChCorporations[$x]->getCorporationId()->getNomsuccinct();
                     }


                     $x = $x + 1;
                 }

                 // ask the service for a Excel5
                 $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();


                 $phpExcelObject->getProperties()->setCreator($this->getUser()->getNom().' '.$this->getUser()->getPrenom())
                     ->setTitle("Listes de force");

                 $y = 0;
                 $nbLines = 1;
                 foreach ($listesForce2 as $listeForce3){


                     if ($y <> 0 and !$request->request->get('listeForce_S_Xls') ){
                         $phpExcelObject->createSheet($y);
                         $phpExcelObject->setActiveSheetIndex($y);
                     }

                     $phpExcelObject->getActiveSheet()
                         ->fromArray(
                             $listeForce3,  // The data to set
                             NULL,        // Array values with this value will not be set
                             'A'.$nbLines         // Top left coordinate of the worksheet range where
                         //    we want to set these values (default is A1)
                         );

                     if ($request->request->get('listeForce_S_Xls')) {
                         $nbLines = $nbLines + count($listeForce3);
                     }

                     if (!$request->request->get('listeForce_S_Xls')){
                         $phpExcelObject->getActiveSheet()->setTitle( $ChCorporations[$y]->getCorporationId()->getNomsuccinct());
                     }

                     $y = $y + 1;
                 }

                 $phpExcelObject->setActiveSheetIndex(0);

                 // create the writer
                 $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel5');
                 // create the response
                 $response = $this->get('phpexcel')->createStreamedResponse($writer);
                 // adding headers
                 $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');

                 $fileName = 'RIL_listes_de_force_'.$now_format2.'.xls';
                 $sanitizer = $this->get('sanitizeFileName');
                 $sanitizer->processSanitizeFileNamle($fileName);
                 $fileName = $sanitizer->getFileName();

                 $response->headers->set('Content-Disposition', 'attachment;filename='.$fileName);
                 $response->headers->set('Pragma', 'public');
                 $response->headers->set('Cache-Control', 'maxage=1');

                 return $response;

             }

             // Si le bouton listeForcePdf est cliqué
             if ($request->request->get('listeForcePdf')){

                  $fileName = 'RIL_listes_force.pdf';
                  $sanitizer = $this->get('sanitizeFileName');
                  $sanitizer->processSanitizeFileNamle($fileName);
                  $fileName = $sanitizer->getFileName();

                 $html = $this->renderView('swsBackBundle:ChCorporation:pdf.liste2.force.html.twig', array(
                     'listesForce' => $listesForce,
                     'ChCorporations' => $ChCorporations
                 ));

                 $url_footer =  $request->getScheme() . '://' . $request->getHttpHost() . $request->getBasePath() . $this
                         ->get('templating.helper.assets')
                         ->getUrl('/bundles/swsback/css/print/footer.html', $packageName = null);

                  return new Response(
                    $this->get('knp_snappy.pdf')->getOutputFromHtml(
                        $html,
                        array('orientation'=>'Portrait',
                            'margin-left' => 4,
                            'margin-right' => 4,
                            'margin-top' => 5,
                            //'header-font-size' => 10,
                            'header-spacing' => '0',
                            /*'header-right' => 'RILTennis - '.$ChCorporation->getChampionnatId()->getNom(),*/

                            'footer-font-size' => 8,
                            //'footer-line' => false,
                            'footer-left' => $now_format,
                            //'footer-center' => 'CONTACT: comite@riltennis.org | 04 289 02 55 | www.riltennis.org',
                            'footer-right' => 'P. [page]/[toPage]',
                            'footer-spacing' => '6',
                            'footer-center' => "RILTENNIS - ASBL REGIONNALLE INTERCORPORATIVE LIEGEOISE DE TENNIS (CLUB AFT 4021)"
                            //'footer-html' => $url_footer
                            //'header-html' => 'http://easysports/bundles/swsback/css/print/header.html'
                        )),
                    200,
                    array(
                        'Content-Type'          => 'application/pdf',
                        'Content-Disposition'   => 'attachment; filename='.$fileName
                    )
                );               
              }

              // Si le bouton listeForceHtml est cliqué
              if ($request->request->get('listeForceHtml')){

                  return $this->render('swsBackBundle:ChCorporation:liste2.force.complete.html.twig', array(
                      'listesForce' => $listesForce,
                      'ChCorporations' => $ChCorporations
                  ));
                  
                  /*return $this->render('swsBackBundle:PrintPackage:package.html.twig', array(
                      'listesForce' => $listesForce,
                      'ChCorporations' => $ChCorporations
                  ));*/
              }
            }  
        }
   }

}

