<?php

/**
 * Fichier: ChContrainteController.php
 *
 * Easy-Sports.net
 * Controleur de l'entité chContrainte
 *
 *
 * PHP version 5
 *
 * @package    Easysports
 * @subpacakge Administration section
 * @category   Classes
 * @author     benbet <info@siteweb-service.be>
 * @copyright  2015 Siteweb-Service
 * @link       http://www.easy-sports.net
 * @version    Version 1.0
 */

namespace sws\Bundle\BackBundle\Controller;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChContrainte;
use sws\Bundle\BackBundle\Entity\ChContrainteSalle;
use sws\Bundle\BackBundle\Entity\Corporation;
use sws\Bundle\BackBundle\Form\Handler\ChContraintePeriodeHandler;
use sws\Bundle\BackBundle\Form\Type\ChContraintePeriodeType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChContrainteJourType;
use sws\Bundle\BackBundle\Form\Handler\ChContrainteJourHandler;
use sws\Bundle\BackBundle\Form\Type\ChContrainteSalleType;
use sws\Bundle\BackBundle\Form\Handler\ChContrainteSalleHandler;
use sws\Bundle\BackBundle\Form\Type\ChContrainteVacancesScolairesType;
use sws\Bundle\BackBundle\Form\Handler\ChContrainteVacancesScolairesHandler;
use sws\Bundle\BackBundle\Form\Handler\ChContraintePeriodeSalleHandler;
use sws\Bundle\BackBundle\Form\Type\ChContraintePeriodeSalleType;


class ChContrainteController extends Controller
{

    /**
     * Fonction __construct
     */
    public function __construct()
    {
        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'corporation');
    }


    /**
     * Affiche une entité Championnat
     *
     * @param int $id Valeur de l'identification de la Championnat
     * @param Request $request Contenu de la requête HTTP
     *
     * @return form vers la template swsBackBundle:Championnat:view.html.twig
     */
    public function listAction($idChampionnat, $idCorpoCh, $idEquipeCh, Request $request)
    {

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

       if (!$ChParametres) {
            throw $this->createNotFoundException("Les ChParametres avec pour le championnat ".$idChampionnat." n'existe pas.");
        }

        $repCorporationCh = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');

        // On recupère la corporationCH
        $ChCorporation = $repCorporationCh->find($idCorpoCh);

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repCorporation = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Corporation');

        // On recupère la Corporation
        $Corporation = $repCorporation->findOneById($ChCorporation->getCorporationId());

        if (!$ChCorporation) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repEquipe = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');

        // On recupère l'équipeCH
        $ChEquipe = $repEquipe->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
        }

        // On recupere les contraintes associés à l'équipeCH
        $ChContrainte = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChContrainte')
            ->getChContrainte($idEquipeCh);

        return $this->render('swsBackBundle:ChContrainte:list.html.twig',array(
            'Championnat' => $Championnat,
            'ChCorporation' => $ChCorporation,
            'ChContraintes' => $ChContrainte,
            'Corporation' => $Corporation,
            'ChEquipe' => $ChEquipe,
            'ChParametres' => $ChParametres
            )
        );

    }


    /**
     * Crée une entité Chcontrainte de type Jour
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:chcontrainte:create.html.twig
     */
    public function contrainteJourCreateAction($idChampionnat, $idCorpoCh, $idEquipeCh, Request $request)
    {
        $formHandler = new ChContrainteJourHandler($this->createForm(new ChContrainteJourType(), new ChContrainte()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorpoCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corpoCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe = $repository->find($idEquipeCh);

            if (!$ChEquipe) {
                throw $this->createNotFoundException("L'équipeCH      avec l'identifiant ".$idEquipeCh." n'existe pas.");
            }            

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);
 
            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }

   /**
     * Crée une entité Chcontrainte de type Salle
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:chcontrainte:create.html.twig
     */
    public function contrainteSalleCreateAction($idChampionnat, $idCorpoCh, $idEquipeCh, Request $request)
    {
        $formHandler = new ChContrainteSalleHandler($this->createForm(new ChContrainteSalleType(array('idChampionnat' => $idChampionnat)), new ChContrainte()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorpoCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corpoCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe = $repository->find($idEquipeCh);

            if (!$ChEquipe) {
                throw $this->createNotFoundException("L'équipeCH      avec l'identifiant ".$idEquipeCh." n'existe pas.");
            }            

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);
 
            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }    

    /**
     * Supprime une entité ChContrainte
     *
     * Avant de supprimer le championnat, il faut s'assurer que rien n'a été généré pour cette contrainte :
     *  1) Locations
     *  2) ...
     *  3) ...
     *
     * @param int $id Valeur de l'identification de la contrainte du Championnat à supprimer
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_manager_championnat
     */
    public function deleteAction($idChampionnat, $idCorpoCh, $idEquipeCh, $idContrainteCh)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainte');
        $ContrainteCh = $repository->find($idContrainteCh);

        if (!$ContrainteCh) {
            throw $this->createNotFoundException("La contrainteCH avec l'identifiant ".$idContrainteCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($ContrainteCh);
        $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));

    }

    /**
     * Modifie une entité ChContrainte de type Jour
     *
     * @param int $id Valeur de l'identification du contrainte
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:ChContrainte:modify.html.twig
     */
    public function contrainteJourModifyAction($idChampionnat,$idCorpoCh, $idEquipeCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $ChCorporation = $repository->find($idCorpoCh);

        if (!$Championnat) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainte');
        $ChContrainte = $repository->find($id);

        if (!$ChContrainte) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$IdEquipeCh." n'existe pas.");
        }        

        $formHandler = new ChContrainteJourHandler($this->createForm(new ChContrainteJourType(), $ChContrainte), $request);

        if ($formHandler->verification()) {

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    /**
     * Modifie une entité ChContrainte de type Salle
     *
     * @param int $id Valeur de l'identification du contrainte
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:ChContrainte:modify.html.twig
     */
        public function contrainteSalleModifyAction($idChampionnat,$idCorpoCh, $idEquipeCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $ChCorporation = $repository->find($idCorpoCh);

        if (!$Championnat) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainte');
        $ChContrainte = $repository->find($id);

        if (!$ChContrainte) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$IdEquipeCh." n'existe pas.");
        }        

        $formHandler = new ChContrainteSalleHandler($this->createForm(new ChContrainteSalleType((array('idChampionnat' => $idChampionnat))), $ChContrainte), $request);

        if ($formHandler->verification()) {

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    /**
     * Crée une entité Chcontrainte de type Salle
     *
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:chcontrainte:create.html.twig
     */
    public function contraintePeriodeCreateAction($idChampionnat, $idCorpoCh, $idEquipeCh, Request $request)
    {
        $formHandler = new ChContraintePeriodeHandler($this->createForm(new ChContraintePeriodeType(array('idChampionnat' => $idChampionnat)), new ChContrainte()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorpoCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corpoCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe = $repository->find($idEquipeCh);

            if (!$ChEquipe) {
                throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
            }

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }

    /**
     * Modifie une entité ChContrainte de type Periode
     *
     * @param int $id Valeur de l'identification du contrainte
     * @param Request $request Contenu de la requête HTTP
     *
     * @return route sws_back_listchcontrainte
     * @return form vers la template swsBackBundle:ChContrainte:modify.html.twig
     */
    public function contraintePeriodeModifyAction($idChampionnat,$idCorpoCh, $idEquipeCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $ChCorporation = $repository->find($idCorpoCh);

        if (!$Championnat) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainte');
        $ChContrainte = $repository->find($id);

        if (!$ChContrainte) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$IdEquipeCh." n'existe pas.");
        }

        $formHandler = new ChContraintePeriodeHandler($this->createForm(new ChContraintePeriodeType((array('idChampionnat' => $idChampionnat))), $ChContrainte), $request);

        if ($formHandler->verification()) {

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }

    public function listContrainteSalleAction($idChampionnat, $idSalle, Request $request)
    {

        $repChampionnat = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');

        // On recupère le championnat
        $Championnat = $repChampionnat->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // On recupere les paramètres du championnat
        $ChParametres = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChParametres')
            ->getChParametres($idChampionnat);

        if (!$ChParametres) {
            throw $this->createNotFoundException("Les ChParametres avec pour le championnat " . $idChampionnat . " n'existe pas.");
        }

        $repSalleCh = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');

        // On recupère la corporationCH
        $ChSalle = $repSalleCh->find($idSalle);

        if (!$ChSalle) {
            throw $this->createNotFoundException("La salleCH avec l'identifiant " . $idSalle . " n'existe pas.");
        }

        // On recupere les contraintes associés à la salleCH
        $ChContrainte = $this->getDoctrine()
            ->getManager()
            ->getRepository('swsBackBundle:ChContrainteSalle')
            ->getChContrainteSalle($idSalle);

        return $this->render('swsBackBundle:ChContrainteSalle:list.html.twig', array(
                'Championnat' => $Championnat,
                'ChSalle' => $ChSalle,
                'ChContraintes' => $ChContrainte,
                'ChParametres' => $ChParametres
            )
        );
    }

        public function contrainteSallePeriodeCreateAction($idChampionnat, $idSalle, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $ChSalle = $repository->find($idSalle);

        if (!$ChSalle) {
            throw $this->createNotFoundException("La salleCH avec l'identifiant ".$idSalle." n'existe pas.");
        }

        $formHandler = new ChContraintePeriodeSalleHandler($this->createForm(new ChContraintePeriodeSalleType(array('idChampionnat' => $idChampionnat)), new ChContrainteSalle()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }
            // On recupere les paramètres du championnat
            $ChParametres = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChParametres')
                ->getChParametres($idChampionnat);



            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChsalleId($ChSalle);
            $contrainte->setChampionnatId($Championnat);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            // On recupere les contraintes associés à la salleCH
            $ChContrainte = $this->getDoctrine()
                ->getManager()
                ->getRepository('swsBackBundle:ChContrainteSalle')
                ->getChContrainteSalle($idSalle);

            return $this->redirect($this->generateUrl('sws_back_listchcontrainteSalle', array(
                    'idChampionnat' => $idChampionnat,
                    'idSalle' => $idSalle
                )
            ));
        }

        return $this->render('swsBackBundle:ChContrainteSalle:create.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'ChSalle' => $ChSalle
        ));
    }

    public function contrainteSallePeriodeModifyAction($idChampionnat, $idSalle, $idContrainteCh, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChSalle');
        $ChSalle = $repository->find($idSalle);

        if (!$ChSalle) {
            throw $this->createNotFoundException("La salleCH avec l'identifiant ".$idSalle." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainteSAlle');
        $ChContrainteSalle = $repository->find($idContrainteCh);

        if (!$ChContrainteSalle) {
            throw $this->createNotFoundException("Le contrainteSalleCH avec l'identifiant ".$idContrainteCh." n'existe pas.");
        }

        $formHandler = new ChContraintePeriodeSalleHandler($this->createForm(new ChContraintePeriodeSalleType((array('idChampionnat' => $idChampionnat))), $ChContrainteSalle), $request);

        if ($formHandler->verification()) {

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChSalleId($ChSalle);
            $contrainte->setChampionnatId($Championnat);


            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainteSalle', array(
                    'idChampionnat' => $idChampionnat,
                    'idSalle' => $idSalle
                )
            ));
        }

        return $this->render('swsBackBundle:ChContrainteSalle:modify.html.twig',array(
            'form' => $formHandler->getForm()->createView(),
            'ChSalle' => $ChSalle
        ));

    }

    public function contrainteSallePeriodeDeleteAction($idChampionnat, $idSalle, $idContrainteCh, Request $request)
    {

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainteSalle');
        $ContrainteCh = $repository->find($idContrainteCh);

        if (!$ContrainteCh) {
            throw $this->createNotFoundException("La contrainteSalleCH avec l'identifiant ".$idContrainteCh." n'existe pas.");
        }

        $em = $this->getDoctrine()->getEntityManager();
        $em->remove($ContrainteCh);
        $em->flush();

        return $this->redirect($this->generateUrl('sws_back_listchcontrainteSalle', array(
                'idChampionnat' => $idChampionnat,
                'idSalle' => $idSalle
            )
        ));
    }
    
    public function contrainteVacancesScolairesCreateAction($idChampionnat, $idCorpoCh, $idEquipeCh, Request $request)
    {
        $formHandler = new ChContrainteVacancesScolairesHandler($this->createForm(new ChContrainteVacancesScolairesType(), new ChContrainte()), $request);

        if ($formHandler->verification()) {

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
            $Championnat = $repository->find($idChampionnat);

            if (!$Championnat) {
                throw $this->createNotFoundException("Le championnat avec l'identifiant ".$idChampionnat." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
            $ChCorporation = $repository->find($idCorpoCh);

            if (!$ChCorporation) {
                throw $this->createNotFoundException("La corpoCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
            }

            $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
            $ChEquipe = $repository->find($idEquipeCh);

            if (!$ChEquipe) {
                throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$idEquipeCh." n'existe pas.");
            }            

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);
 
            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:create.html.twig',array(
            'form' => $formHandler->getForm()->createView()
        ));

    }    
    
    public function contrainteVacancesScolairesModifyAction($idChampionnat,$idCorpoCh, $idEquipeCh, $id, Request $request)
    {
        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:Championnat');
        $Championnat = $repository->find($idChampionnat);

        if (!$Championnat) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$Championnat." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChCorporation');
        $ChCorporation = $repository->find($idCorpoCh);

        if (!$Championnat) {
            throw $this->createNotFoundException("La corporationCH avec l'identifiant ".$idCorpoCh." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChContrainte');
        $ChContrainte = $repository->find($id);

        if (!$ChContrainte) {
            throw $this->createNotFoundException("Le contrainteCH avec l'identifiant ".$id." n'existe pas.");
        }

        $repository = $this->getDoctrine()->getManager()->getRepository('swsBackBundle:ChEquipe');
        $ChEquipe = $repository->find($idEquipeCh);

        if (!$ChEquipe) {
            throw $this->createNotFoundException("L'équipeCH avec l'identifiant ".$IdEquipeCh." n'existe pas.");
        }        

        $formHandler = new ChContrainteVacancesScolairesHandler($this->createForm(new ChContrainteVacancesScolairesType(), $ChContrainte), $request);

        if ($formHandler->verification()) {

            $contrainte = $formHandler->getForm()->getData();
            $contrainte->setUser($this->getUser());
            $contrainte->setChcorporationId($ChCorporation);
            $contrainte->setChampionnatId($Championnat);
            $contrainte->setChEquipeId($ChEquipe);

            $em = $this->getDoctrine()->getEntityManager();
            $em-> persist($contrainte);
            $em->flush();

            return $this->redirect($this->generateUrl('sws_back_listchcontrainte', array(
                'idChampionnat' => $idChampionnat,
                'idCorpoCh' => $idCorpoCh,
                'idEquipeCh' => $idEquipeCh
            )));
        }

        return $this->render('swsBackBundle:ChContrainte:modify.html.twig',array('form' => $formHandler->getForm()->createView()));
    }    


}

