<?php

namespace sws\Bundle\BackBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;

use Doctrine\ORM\EntityNotFoundException;
use sws\Bundle\BackBundle\Entity\Championnat;
use sws\Bundle\BackBundle\Entity\ChJoueurPtsSimple;
use sws\Bundle\BackBundle\Entity\ChJoueurPtsDouble;
use sws\Bundle\BackBundle\Entity\ChPlanning;
use sws\Bundle\BackBundle\Entity\Corporation;
use sws\Bundle\BackBundle\Entity\ChRencontreReject;
use sws\Bundle\BackBundle\Entity\ChSimples;
use sws\Bundle\BackBundle\Entity\ChDoubles;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use sws\Bundle\BackBundle\Form\Type\ChPlanningType;
use sws\Bundle\BackBundle\Form\Type\ChPlanningJourType;
use sws\Bundle\BackBundle\Form\Type\ChPlanningSlotType;
use sws\Bundle\BackBundle\Form\Type\ChSimplesType;
use sws\Bundle\BackBundle\Form\Type\ChDoubleType;
use sws\Bundle\BackBundle\Form\Type\ChRencontreRejectSlotType;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningHandler;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningJourHandler;
use sws\Bundle\BackBundle\Form\Handler\ChSimplesHandler;
use sws\Bundle\BackBundle\Form\Handler\ChDoubleHandler;
use sws\Bundle\BackBundle\Form\Handler\ChPlanningSlotHandler;
use sws\Bundle\BackBundle\Form\Handler\ChRencontreRejectSlotHandler;
use Symfony\Component\HttpFoundation\Response;

class GeneratePlanningCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
        // the name of the command (the part after "app/console")
        ->setName('app:generate-planning')

        // the short description shown while running "php app/console list"
        ->setDescription('Génere le planning d un championnat')

        // the full command description shown when running the command with
        // the "--help" option
        ->setHelp('Cette commande génére le planning d un championnat en fonction des donnée introduites (salles, corporation, équipe, division...')
        ->addArgument('idChampionnat', InputArgument::REQUIRED, 'L identifiant (id) du championnat pour lequel il faut générer le planning')
       ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $idChampionnat= $input->getArgument('idChampionnat');
        
        $session = new Session();
        $session->set('progress', 0);
        
        // 1. Vérification si des rencontres existent pour le championnat

        $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChPlanning');
        $ChPlanning = $repository->findOneBy(array('championnat_id' => $idChampionnat));

        if ($ChPlanning) {
            // Si au moins une rencontre est trouvée --> erreur
            throw new \Exception('Il existe déjà un planning pour ce championnat !');
        }

        // 2. Chargement du championnat
        $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:Championnat');
        $championnat = $repository->find($idChampionnat);

        if (!$championnat) {
            throw $this->createNotFoundException("Le Championnat avec l'identifiant " . $idChampionnat . " n'existe pas.");
        }

        // 3. Chargement des divisions du championnat
        $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChDivision');
        $ChDivisions = $repository->findby(array('championnat_id' => $idChampionnat));

        if (!$ChDivisions) {
            throw $this->createNotFoundException("Aucune division n'a été trouvée pour le championnat avec l'identifiant: " . $idChampionnat);
        }

        // 4. Chargement des locations du championnat
        $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChLocation');
        $ChLocations = $repository->findby(array('championnat_id' => $idChampionnat));

        if (!$ChLocations) {
            throw $this->createNotFoundException("Aucune location n'a été trouvée pour le championnat avec l'identifiant: " . $idChampionnat);
        }

		$session->set('progress', 5);


        // 5. Chargement des slots du championnat via le service slotsChampionnat

        $slotsChampionnat = $this->getContainer()->get('slotsChampionnat');
        $slotsChampionnat->processSlots($championnat, $ChLocations);
        $slots_championnat = $slotsChampionnat->getSlots();

        if (!$slots_championnat) {
            throw $this->createNotFoundException("Aucun slot horaire trouvé pour le championnat");
        }


        foreach ($ChDivisions as $keys => $var) {

            $nomDivision = $var->getNom() . ' ' . $var->getNumero() . ' ' . $var->getSuffixe();
            $chDivisionsId = $var->getId();

            // 6. Chargement des équipes par division

            $Chequipes[$nomDivision] = $this->getContainer()->get('doctrine')->getManager()
                ->getRepository('swsBackBundle:ChEquipe')
                ->getChEquipesForOneDivision($var->getId());
        }

        $session->set('progress', 10);

    $nbDivIter = 0;
    $nbEqVisitee = 0;
    $nbEqVisiteuse = 0;
    $nbDivision = count($Chequipes);
    $indice = 0;
	
        foreach ($Chequipes as $key1 => $equipe1) {     // Niveau Division
        
            foreach ($equipe1 as $key2 => $var1) {       // Niveau équipe visitée

                $nbEqVisitee++;

                foreach ($equipe1 as $key3 => $var2) {   // Niveau équipe visiteuse

                    $nbEqVisiteuse++;
                    $nbEquipe = count($equipe1);

                    if ($key2 < $key3) // Une équipe ne se rencontre pas elle-même
                    {

                        // Definir le nombre de contrainte pour l'équipe 1
                        /*
                        $nbContrainteEq1 = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChContrainte')
                            ->getChEquipesNbContraintes($var1->getId());
                        */

                        // Definir le nombre de contrainte pour l'équipe 2
                        /*
                        $nbContrainteEq2 = $this->getDoctrine()
                            ->getManager()
                            ->getRepository('swsBackBundle:ChContrainte')
                            ->getChEquipesNbContraintes($var2->getId());
                        */

                        $nbContrainteEq1 = count($var1->getChequipesId());
                        $nbContrainteEq2 = count($var2->getChequipesId());

                        // Combien de tour définit pour la division ?
                        $nbTours = $var1->getChdivisionId()->getNbTours();

                        $tour = 1;
                        

                        do {

                            //$indice = $tour.$nbEqVisiteuse.$nbEqVisitee.$nbDivIter.($nbEqVisiteuse + $nbEquipe);

                            if ($tour % 2 == 0) { // Si n° du tour est pair
                                // Definir les rencontres "allées" des divisions

                                $rencontresAller[] = (object)array(

                                    "nomDivision" => $key1,
                                    "championnatId" => $var1->getChampionnatId()->getId(),
                                    "chDivisionsId" => $var1->getChdivisionId(),

                                    "chEquipe1Id" => $var1->getId(),                // 1
                                    "nomEquipe1" => $var1->getNom(),                // 1
                                    "numeroEquipe1" => $var1->getNumeroEquipe(),    // 1
                                    "suffixeEquipe1" => $var1->getSuffixEquipe(),   // 1
                                    "corposEquipe1" => $var1->getChcorporationId(), // 1

                                    "chEquipe2Id" => $var2->getId(),                // 2
                                    "nomEquipe2" => $var2->getNom(),                // 2
                                    "numeroEquipe2" => $var2->getNumeroEquipe(),    // 2
                                    "suffixeEquipe2" => $var2->getSuffixEquipe(),   // 2
                                    "corposEquipe2" => $var2->getChcorporationId(), // 2
                                    "nbContraintes" => $nbContrainteEq1 + $nbContrainteEq2

                                );

                            } else {
                                // Définir les rencontres "retour" des divisions

                                $rencontresRetour[] = (object)array(

                                    "nomDivision" => $key1,
                                    "championnatId" => $var1->getChampionnatId()->getId(),
                                    "chDivisionsId" => $var1->getChdivisionId(),

                                    "chEquipe1Id" => $var2->getId(),                  // 2
                                    "nomEquipe1" => $var2->getNom(),                  // 2
                                    "numeroEquipe1" => $var2->getNumeroEquipe(),      // 2
                                    "suffixeEquipe1" => $var2->getSuffixEquipe(),     // 2
                                    "corposEquipe1" => $var2->getChcorporationId(),   // 2

                                    "chEquipe2Id" => $var1->getId(),                  // 1
                                    "nomEquipe2" => $var1->getNom(),                  // 1
                                    "numeroEquipe2" => $var1->getNumeroEquipe(),      // 1
                                    "suffixeEquipe2" => $var1->getSuffixEquipe(),     // 1
                                    "corposEquipe2" => $var1->getChcorporationId(),   // 1
                                    "nbContraintes" => $nbContrainteEq1 + $nbContrainteEq2
                                );

                            }

                            $tour++;

                        } while ($tour <= $nbTours);
                    }
                }
            }
        }

        $session->set('progress', 20);

        if (!isset($rencontresAller)) {
            throw $this->createNotFoundException("Aucune équipe trouvée pour le championnat");
        }

        // 7. Insertion des slots horaire du championnat

        $em = $this->getContainer()->get('doctrine')->getEntityManager();
        $em->getConnection()->beginTransaction();

        foreach ($slots_championnat as $keys => $date) {

            foreach ($date as $keys0 => $salle) {

                foreach ($salle as $keys1 => $var) {

                    $rencontre = new ChPlanning();
                    $rencontre->setChampionnatId($var->getChampionnatId());
                    $rencontre->setChsalleId($var->getChsalleId());
                    $rencontre->setDateRencontre(date_create_from_format('Y-m-d', $keys));
                    $rencontre->setStatus('-');
                    

                    $em->persist($rencontre);
                    $em->flush();
                }
            }
        }

        $session->set('progress', 30);
        
        
        // Traitement des tableaux de rencontres (optimisation de la génération du championnat)
        
        $eq1 = '';
        $eq2 = '';
        $eq3 = '';
        $eq4 = '';
        $eq5 = '';
        $eq6 = '';
        $eq7 = '';
        $eq8 = '';        
        $nb = 0;
        $increment = 0;
        $sw1 = 0;
        $sw2 = 0;
        $swContrainte = 1;
        
        do{
        
	        foreach ($rencontresAller as $keys1 => $renc) {
	        
	       	
	        	if (
                    (
                        ($renc->chEquipe1Id == $eq1 or $renc->chEquipe1Id == $eq2 or $renc->chEquipe1Id == $eq3 or $renc->chEquipe1Id == $eq4 or $renc->chEquipe1Id == $eq5 or $renc->chEquipe1Id == $eq6 or $renc->chEquipe1Id == $eq7 or $renc->chEquipe1Id == $eq8)
                    or
                        ($renc->chEquipe2Id == $eq2 or $renc->chEquipe2Id == $eq1 or $renc->chEquipe2Id == $eq3 or $renc->chEquipe2Id == $eq4 or $renc->chEquipe2Id == $eq5 or $renc->chEquipe2Id == $eq6 or $renc->chEquipe2Id == $eq7 or $renc->chEquipe2Id == $eq8)
                    )
                    and ($nb <= 2)) {
	        	
	        	$nb++;
	        	
	        	}
	        	else{
	        	
	        		if (($swContrainte == 1 and $renc->nbContraintes > 0 ) or  $swContrainte == 0){
	        		

			            $rencontresAllerOpt[] = $renc;
		            	    unset($rencontresAller[$keys1]);

		                    if ($increment % 2 == 0){
                    
                		    	if ($sw1 == 0){
			                    	$eq3 = $renc->chEquipe1Id;
			                        $eq4 = $renc->chEquipe2Id;
			                        $sw1 = 1;                    	
		                    	}
                		    	else{
			                    	$eq7 = $renc->chEquipe1Id;
			                        $eq8 = $renc->chEquipe2Id;
			                        $sw1 = 0;                                     	
		                    	}

                        	   }
		                   else{
                    
	        	            if ($sw2 == 0){
	                    
	                       		 $eq1 = $renc->chEquipe1Id;
	                        	 $eq2 = $renc->chEquipe2Id;
	 	                         $sw2 = 1; 
	 	                    }
		                    else{
		                        $eq5 = $renc->chEquipe1Id;
	        	                $eq6 = $renc->chEquipe2Id;
	                	        $sw2 = 0;                     
	                    	    }

		               }

                	       $nb = 0;
                               $increment++;
                              }
	        	}

	        }
	        
	        $swContrainte = 0;
	  }while(count($rencontresAller) != 0);

        $session->set('progress', 40);

        $eq1 = '';
        $eq2 = '';
        $eq3 = '';
        $eq4 = '';
        $eq5 = '';
        $eq6 = '';
        $eq7 = '';
        $eq8 = '';         
        $nb = 0;
        $increment = 0;
        $sw1 = 0;
        $sw2 = 0;   
        $swContrainte = 1;    
        
        do{

	        foreach ($rencontresRetour as $keys1 => $renc) {


	        	if (
                    (
                        ($renc->chEquipe1Id == $eq1 or $renc->chEquipe1Id == $eq2 or $renc->chEquipe1Id == $eq3 or $renc->chEquipe1Id == $eq4 or $renc->chEquipe1Id == $eq5 or $renc->chEquipe1Id == $eq6 or $renc->chEquipe1Id == $eq7 or $renc->chEquipe1Id == $eq8)
                    or
                        ($renc->chEquipe2Id == $eq2 or $renc->chEquipe2Id == $eq1 or $renc->chEquipe2Id == $eq3 or $renc->chEquipe2Id == $eq4 or $renc->chEquipe2Id == $eq5 or $renc->chEquipe2Id == $eq6 or $renc->chEquipe2Id == $eq7 or $renc->chEquipe2Id == $eq8)
                    )
                    and ($nb <= 2)) {
	        	
	        	$nb++;
	        	
	        	}
	        	else{
	        	
	        	if (($swContrainte == 1 and $renc->nbContraintes > 0 ) or  $swContrainte == 0){
		            $rencontresRetourOpt[] = $renc;
		            unset($rencontresRetour[$keys1]);

                    if ($increment % 2 == 0){
                    
                    	if ($sw1 == 0){
                    	$eq3 = $renc->chEquipe1Id;
                        $eq4 = $renc->chEquipe2Id;
                        $sw1 = 1;                    	
                    	}
                    	else{
                    	$eq7 = $renc->chEquipe1Id;
                        $eq8 = $renc->chEquipe2Id;
                        $sw1 = 0;                                     	
                    	}

                        

                    }
                    else{
                    
	                    if ($sw2 == 0){
	                    
	                        $eq1 = $renc->chEquipe1Id;
	                        $eq2 = $renc->chEquipe2Id;
	                        $sw2 = 1; 
	                    }
	                    else{
	                        $eq5 = $renc->chEquipe1Id;
	                        $eq6 = $renc->chEquipe2Id;
	                        $sw2 = 0;                     
	                    }

                    }

                    $nb = 0;
                    $increment++;
                    }
	        	}
	        }
	        
	         $swContrainte = 0;
	  }while(count($rencontresRetour) != 0);

        $session->set('progress', 50);
        


        // Ordonner aléatoirement le contenu de $rencontresAller et $rencontresRetour (pour ne pas avoir un planning séquentiel des corporations

        //shuffle($rencontresAller);
        //shuffle($rencontresRetour);
        
        //8. Traitement des rencontres
        $nb_reject = 0;
        $nb_Updated = 0;

        $traitement = 1;
        do {

            if ($traitement == 1) {
                $rencontreAtraiter = $rencontresAllerOpt;
            } else {
                $rencontreAtraiter = $rencontresRetourOpt;
            }

            foreach ($rencontreAtraiter as $keys1 => $renc) {

                $sw_debut_championnat_eq1 = 0;
                $sw_debut_championnat_eq2 = 0;

                // Definir la date de la dernière rencontre de l'équipe 1
                $dateRencontreEq1 = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getMaxDateRencontreEquipe($renc->chEquipe1Id, $championnat->getId());

                if ($dateRencontreEq1 == null) {

                    $dateRencontreEq1 = date_format($championnat->getDateDebut(), 'Y-m-d');
                    $date_temp = strtotime($dateRencontreEq1);
                    $date_temp = strtotime('-5 days', $date_temp); // On retire 5 jours pour s'aligner sur la bonne date de début dans les process suivants
                    $dateRencontreEq1 = date('Y-m-d', $date_temp);
                    $sw_debut_championnat_eq1 = 1;
                }

                // Definir la date de la dernière rencontre de l'équipe 2
                $dateRencontreEq2 = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getMaxDateRencontreEquipe($renc->chEquipe2Id, $championnat->getId());

                if ($dateRencontreEq2 == null) {

                    $dateRencontreEq2 = date_format($championnat->getDateDebut(), 'Y-m-d');
                    $date_temp = strtotime($dateRencontreEq2);
                    $date_temp = strtotime('-5 days', $date_temp); // On retire 5 jours pour s'aligner sur la bonne date de début dans les process suivants
                    $dateRencontreEq2 = date('Y-m-d', $date_temp);
                    $sw_debut_championnat_eq2 = 1;
                }

                if ($dateRencontreEq1 >= $dateRencontreEq2) {
                    $dateReference = $dateRencontreEq1;
                } else {
                    $dateReference = $dateRencontreEq2;
                }

                //if ($dateReference <> date_format($championnat->getDateDebut(),'Y-m-d')){
                if ($sw_debut_championnat_eq1 == 1 and $sw_debut_championnat_eq2 == 1) {

                    $date_borne_inferieure = $dateReference;
                } else {
                    $date_temp = strtotime($dateReference);
                    $date_temp = strtotime('+10 days', $date_temp); // On ajoute x jours
                    $date_borne_inferieure = date('Y-m-d', $date_temp);
                    //$date_borne_inferieure = $date_temp;                    
                }

                // Recherche des contraintes de type "jours" des équipes de la rencontre
                $ContrainteJourEquipesExclusion = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesJour('E', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                $ContrainteJourEquipesInclusion = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesJour('I', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                // Recherche des contraintes de type "salles" des équipes de la rencontre
                $ContrainteSalleEquipesExclusion = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesSalle('E', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());

                $ContrainteSalleEquipesInclusion = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChContrainte')
                    ->getChEquipesContraintesSalle('I', $renc->chEquipe1Id, $renc->chEquipe2Id, $championnat->getId());


                $itemJour = array();

                if ($ContrainteJourEquipesExclusion) { // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteJourEquipesExclusion as $keys => $jour) {

                        $itemJour[] = '"' . $jour->getJour() . '"';
                    }

                    $contraintesJourExclusionCh = join(', ', $itemJour);  // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesJourExclusionCh = 0; // Si aucune contrainte trouvée
                }

                $itemJour = array();

                if ($ContrainteJourEquipesInclusion) { // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteJourEquipesInclusion as $keys => $jour) {

                        $itemJour[] = '"' . $jour->getJour() . '"';
                    }

                    $contraintesJourInclusionCh = join(', ', $itemJour);  // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesJourInclusionCh = 0; // Si aucune contrainte trouvée
                }

                $itemSalle = array();

                if ($ContrainteSalleEquipesExclusion) {  // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteSalleEquipesExclusion as $keys => $salle) {

                        $itemSalle[] = '"' . $salle->getChsalleId()->getId() . '"';
                    }

                    $contraintesSalleExclusionCh = join(', ', $itemSalle); // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesSalleExclusionCh = 0;  // Si aucune contrainte trouvée
                }

                $itemSalle = array();

                if ($ContrainteSalleEquipesInclusion) {  // Si au moins une contrainte a été trouvée

                    foreach ($ContrainteSalleEquipesInclusion as $keys => $salle) {

                        $itemSalle[] = '"' . $salle->getChsalleId()->getId() . '"';
                    }

                    $contraintesSalleInclusionCh = join(', ', $itemSalle); // crée une chaine de caractère ("..","..","..")
                } else {

                    $contraintesSalleInclusionCh = 0;  // Si aucune contrainte trouvée
                }

                // Recherche un slot pour la rencontre
                $slotRencontre = $this->getContainer()->get('doctrine')->getManager()
                    ->getRepository('swsBackBundle:ChPlanning')
                    ->getSlotRencontre(
                        $championnat->getId(),
                        //$date_borne_inferieure,
                        $dateReference,
                        $contraintesSalleExclusionCh,
                        $contraintesSalleInclusionCh,
                        $contraintesJourExclusionCh,
                        $contraintesJourInclusionCh
                    );

                if (!empty($slotRencontre)) {

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChPlanning');
                    $ChPlanningCh = $repository->find($slotRencontre[0]->getId());

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisitee = $repository->find($renc->chEquipe1Id);
                    $ChPlanningCh->setChequipeVisiteeId($ChEquipeChVisitee);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisitee = $repository->find($renc->corposEquipe1);
                    $ChPlanningCh->setChcorporationVisiteeId($ChCorporationVisitee);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisiteuse = $repository->find($renc->chEquipe2Id);
                    $ChPlanningCh->setChequipeVisiteuseId($ChEquipeChVisiteuse);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisiteuse = $repository->find($renc->corposEquipe2);
                    $ChPlanningCh->setChcorporationVisiteuseId($ChCorporationVisiteuse);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChDivision');
                    $ChDivisionCh = $repository->find($renc->chDivisionsId);
                    $ChPlanningCh->setChdivisionId($ChDivisionCh);

                    $ChPlanningCh->setStatus('N');

                    $em->persist($ChPlanningCh);
                    $em->flush();

                    $nb_Updated++;
                } else {

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:Championnat');
                    $Championnat = $repository->find($championnat->getId());

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisitee = $repository->find($renc->chEquipe1Id);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisitee = $repository->find($renc->corposEquipe1);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChEquipe');
                    $ChEquipeChVisiteuse = $repository->find($renc->chEquipe2Id);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChCorporation');
                    $ChCorporationVisiteuse = $repository->find($renc->corposEquipe2);

                    $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChDivision');
                    $ChDivisionCh = $repository->find($renc->chDivisionsId);

                    $rencontreRejected = new ChRencontreReject();
                    $rencontreRejected->setChampionnatId($Championnat);
                    $rencontreRejected->setNbContrainte($renc->nbContraintes);
                    $rencontreRejected->setChequipeVisiteeId($ChEquipeChVisitee);
                    $rencontreRejected->setChcorporationVisiteeId($ChCorporationVisitee);
                    $rencontreRejected->setChequipeVisiteuseId($ChEquipeChVisiteuse);
                    $rencontreRejected->setChcorporationVisiteuseId($ChCorporationVisiteuse);
                    $rencontreRejected->setChdivisionId($ChDivisionCh);

                    $em->persist($rencontreRejected);
                    $em->flush();

                    $nb_reject++;
                }
            }


            $traitement++;

        } while ($traitement < 3);

        $session->set('progress', '80');

        $repository = $this->getContainer()->get('doctrine')->getManager()->getRepository('swsBackBundle:ChParametres');
        $chparametres = $repository->findOneBy(array('championnat_id' => $idChampionnat));
        $chparametres->setConfirmed('N');
        $em->persist($chparametres);
        $em->flush();

        // Paramètrage des onglets

        $session = new Session();
        $session->set('onglet', 'bord');

        $em->getConnection()->commit();

        $session->set('progress', 100);
        
    }
}